/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

public class TypeDeclaration
implements ITypeDeclaration {
    private boolean array;
    private Object genericType;
    private ITypeDeclaration[] genericTypes;
    private final IType type;
    private ITypeRepository typeRepository;
    private int dimensionality = -1;

    TypeDeclaration(ITypeRepository typeRepository, IType type, Object genericType, boolean array) {
        this.type = type;
        this.array = array;
        this.genericType = genericType;
        this.typeRepository = typeRepository;
    }

    TypeDeclaration(IType type, ITypeDeclaration[] genericTypes, int dimensionality) {
        this.type = type;
        this.genericTypes = genericTypes;
        this.dimensionality = dimensionality;
        this.array = dimensionality > 0;
    }

    private String buildArrayTypeName(String arrayTypeName) {
        StringBuilder sb = new StringBuilder();
        int index = arrayTypeName.indexOf(91);
        int dimens = (arrayTypeName.length() - index) / 2;
        String typeName = arrayTypeName.substring(0, index);
        while (--dimens >= 0) {
            sb.append("[");
        }
        String elementType = this.elementType(typeName);
        sb.append(elementType);
        sb.append(typeName);
        if (elementType.equals("L")) {
            sb.append(";");
        }
        return sb.toString();
    }

    private ITypeDeclaration[] buildParameterTypes() {
        ArrayList<TypeDeclaration> parameterTypes;
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            parameterTypes = new ArrayList<TypeDeclaration>();
                            if (!(this.genericType instanceof ParameterizedType)) break block3;
                            ParameterizedType parameterizedType = (ParameterizedType)this.genericType;
                            for (Type tp : parameterizedType.getActualTypeArguments()) {
                                TypeDeclaration typeParameter = this.buildTypeDeclaration(tp);
                                parameterTypes.add(typeParameter);
                            }
                            break block4;
                        }
                        if (!(this.genericType instanceof GenericArrayType)) break block5;
                        GenericArrayType genericArrayType = (GenericArrayType)this.genericType;
                        parameterTypes.add(this.buildTypeDeclaration(genericArrayType.getGenericComponentType()));
                        break block4;
                    }
                    if (this.genericType.getClass() != Class.class) break block6;
                    TypeDeclaration typeParameter = new TypeDeclaration(this.typeRepository, this.typeRepository.getType((Class)this.genericType), null, ((Class)this.genericType).isArray());
                    parameterTypes.add(typeParameter);
                    break block4;
                }
                if (this.genericType.getClass() != Class[].class) break block7;
                for (Class javaType : (Class[])this.genericType) {
                    TypeDeclaration typeParameter = new TypeDeclaration(this.typeRepository, this.typeRepository.getType(javaType), null, javaType.isArray());
                    parameterTypes.add(typeParameter);
                }
                break block4;
            }
            if (this.genericType.getClass() != IType[].class) break block4;
            for (IType tp : (IType[])this.genericType) {
                TypeDeclaration typeParameter = new TypeDeclaration(this.typeRepository, tp, null, false);
                parameterTypes.add(typeParameter);
            }
        }
        return parameterTypes.toArray(new ITypeDeclaration[parameterTypes.size()]);
    }

    private TypeDeclaration buildTypeDeclaration(Object genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return this.buildTypeDeclaration(parameterizedType.getRawType());
        }
        if (genericType instanceof TypeVariable) {
            int n = 0;
            TypeVariable typeVariable = (TypeVariable)genericType;
            Type[] typeArray = typeVariable.getBounds();
            int n2 = typeArray.length;
            if (n < n2) {
                Type tp = typeArray[n];
                return this.buildTypeDeclaration(tp);
            }
            return new TypeDeclaration(this.typeRepository, this.typeRepository.getType(Object.class), null, Object.class.isArray());
        }
        if (genericType instanceof WildcardType) {
            int n = 0;
            WildcardType wildcardType = (WildcardType)genericType;
            Type[] typeArray = wildcardType.getUpperBounds();
            int n3 = typeArray.length;
            if (n < n3) {
                Type tp = typeArray[n];
                return this.buildTypeDeclaration(tp);
            }
            return new TypeDeclaration(this.typeRepository, this.typeRepository.getType(Object.class), null, Object.class.isArray());
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            String arrayTypeName = this.buildArrayTypeName(genericArrayType.toString());
            IType arrayType = this.typeRepository.getType(arrayTypeName);
            return new TypeDeclaration(this.typeRepository, arrayType, genericArrayType.getGenericComponentType(), true);
        }
        return new TypeDeclaration(this.typeRepository, this.typeRepository.getType((Class)genericType), null, ((Class)genericType).isArray());
    }

    private String elementType(String typeName) {
        if (typeName.equals("boolean")) {
            return "Z";
        }
        if (typeName.equals("byte") || typeName.equals("char") || typeName.equals("double") || typeName.equals("float") || typeName.equals("int") || typeName.equals("short")) {
            return Character.toString(typeName.charAt(0)).toUpperCase();
        }
        if (typeName.equals("long")) {
            return "J";
        }
        return "L";
    }

    public int getDimensionality() {
        if (this.dimensionality < 0 && this.array) {
            String name = this.type.getName();
            this.dimensionality = 0;
            while (name.charAt(this.dimensionality) == '[') {
                ++this.dimensionality;
            }
        }
        return this.dimensionality;
    }

    public IType getType() {
        return this.type;
    }

    public ITypeDeclaration[] getTypeParameters() {
        if (this.genericTypes == null) {
            this.genericTypes = this.genericType == null ? new ITypeDeclaration[0] : this.buildParameterTypes();
        }
        return this.genericTypes;
    }

    public boolean isArray() {
        return this.array;
    }
}

