/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.appsrvapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;

public class PortDetector {
    private static final int PORT_CHECK_TIMEOUT = 4000;
    public static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 99, 111, 109, 95, 115, 117, 110, 95, 119, 101, 98, 95, 117, 105, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block10: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(hostname, port), 4000);
                socket.setSoTimeout(4000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block10;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        byte[] input = new byte[8192];
        istream.read(input);
        socket.close();
        String response = new String(input).toLowerCase(Locale.ENGLISH);
        boolean isSecure = true;
        if (response.length() == 0) {
            throw new ConnectException();
        }
        if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("</html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }

    public static void main(String[] args) throws IOException {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        System.out.println("host:  port: " + port);
        System.out.println("isSecure: " + PortDetector.isSecurePort(host, port));
    }
}

