/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.WrappedTargetModuleID;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JB7Deployer
extends JBDeployer {
    private static final Logger LOGGER = Logger.getLogger(JB7Deployer.class.getName());
    protected TargetModuleID deployedModuleID;

    public JB7Deployer(String serverUri, JBDeploymentManager dm) {
        super(serverUri, dm);
    }

    public static String deployFile(File file, File deployDir) throws IOException, InterruptedException {
        FileObject foIn = FileUtil.toFileObject((File)file);
        FileObject foDestDir = FileUtil.toFileObject((File)deployDir);
        if (foIn == null) {
            return NbBundle.getMessage(JB7Deployer.class, (String)"MSG_DeployFileMissing", (Object)file.getAbsolutePath());
        }
        if (foDestDir == null) {
            return NbBundle.getMessage(JB7Deployer.class, (String)"MSG_DeployDirMissing", (Object)deployDir.getAbsolutePath());
        }
        File toDeploy = new File(deployDir + File.separator + file.getName());
        FileUtil.copyFile((FileObject)foIn, (FileObject)foDestDir, (String)foIn.getName());
        long deployTime = toDeploy.lastModified();
        File statusFile = new File(deployDir, file.getName() + ".deployed");
        File failedFile = new File(deployDir, file.getName() + ".failed");
        File progressFile = new File(deployDir, file.getName() + ".isdeploying");
        int i = 0;
        int limit = 60;
        do {
            Thread.sleep(1000L);
        } while (++i < limit && progressFile.exists() || (!statusFile.exists() || statusFile.lastModified() < deployTime) && (!failedFile.exists() || failedFile.lastModified() < deployTime));
        if (failedFile.isFile()) {
            FileObject fo = FileUtil.toFileObject((File)failedFile);
            if (fo != null) {
                return fo.asText();
            }
            return NbBundle.getMessage(JBDeployer.class, (String)"MSG_FAILED");
        }
        if (!statusFile.isFile()) {
            return NbBundle.getMessage(JBDeployer.class, (String)"MSG_TIMEOUT");
        }
        return null;
    }

    @Override
    public void run() {
        String deployDir = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("deploy-dir");
        String fileName = this.file.getName();
        File toDeploy = new File(deployDir + File.separator + fileName);
        if (toDeploy.exists()) {
            toDeploy.delete();
        }
        String msg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
        try {
            String message;
            TargetModuleID[] ch;
            String webUrl = this.mainModuleID.getWebURL();
            if (webUrl == null && (ch = this.mainModuleID.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ch.length && (webUrl = ch[i].getWebURL()) == null; ++i) {
                }
            }
            if ((message = JB7Deployer.deployFile(this.file, new File(deployDir))) != null) {
                this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, message));
                return;
            }
            final String finalWebUrl = webUrl;
            this.dm.invokeLocalAction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TargetModuleID[] modules;
                    Target[] targets = JB7Deployer.this.dm.getTargets();
                    ModuleType moduleType = JB7Deployer.this.getModuleType(JB7Deployer.this.file.getName().substring(JB7Deployer.this.file.getName().lastIndexOf(".") + 1));
                    for (TargetModuleID targetModuleID : modules = JB7Deployer.this.dm.getAvailableModules(moduleType, targets)) {
                        if (!targetModuleID.getModuleID().equals(JB7Deployer.this.mainModuleID.getModuleID())) continue;
                        JB7Deployer.this.deployedModuleID = new WrappedTargetModuleID(targetModuleID, finalWebUrl, null, null);
                        break;
                    }
                    return null;
                }
            });
            if (webUrl != null) {
                URL url = new URL(webUrl);
                String waitingMsg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (MissingResourceException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    private ModuleType getModuleType(String extension) {
        if (extension.equals("war")) {
            return ModuleType.WAR;
        }
        if (extension.equals("ear")) {
            return ModuleType.EAR;
        }
        if (extension.equals("car")) {
            return ModuleType.CAR;
        }
        if (extension.equals("ejb")) {
            return ModuleType.EJB;
        }
        if (extension.equals("rar")) {
            return ModuleType.RAR;
        }
        return null;
    }

    @Override
    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.deployedModuleID != null ? this.deployedModuleID : this.mainModuleID};
    }
}

