/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Objects;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class MethodImpl<T>
extends FunctionImpl<T>
implements CsmMethod {
    private final CsmVisibility visibility;
    private static final short ABSTRACT = 32;
    private static final short VIRTUAL = 64;
    private static final short EXPLICIT = 128;
    private static final short OVERRIDE = 256;
    private static final short FINAL = 512;

    protected MethodImpl(CharSequence name, CharSequence rawName, CsmClass cls, CsmVisibility visibility, boolean _virtual, boolean _override, boolean _final, boolean _explicit, boolean _static, boolean _const, boolean _abstract, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, (CsmScope)cls, _static, _const, file, startOffset, endOffset, global);
        this.visibility = visibility;
        this.setVirtual(_virtual);
        this.setOverride(_override);
        this.setFinal(_final);
        this.setExplicit(_explicit);
        this.setAbstract(_abstract);
    }

    public static <T> MethodImpl<T> create(AST ast, CsmFile file, FileContent fileContent, ClassImpl cls, CsmVisibility visibility, boolean global) throws AstRendererException {
        int startOffset = MethodImpl.getStartOffset(ast);
        int endOffset = MethodImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            AstRendererException.throwAstRendererException((FileImpl)file, ast, startOffset, "Empty function name.");
        }
        CharSequence rawName = MethodImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, fileContent, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        boolean _virtual = false;
        boolean _override = false;
        boolean _final = false;
        boolean _explicit = false;
        boolean afterParen = false;
        boolean _abstract = false;
        block9: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 134: {
                    _static = true;
                    continue block9;
                }
                case 126: {
                    _virtual = true;
                    continue block9;
                }
                case 226: {
                    _override = true;
                    continue block9;
                }
                case 225: {
                    _final = true;
                    continue block9;
                }
                case 127: {
                    _explicit = true;
                    continue block9;
                }
                case 13: {
                    afterParen = true;
                    continue block9;
                }
                case 6: {
                    if (!afterParen) continue block9;
                    _abstract = true;
                }
            }
        }
        MethodImpl<T> methodImpl = new MethodImpl<T>(name, rawName, cls, visibility, _virtual, _override, _final, _explicit, _static, _const, _abstract, file, startOffset, endOffset, global);
        MethodImpl.temporaryRepositoryRegistration(ast, global, methodImpl);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = MethodImpl.createTemplateDescriptor(ast, file, methodImpl, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        methodImpl.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        methodImpl.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, methodImpl, file));
        methodImpl.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, methodImpl, file, fileContent), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        MethodImpl.postObjectCreateRegistration(global, methodImpl);
        nameHolder.addReference(fileContent, methodImpl);
        return methodImpl;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.getScope();
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.hasFlags((short)32);
    }

    private void setAbstract(boolean _abstract) {
        this.setFlags((short)32, _abstract);
    }

    private void setVirtual(boolean _virtual) {
        this.setFlags((short)64, _virtual);
    }

    private void setOverride(boolean _override) {
        this.setFlags((short)256, _override);
    }

    private void setFinal(boolean _final) {
        this.setFlags((short)512, _final);
    }

    private void setExplicit(boolean _explicit) {
        this.setFlags((short)128, _explicit);
    }

    public boolean isExplicit() {
        return this.hasFlags((short)128);
    }

    public boolean isVirtual() {
        return this.hasFlags((short)64);
    }

    public boolean isOverride() {
        return this.hasFlags((short)256);
    }

    public boolean isFinal() {
        return this.hasFlags((short)512);
    }

    @Override
    public boolean isConst() {
        return super.isConst();
    }

    @Override
    protected CharSequence createUIDExtraSuffix(AST ast) {
        CharSequence funSuffix = super.createUIDExtraSuffix(ast);
        if (CsmKindUtilities.isMethodDeclaration((CsmObject)this)) {
            CsmFile clsFile;
            CsmClass cls = this.getContainingClass();
            CsmFile csmFile = clsFile = cls != null ? cls.getContainingFile() : null;
            if (cls != null && clsFile != null && !Objects.equals(clsFile, this.getContainingFile())) {
                String mtdSuffix;
                StringBuilder sb = new StringBuilder("###");
                sb.append(cls.getName());
                sb.append("_");
                if (clsFile instanceof FileImpl) {
                    sb.append(((FileImpl)clsFile).getFileId());
                } else {
                    sb.append(clsFile.getName());
                }
                if (funSuffix != null) {
                    sb.append(funSuffix);
                }
                if ((mtdSuffix = sb.toString()).length() > 64) {
                    mtdSuffix = mtdSuffix.substring(0, 64) + "<truncated>";
                }
                return mtdSuffix;
            }
        }
        return funSuffix;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeVisibility(this.visibility, output);
    }

    public MethodImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.visibility = PersistentUtils.readVisibility(input);
    }

    public static class MethodBuilder
    extends FunctionImpl.FunctionBuilder
    implements ClassImpl.MemberBuilder {
        private final boolean _virtual = false;
        private final boolean _explicit = false;
        private CsmVisibility visibility = CsmVisibility.PUBLIC;

        protected MethodBuilder() {
        }

        public MethodBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
            super(builder);
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        @Override
        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public boolean isVirtual() {
            return false;
        }

        public boolean isExplicit() {
            return false;
        }

        public MethodImpl create(CsmParserProvider.ParserErrorDelegate delegate) {
            FunctionParameterListImpl.FunctionParameterListBuilder parameters = (FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder();
            if (parameters == null) {
                return null;
            }
            CsmClass cls = (CsmClass)this.getScope();
            MethodImpl method = new MethodImpl(this.getName(), this.getRawName(), cls, this.getVisibility(), this.isVirtual(), false, false, this.isExplicit(), this.isStatic(), this.isConst(), false, this.getFile(), this.getStartOffset(), this.getEndOffset(), true);
            MethodImpl.temporaryRepositoryRegistration(true, method);
            if (this.getTemplateDescriptorBuilder() != null) {
                method.setTemplateDescriptor(this.getTemplateDescriptor(), NameCache.getManager().getString(CharSequences.create((CharSequence)"")));
            }
            method.setReturnType(this.getType());
            parameters.setScope((CsmScope)method);
            method.setParameters(parameters.create(), true);
            MethodImpl.postObjectCreateRegistration(true, method);
            this.getNameHolder().addReference(this.getFileContent(), method);
            return method;
        }
    }
}

