/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.wizard.FindWizardPanel;
import org.netbeans.modules.mobility.cldcplatform.wizard.SearchRunnable;
import org.netbeans.modules.mobility.cldcplatform.wizard.WindowsRegistryReader;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class FindPanel
extends JPanel
implements SearchRunnable.Notifier {
    static final String PROP_PLATFORM_FOLDERS = "PlatformFolders";
    private static final String ALREADY_INSTALLED = NbBundle.getMessage(FindPanel.class, (String)"msg_already_installed");
    private final DefaultListModel platformsListModel = new DefaultListModel();
    private final CheckListener checkListener = new CheckListener();
    private final FoldersRenderer foldersRenderer = new FoldersRenderer();
    private final Set<File> selectedFolders = new HashSet<File>();
    private final Set<File> installedFolders = new HashSet<File>();
    private final FindWizardPanel wizardPanel;
    private RequestProcessor.Task searchTask;
    private SearchRunnable searchRunnable;
    private Set<File> visitedDirectories = null;
    private WizardDescriptor wizardDescriptor;
    private JButton jButton1;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JList platformsList;

    public FindPanel(FindWizardPanel wizardPanel) {
        JavaPlatform[] p;
        this.wizardPanel = wizardPanel;
        for (JavaPlatform jp : p = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!(jp instanceof J2MEPlatform)) continue;
            for (FileObject fo : jp.getInstallFolders()) {
                this.installedFolders.add(FileUtil.toFile((FileObject)fo));
            }
        }
        this.initComponents();
        this.platformsList.addMouseListener(this.checkListener);
        this.platformsList.addKeyListener(this.checkListener);
    }

    public void showError(String message) {
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
        }
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.platformsList = new JList();
        this.jButton1 = new JButton();
        this.setName(NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Platforms"));
        this.setPreferredSize(new Dimension(540, 450));
        this.setLayout(new GridBagLayout());
        this.jLabel5.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Select_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindPanel.class, (String)"ACSD_FindPanel_Select_Platform"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 150));
        this.platformsList.setModel(this.platformsListModel);
        this.platformsList.setSelectionMode(0);
        this.platformsList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane1.setViewportView(this.platformsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Find_More"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindPanel.class, (String)"ACSD_FindPanel_Find_More"));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.searchTask != null && !this.searchTask.isFinished()) {
            return;
        }
        String aDescription = NbBundle.getMessage(FindPanel.class, (String)"AD_LocationChooser");
        String title = NbBundle.getMessage(FindPanel.class, (String)"Title_FindPanel_Choose_To_Search");
        Badger badger = new Badger();
        File dir = new FileChooserBuilder(this.getClass().getName()).setDirectoriesOnly(true).setTitle(title).setAccessibleDescription(aDescription).setBadgeProvider((FileChooserBuilder.BadgeProvider)badger).setDefaultWorkingDirectory(File.listRoots().length > 0 ? File.listRoots()[0] : null).setFileFilter((FileFilter)badger).showOpenDialog();
        if (dir != null) {
            this.searchRunnable = new SearchRunnable((SearchRunnable.Notifier)this, dir, -1);
            this.jButton1.setEnabled(false);
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"WARN_SearchInProgress"));
            this.searchTask = RequestProcessor.getDefault().post((Runnable)this.searchRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings(WizardDescriptor descriptor) {
        this.wizardDescriptor = descriptor;
        if (this.visitedDirectories == null) {
            this.visitedDirectories = new HashSet<File>();
            this.jButton1.setEnabled(false);
            DefaultListModel defaultListModel = this.platformsListModel;
            synchronized (defaultListModel) {
                this.platformsListModel.clear();
            }
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"WARN_SearchInProgress"));
            this.searchRunnable = new SearchRunnable((SearchRunnable.Notifier)this, WindowsRegistryReader.traverseRegistry(), 3);
            this.searchTask = RequestProcessor.getDefault().post((Runnable)this.searchRunnable);
        }
    }

    public void storeSettings(WizardDescriptor descriptor) {
        if (this.searchRunnable != null) {
            this.searchRunnable.stop();
            this.searchTask.waitFinished();
            this.searchRunnable = null;
            this.searchTask = null;
        }
        descriptor.putProperty(PROP_PLATFORM_FOLDERS, this.selectedFolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPossiblePlatformFound(File directory) {
        if (this.visitedDirectories.contains(directory)) {
            return;
        }
        this.visitedDirectories.add(directory);
        if (!this.installedFolders.contains(directory)) {
            this.selectedFolders.add(directory);
        }
        DefaultListModel defaultListModel = this.platformsListModel;
        synchronized (defaultListModel) {
            this.platformsListModel.addElement(directory);
        }
        int i = this.platformsListModel.size() - 1;
        Rectangle r = this.platformsList.getCellBounds(i, i);
        if (r != null) {
            this.platformsList.scrollRectToVisible(r);
        }
        this.wizardPanel.fireChanged();
    }

    @Override
    public void notifySearchFinished() {
        this.jButton1.setEnabled(true);
        this.wizardPanel.fireChanged();
        if (this.platformsListModel.isEmpty()) {
            this.jButton1ActionPerformed(null);
        }
    }

    public boolean isStateValid() {
        if (this.selectedFolders.isEmpty()) {
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"ERR_NothingSelected"));
            return false;
        }
        this.showError(null);
        return true;
    }

    private class FoldersRenderer
    extends JCheckBox
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public FoldersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? FindPanel.this.platformsList.getSelectionBackground() : FindPanel.this.platformsList.getBackground());
            this.setForeground(isSelected ? FindPanel.this.platformsList.getSelectionForeground() : FindPanel.this.platformsList.getForeground());
            Border border = null;
            if (cellHasFocus) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            this.setSelected(FindPanel.this.selectedFolders.contains(value));
            if (FindPanel.this.installedFolders.contains(value)) {
                this.setText(value.toString() + ALREADY_INSTALLED);
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getX() < 20) {
                this.check();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.check();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void check() {
            File o = (File)FindPanel.this.platformsList.getSelectedValue();
            if (o != null) {
                if (!FindPanel.this.selectedFolders.remove(o)) {
                    FindPanel.this.selectedFolders.add(o);
                }
                FindPanel.this.platformsList.repaint();
                FindPanel.this.wizardPanel.fireChanged();
            }
        }
    }

    private static final class Badger
    extends FileFilter
    implements FileChooserBuilder.BadgeProvider {
        final Icon badge = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/platform/resources/platformBadge.gif", (boolean)false);

        private Badger() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(Badger.class, (String)"TXT_PlatformFolder");
        }

        public Icon getBadge(File file) {
            if (this.isPlatformDir(file)) {
                return this.badge;
            }
            return null;
        }

        public int getXOffset() {
            return -1;
        }

        public int getYOffset() {
            return -1;
        }

        private boolean isPlatformDir(File f) {
            FileObject fo;
            int osId = Utilities.getOperatingSystem();
            if (osId == 8 || osId == 256) {
                return false;
            }
            FileObject fileObject = fo = f != null ? Badger.convertToValidDir(f) : null;
            if (fo != null) {
                try {
                    if (Utilities.isUnix() && (fo.getParent() == null || fo.getFileSystem().getRoot().equals(fo.getParent()))) {
                        return false;
                    }
                }
                catch (FileStateInvalidException e) {
                    return false;
                }
                return this.isPossibleJ2MEPlatform(FileUtil.toFile((FileObject)fo));
            }
            return false;
        }

        public boolean isPossibleJ2MEPlatform(File directory) {
            Collection customConfigurators = Lookup.getDefault().lookupAll(CustomCLDCPlatformConfigurator.class);
            for (CustomCLDCPlatformConfigurator pc : customConfigurators) {
                if (!pc.isPossiblePlatform(directory)) continue;
                return true;
            }
            FileObject dir = FileUtil.toFileObject((File)directory);
            return dir != null && (J2MEPlatform.isJavaME3Platform(dir) || J2MEPlatform.isJavaME8Platform(dir));
        }

        private static FileObject convertToValidDir(File f) {
            File testFile = new File(f.getPath());
            if (testFile == null || testFile.getParent() == null) {
                return null;
            }
            if (!testFile.isDirectory()) {
                return null;
            }
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            return fo;
        }
    }
}

