/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.Locale;
import org.codehaus.plexus.logging.AbstractLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class MavenLoggerManager
extends AbstractLoggerManager
implements LoggerManager,
Initializable {
    private String threshold = "info";
    private int currentThreshold;
    private Logger logger;

    public MavenLoggerManager(Logger logger) {
        this.logger = logger;
    }

    public void initialize() {
        this.debug("Initializing ConsoleLoggerManager: " + ((Object)((Object)this)).hashCode() + ".");
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.debug("Could not parse the threshold level: '" + this.threshold + "', setting to debug.");
            this.currentThreshold = 0;
        }
    }

    public void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    public void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        this.logger.setThreshold(currentThreshold);
    }

    public int getThreshold() {
        return this.currentThreshold;
    }

    public void setThreshold(String role, String roleHint, int threshold) {
    }

    public int getThreshold(String role, String roleHint) {
        return this.currentThreshold;
    }

    public Logger getLoggerForComponent(String role, String roleHint) {
        return this.logger;
    }

    public void returnComponentLogger(String role, String roleHint) {
    }

    public int getActiveLoggerCount() {
        return 1;
    }

    private int parseThreshold(String text) {
        if ((text = text.trim().toLowerCase(Locale.ENGLISH)).equals("debug")) {
            return 0;
        }
        if (text.equals("info")) {
            return 1;
        }
        if (text.equals("warn")) {
            return 2;
        }
        if (text.equals("error")) {
            return 3;
        }
        if (text.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    private void debug(String msg) {
    }
}

