/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

public class PackagerFileElement {
    private FileType type;
    private String from;
    private String to;
    private String permission;
    private String owner;
    private String group;
    private boolean defaultValue;

    public PackagerFileElement(FileType type, String from, String to) {
        this.type = type;
        this.from = from;
        this.to = to;
        this.permission = "";
        this.owner = "";
        this.group = "";
        this.defaultValue = false;
    }

    public PackagerFileElement(FileType type, String from, String to, String permission, String owner, String group) {
        this.type = type;
        this.from = from;
        this.to = to;
        this.permission = permission;
        this.owner = owner;
        this.group = group;
        this.defaultValue = false;
    }

    public FileType getType() {
        return this.type;
    }

    public static FileType toFileType(String type) {
        if (FileType.DIRECTORY.toString().equals(type)) {
            return FileType.DIRECTORY;
        }
        if (FileType.FILE.toString().equals(type)) {
            return FileType.FILE;
        }
        if (FileType.SOFTLINK.toString().equals(type)) {
            return FileType.SOFTLINK;
        }
        return FileType.UNKNOWN;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static enum FileType {
        FILE{

            public String toString() {
                return "File";
            }
        }
        ,
        DIRECTORY{

            public String toString() {
                return "Dir";
            }
        }
        ,
        SOFTLINK{

            public String toString() {
                return "Link";
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return "";
            }
        };

    }
}

