/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.cnd.api.xml.LineSeparatorDetector;
import org.netbeans.modules.cnd.api.xml.XMLDocWriter;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.MakeProjectImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.support.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.configurations.AuxConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.lookup.Lookups;

public class ConfigurationXMLWriter
extends XMLDocWriter {
    private final FileObject projectDirectory;
    private final MakeConfigurationDescriptor projectDescriptor;
    private CommonConfigurationXMLCodec encoder;

    public ConfigurationXMLWriter(FileObject projectDirectory, MakeConfigurationDescriptor projectDescriptor) {
        this.projectDirectory = projectDirectory;
        this.projectDescriptor = projectDescriptor;
    }

    public void write() throws IOException {
        if (this.projectDescriptor == null) {
            return;
        }
        String tag = "configurationDescriptor";
        this.encoder = new ConfigurationXMLCodec(tag, null, this.projectDescriptor, null);
        assert (this.projectDescriptor.getState() != ConfigurationDescriptor.State.READING);
        this.write("nbproject/configurations.xml");
        this.encoder = new AuxConfigurationXMLCodec(tag, this.projectDescriptor);
        this.write("nbproject/private/configurations.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String relPath) throws IOException {
        this.setLineSeparator(new LineSeparatorDetector(this.projectDirectory.getFileObject(relPath), this.projectDirectory).getInitialSeparator());
        FileObject xml = FileUtil.createData((FileObject)this.projectDirectory, (String)relPath);
        try {
            FileLock lock = xml.lock();
            try {
                OutputStream os = SmartOutputStream.getSmartOutputStream(xml, lock);
                this.setMasterComment(((MakeProjectImpl)this.projectDescriptor.getProject()).getConfigurationXMLComment());
                this.write(os);
            }
            finally {
                lock.releaseLock();
            }
            String customizerId = this.projectDescriptor.getActiveConfiguration() == null ? null : this.projectDescriptor.getActiveConfiguration().getCustomizerId();
            Lookups.forPath((String)MakeProjectTypeImpl.projectMetadataFactoryPath(customizerId)).lookupAll(ProjectMetadataFactory.class).forEach(f -> f.write(this.projectDirectory));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encode(XMLEncoderStream xes) {
        this.encoder.encode(xes);
    }
}

