/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.MercurialAnnotator;
import org.netbeans.modules.mercurial.remote.options.HgExtProperties;
import org.netbeans.modules.mercurial.remote.options.LabelsPanel;
import org.netbeans.modules.mercurial.remote.options.MercurialPanel;
import org.netbeans.modules.mercurial.remote.options.PropertiesPanel;
import org.netbeans.modules.mercurial.remote.options.PropertiesTable;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class MercurialOptionsPanelController
extends OptionsPanelController
implements ItemListener,
ActionListener,
VCSOptionsKeywordsProvider {
    private MercurialPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean changed;
    private FileSystem fileSystem;

    public MercurialOptionsPanelController() {
        FileSystem[] fileSystems = VCSFileProxySupport.getConnectedFileSystems();
        if (fileSystems.length > 0) {
            this.fileSystem = fileSystems[0];
        }
        this.panel = new MercurialPanel(this);
        this.panel.execPathBrowseButton.addActionListener(this);
        this.panel.exportFilenameBrowseButton.addActionListener(this);
        this.panel.cbBuildHost.addItemListener(this);
        this.panel.cbBuildHost.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof FileSystem) {
                    value = ((FileSystem)value).getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.panel.cbBuildHost.setModel(new DefaultComboBoxModel<FileSystem>(fileSystems));
        this.panel.fileSystemChanged(this.fileSystem);
        String tooltip = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.toolTipText", (Object[])MercurialAnnotator.LABELS.toArray(new String[MercurialAnnotator.LABELS.size()]));
        this.panel.annotationTextField.setToolTipText(tooltip);
        this.panel.addButton.addActionListener(this);
        this.panel.manageButton.addActionListener(this);
    }

    VCSFileProxy getRoot() {
        return VCSFileProxy.createFileProxy((FileObject)this.getFS().getRoot());
    }

    FileSystem getFS() {
        this.fileSystem = (FileSystem)this.panel.cbBuildHost.getSelectedItem();
        return this.fileSystem;
    }

    public void update() {
        FileSystem[] fileSystems = VCSFileProxySupport.getConnectedFileSystems();
        this.fileSystem = fileSystems.length > 0 ? fileSystems[0] : null;
        this.panel.cbBuildHost.setModel(new DefaultComboBoxModel<FileSystem>(fileSystems));
        if (this.fileSystem == null) {
            return;
        }
        this.getPanel().load();
        this.changed = false;
    }

    public void applyChanges() {
        if (this.getFS() == null) {
            return;
        }
        this.getPanel().store();
        Mercurial.getInstance().getMercurialAnnotator().refresh();
        Mercurial.getInstance().refreshAllAnnotations();
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        if (this.getFS() == null) {
            return true;
        }
        return this.validateFields();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MercurialOptionsPanelController.class);
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        Object item;
        if (ev.getStateChange() == 1 && (item = ev.getItem()) instanceof FileSystem) {
            this.fileSystem = (FileSystem)item;
            this.panel.fileSystemChanged(this.fileSystem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.getFS() == null) {
            return;
        }
        if (evt.getSource() == this.panel.execPathBrowseButton) {
            this.onExecPathBrowseClick();
        } else if (evt.getSource() == this.panel.exportFilenameBrowseButton) {
            this.onExportFilenameBrowseClick();
        } else if (evt.getSource() == this.panel.addButton) {
            this.onAddClick();
        } else if (evt.getSource() == this.panel.manageButton) {
            this.onManageClick();
        }
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    private VCSFileProxy getExportFile() {
        String exportPath = this.panel.exportFilenameTextField.getText();
        if (exportPath.startsWith("/")) {
            return VCSFileProxySupport.getResource((VCSFileProxy)this.getRoot(), (String)exportPath).normalizeFile();
        }
        return this.getRoot();
    }

    private VCSFileProxy getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        if (execPath.startsWith("/")) {
            return VCSFileProxySupport.getResource((VCSFileProxy)this.getRoot(), (String)execPath).normalizeFile();
        }
        return this.getRoot();
    }

    private boolean validateFields() {
        this.getPanel().showError(null);
        String username = this.panel.userNameTextField.getText();
        if (!HgModuleConfig.getDefault(this.getRoot()).isUserNameValid(username).booleanValue()) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_USER_NAME_TEXT"));
            return false;
        }
        String execpath = this.panel.executablePathTextField.getText();
        String hgExecutableParent = null;
        if (execpath.endsWith("hg")) {
            hgExecutableParent = execpath.substring(0, execpath.length() - "hg".length());
        }
        if (hgExecutableParent == null) {
            hgExecutableParent = execpath;
        }
        if (!HgModuleConfig.getDefault(this.getRoot()).isExecPathValid(hgExecutableParent).booleanValue()) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_EXEC_PATH_TEXT"));
            return false;
        }
        if (!HgUtils.isAnnotationFormatValid(HgUtils.createAnnotationFormat(this.panel.annotationTextField.getText()))) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_ANNOTATION_FORMAT_TEXT"));
            return false;
        }
        return true;
    }

    private void onExportFilenameBrowseClick() {
        VCSFileProxy oldFile = this.getExportFile();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ExportBrowse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            this.panel.exportFilenameTextField.setText(f.getPath());
        }
    }

    private void onExecPathBrowseClick() {
        if (this.getFS() == null) {
            return;
        }
        VCSFileProxy oldFile = this.getExecutableFile();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            this.panel.executablePathTextField.setText(f.getPath());
        }
    }

    private MercurialPanel getPanel() {
        if (this.panel == null) {
            this.panel = new MercurialPanel(this);
        }
        return this.panel;
    }

    void changed(boolean isChanged) {
        boolean oldValue = this.changed;
        this.changed = isChanged;
        if (this.changed != oldValue) {
            this.pcs.firePropertyChange("changed", oldValue, this.changed);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    private void onAddClick() {
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<LabelVariable> variables = new ArrayList<LabelVariable>(MercurialAnnotator.LABELS.size());
        for (int i = 0; i < MercurialAnnotator.LABELS.size(); ++i) {
            LabelVariable variable = new LabelVariable(MercurialAnnotator.LABELS.get(i), "{" + MercurialAnnotator.LABELS.get(i) + "} - " + NbBundle.getMessage(MercurialPanel.class, (String)("MercurialPanel.label." + MercurialAnnotator.LABELS.get(i))));
            variables.add(variable);
        }
        labelsPanel.labelsList.setListData(variables.toArray(new LabelVariable[variables.size()]));
        String title = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.title");
        String acsd = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            String variable = "";
            for (int i = 0; i < selection.length; ++i) {
                variable = variable + "{" + ((LabelVariable)selection[i]).getVariable() + "}";
            }
            String annotation = this.panel.annotationTextField.getText();
            int pos = this.panel.annotationTextField.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuilder sb = new StringBuilder(annotation.length() + variable.length());
            sb.append(annotation.substring(0, pos));
            sb.append(variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos, annotation.length()));
            }
            this.panel.annotationTextField.setText(sb.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(pos + variable.length());
        }
    }

    private void onManageClick() {
        PropertiesPanel panel = new PropertiesPanel(this.getFS());
        PropertiesTable propTable = new PropertiesTable(panel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        panel.setPropertiesTable(propTable);
        JComponent component = propTable.getComponent();
        panel.propsPanel.setLayout(new BorderLayout());
        panel.propsPanel.add((Component)component, "Center");
        HgExtProperties hgProperties = new HgExtProperties(panel, propTable, this.getFS());
        JButton okButton = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        JButton cancelButton = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title", null), true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, new HelpCtx(MercurialOptionsPanelController.class), null);
        panel.putClientProperty("contentTitle", null);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title"));
        dialog.pack();
        dialog.setVisible(true);
        if (dd.getValue() == okButton) {
            hgProperties.setProperties();
        }
    }

    private static class LabelVariable {
        private final String description;
        private final String variable;

        public LabelVariable(String variable, String description) {
            this.description = description;
            this.variable = variable;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

