/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.ignore;

import java.io.IOException;
import java.net.URI;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IgnoreAction
extends ContextAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (!HgUtils.isFromHgRepository(context) || ctxFiles == null || ctxFiles.isEmpty()) {
            return false;
        }
        return !HgUtils.onlyProjects(nodes);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Ignore";
    }

    public int getActionStatus(VCSFileProxy[] files) {
        int actionStatus = -1;
        if (files.length == 0) {
            return 0;
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".hg") || SharabilityQuery.getSharability((URI)VCSFileProxySupport.toURI((VCSFileProxy)files[i])) == SharabilityQuery.Sharability.NOT_SHARABLE) {
                actionStatus = 0;
                break;
            }
            FileInformation info = cache.getStatus(files[i]);
            if (info.getStatus() == 4 || info.getStatus() == 8 && info.isDirectory()) {
                if (actionStatus == 2) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 1;
                continue;
            }
            if (info.getStatus() == 2) {
                if (actionStatus == 1) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 2;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        if (context == null) {
            return;
        }
        final Set<VCSFileProxy> repositories = HgUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            return;
        }
        Set ctxFiles = context.getRootFiles();
        if (ctxFiles == null || ctxFiles.isEmpty()) {
            return;
        }
        VCSFileProxy repository = repositories.iterator().next();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                for (VCSFileProxy repository : repositories) {
                    VCSFileProxy[] files = HgUtils.filterForRepository(context, repository, true);
                    this.performIgnore(repository, files);
                }
            }

            private void performIgnore(VCSFileProxy repository, VCSFileProxy[] files) throws MissingResourceException {
                OutputLogger logger = this.getLogger();
                int mActionStatus = IgnoreAction.this.getActionStatus(files);
                try {
                    if (mActionStatus == 0) {
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_ONLY_LOCALLY_NEW"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                        logger.output("");
                        return;
                    }
                    if (mActionStatus == 1) {
                        HgUtils.addIgnored(repository, files);
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_INIT_SEP", (Object)repository.getName()));
                    } else {
                        HgUtils.removeIgnored(repository, files);
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_INIT_SEP", (Object)repository.getName()));
                    }
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.FINE, "IgnoreAction(): File {0} - {1}", new Object[]{repository.getPath(), ex.toString()});
                }
                for (VCSFileProxy file : files) {
                    Mercurial.getInstance().getFileStatusCache().refreshIgnores(file);
                    logger.output("\t" + file.getPath());
                }
                if (mActionStatus == 1) {
                    logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                } else {
                    logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_DONE"));
                }
                logger.output("");
            }
        };
        support.start(rp, repository, NbBundle.getMessage(IgnoreAction.class, (String)"LBL_Ignore_Progress"));
    }
}

