/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.log;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.WorkingCopyInfo;
import org.netbeans.modules.mercurial.remote.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.remote.ui.log.DiffResultsViewForLine;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.remote.ui.log.SearchHistoryAction;
import org.netbeans.modules.mercurial.remote.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.remote.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LogAction
extends SearchHistoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/search_history.png";

    public LogAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Log";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        this.openHistory(context, NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)VCSFileProxySupport.getContextDisplayName((VCSContext)context)));
    }

    private void openHistory(VCSContext context, String title) {
        VCSFileProxy repositoryRoot = this.getRepositoryRoot(context);
        VCSFileProxy[] files = LogAction.replaceCopiedFiles(this.getFiles(context, repositoryRoot));
        LogAction.openHistory(repositoryRoot, files, title, null);
    }

    public static void openHistory(VCSFileProxy repositoryRoot, VCSFileProxy[] files) {
        LogAction.openHistory(repositoryRoot, files, null);
    }

    public static void openHistory(VCSFileProxy repositoryRoot, VCSFileProxy[] files, String revision) {
        ArrayList<Node> nodes = new ArrayList<Node>(files.length);
        for (VCSFileProxy file : files) {
            DataObject dao;
            FileObject fo = file.toFileObject();
            if (fo == null) continue;
            try {
                dao = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            nodes.add(dao.getNodeDelegate());
        }
        if (nodes.isEmpty()) {
            return;
        }
        String title = NbBundle.getMessage(LogAction.class, (String)"MSG_Log_TabTitle", (Object)VCSFileProxySupport.getContextDisplayName((VCSContext)VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]))));
        LogAction.openHistory(repositoryRoot, files, title, revision);
    }

    private static void openHistory(final VCSFileProxy repositoryRoot, final VCSFileProxy[] files, final String title, final String revision) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                HgLogMessage[] parents;
                boolean startSearch;
                if (files == null) {
                    return;
                }
                SearchHistoryAction.outputSearchContextTab(repositoryRoot, files, "MSG_Log_Title");
                boolean bl = startSearch = files.length == 1 && !files[0].isDirectory() || files.length > 1 && VCSFileProxySupport.shareCommonDataObject((VCSFileProxy[])files);
                final String branchName = revision != null && !revision.isEmpty() ? "" : ((parents = WorkingCopyInfo.getInstance(repositoryRoot).getWorkingCopyParents()).length == 1 ? (parents[0].getBranches().length > 0 ? parents[0].getBranches()[0] : "default") : "");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(files, branchName, revision);
                        tc.setDisplayName(title);
                        tc.open();
                        tc.requestActive();
                        if (startSearch) {
                            tc.search(false);
                        }
                    }
                });
            }
        }, (int)0);
    }

    private static VCSFileProxy[] replaceCopiedFiles(VCSFileProxy[] files) {
        if (files == null) {
            return null;
        }
        LinkedHashSet<VCSFileProxy> originalFiles = new LinkedHashSet<VCSFileProxy>(files.length);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (VCSFileProxy file : files) {
            FileStatus st = cache.getStatus(file).getStatus(null);
            if (st != null && st.isCopied() && st.getOriginalFile() != null) {
                file = st.getOriginalFile();
            }
            originalFiles.add(file);
        }
        return originalFiles.toArray(new VCSFileProxy[originalFiles.size()]);
    }

    public static void openSearch(VCSFileProxy file, final int lineNumber) {
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(file, new SearchHistoryTopComponent.DiffResultsViewFactory(){

            @Override
            DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                return new DiffResultsViewForLine(panel, results, lineNumber);
            }
        });
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)file.getName());
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
        tc.search(true);
        tc.activateDiffView(true);
    }
}

