/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.Set;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.WeakSet;

public class MakeContext {
    private final Kind kind;
    private final Project project;
    private final ExecutionEnvironment env;
    private final Configuration[] selectedConfigurations;
    private SharedItemConfiguration[] items;
    private Folder[] folders;
    private JPanel container;
    private ConfigurationDescriptor configurationDescriptor;
    private final Set<Savable> listeners = new WeakSet();

    public MakeContext(Kind kind, Project project, ExecutionEnvironment env, Configuration[] selectedConfigurations) {
        this.project = project;
        this.kind = kind;
        this.env = env;
        this.selectedConfigurations = selectedConfigurations;
    }

    public MakeContext setPanel(JPanel container) {
        this.container = container;
        return this;
    }

    public MakeContext setConfigurationDescriptor(ConfigurationDescriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
        return this;
    }

    public MakeContext setFolders(Folder[] folders) {
        this.folders = folders;
        return this;
    }

    MakeContext setSharedItem(SharedItemConfiguration[] items) {
        this.items = items;
        return this;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Project getProject() {
        return this.project;
    }

    public ExecutionEnvironment getEnv() {
        return this.env;
    }

    public Configuration[] getSelectedConfigurations() {
        return this.selectedConfigurations;
    }

    SharedItemConfiguration[] getItems() {
        return this.items;
    }

    Folder[] getFolders() {
        return this.folders;
    }

    public JPanel getContainer() {
        return this.container;
    }

    public ConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void registerSavable(Savable listener) {
        this.listeners.add(listener);
    }

    public void save() {
        this.listeners.forEach(listener -> listener.save());
    }

    public boolean isCompilerConfiguration() {
        return ((MakeConfiguration)this.selectedConfigurations[0]).isCompileConfiguration();
    }

    public boolean isProc() {
        PredefinedToolKind itemTool = this.getItemsTool();
        if (itemTool == PredefinedToolKind.CCCompiler || itemTool == PredefinedToolKind.CCompiler) {
            for (SharedItemConfiguration item : this.items) {
                if (ItemConfiguration.isProCFile((Item)item.getItem(), (PredefinedToolKind)itemTool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public PredefinedToolKind getItemsTool() {
        PredefinedToolKind result = null;
        for (SharedItemConfiguration item : this.items) {
            PredefinedToolKind current = this.getItemTool(item);
            result = result != null && current != result ? PredefinedToolKind.UnknownTool : current;
        }
        return result;
    }

    private PredefinedToolKind getItemTool(SharedItemConfiguration item) {
        PredefinedToolKind tool = PredefinedToolKind.UnknownTool;
        CompilerSet compilerSet = null;
        for (int i = 0; i < this.selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.selectedConfigurations[i];
            CompilerSet compilerSet2 = makeConfiguration.getCompilerSet().getCompilerSet();
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            if (itemConfiguration == null) continue;
            PredefinedToolKind tool2 = itemConfiguration.getTool();
            if (tool == PredefinedToolKind.UnknownTool && compilerSet == null) {
                tool = tool2;
                compilerSet = compilerSet2;
            } else if (tool != tool2 || compilerSet != compilerSet2) {
                tool = PredefinedToolKind.UnknownTool;
                break;
            }
            if ((!this.isCompilerConfiguration() || makeConfiguration.isCompileConfiguration()) && (this.isCompilerConfiguration() || !makeConfiguration.isCompileConfiguration())) continue;
            tool = PredefinedToolKind.UnknownTool;
            break;
        }
        return tool;
    }

    public boolean isQtMode() {
        boolean isQtMode = false;
        for (int i = 0; i < this.selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.selectedConfigurations[i];
            isQtMode |= makeConfiguration.isQmakeConfiguration();
        }
        return isQtMode;
    }

    public static interface Savable {
        public void save();
    }

    public static enum Kind {
        Project,
        Folder,
        Item;

    }
}

