/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2me.keystore.KeyStoreRepository;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.J2MEProjectUtils;
import org.netbeans.modules.j2me.project.ui.SourceLevelComboBoxModel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEAPIPermissionsPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEAttributesPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MECompilingPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEMIDletsPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEPushRegistryPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MERunPanel;
import org.netbeans.modules.j2me.project.ui.customizer.LibletInfo;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.ClassPathListCellRenderer;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class J2MEProjectProperties {
    public static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String PLATFORM_TYPE_J2ME = "j2me";
    public static String PLATFORM_SDK = "platform.sdk";
    public static final String OBFUSCATION_CUSTOM = "obfuscation.custom";
    public static final String OBFUSCATION_LEVEL = "obfuscation.level";
    public static final String PROP_RUN_METHOD = "run.method";
    public static final String PROP_DEBUGGER_TIMEOUT = "debugger.timeout";
    public static final String PROP_SIGN_ENABLED = "sign.enabled";
    public static final String PROP_SIGN_KEYSTORE = "sign.keystore";
    public static final String PROP_SIGN_ALIAS = "sign.alias";
    public static final String MANIFEST_IS_LIBLET = "manifest.is.liblet";
    public static final String MANIFEST_OTHERS = "manifest.others";
    public static final String MANIFEST_MANIFEST = "manifest.manifest";
    public static final String MANIFEST_JAD = "manifest.jad";
    public static final String DEPLOYMENT_JARURL = "deployment.jarurl";
    public static final String DEPLOYMENT_OVERRIDE_JARURL = "deployment.override.jarurl";
    public static final String PLATFORM_PROFILE = "platform.profile";
    public static final String MANIFEST_MIDLETS = "manifest.midlets";
    public static final String DIST_JAD = "dist.jad";
    public static final String DIST_JAR_FILE = "dist.jar.file";
    public static final String MANIFEST_APIPERMISSIONS = "manifest.apipermissions";
    public static final String MANIFEST_APIPERMISSIONS_CLASSES = "manifest.apipermissions.classes";
    public static final String MANIFEST_PUSHREGISTRY = "manifest.pushregistry";
    public static final String PROP_PLATFORM_TYPE = "platform.type";
    public static final String PROP_PLATFORM_DEVICE = "platform.device";
    public static final String PROP_PLATFORM_CONFIGURATION = "platform.configuration";
    public static final String PROP_PLATFORM_PROFILE = "platform.profile";
    public static final String PROP_PLATFORM_APIS = "platform.apis";
    public static final String PROP_PLATFORM_BOOTCLASSPATH = "platform.bootcp";
    public static final String PLATFORM_HOME = "platform.home";
    public static final String PROP_LIBLET_PREFIX = "liblets.";
    public static final String PROP_LIBLET_DEPENDENCY = ".dependency";
    public static final String PROP_LIBLET_URL = ".url";
    public static final String PROP_LIBLET_EXTRACT = ".extract";
    private static final Integer BOOLEAN_KIND_TF = new Integer(0);
    private static final Integer BOOLEAN_KIND_YN = new Integer(1);
    private static final Integer BOOLEAN_KIND_ED = new Integer(2);
    private static final ThreadLocal<Boolean> propertiesSave = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<List<Runnable>> postSaveAction = new ThreadLocal<List<Runnable>>(){

        @Override
        protected List<Runnable> initialValue() {
            return new ArrayList<Runnable>();
        }
    };
    DefaultTableModel SOURCE_ROOTS_MODEL;
    DefaultTableModel TEST_ROOTS_MODEL;
    ComboBoxModel SOURCE_LEVEL_MODEL;
    DefaultListModel JAVAC_CLASSPATH_MODEL;
    DefaultListModel JAVAC_PROCESSORPATH_MODEL;
    DefaultListModel JAVAC_TEST_CLASSPATH_MODEL;
    DefaultListModel RUN_CLASSPATH_MODEL;
    DefaultListModel RUN_TEST_CLASSPATH_MODEL;
    DefaultListModel ENDORSED_CLASSPATH_MODEL;
    ComboBoxModel PLATFORM_MODEL;
    ListCellRenderer CLASS_PATH_LIST_RENDERER;
    ListCellRenderer PLATFORM_LIST_RENDERER;
    Document SHARED_LIBRARIES_MODEL;
    DefaultComboBoxModel LIBLETS_MODEL;
    Document ADDITIONAL_OBFUSCATION_SETTINGS_MODEL;
    BoundedRangeModel OBFUSCATION_LEVEL_MODEL;
    public Map<String, Map<String, String>> RUN_CONFIGS;
    public String activeConfig;
    public DefaultComboBoxModel CONFIGS_MODEL = new DefaultComboBoxModel<String>(new String[]{"<default>"});
    private static final String[] CONFIG_AWARE_PROPERTIES = new String[]{"application.args", "run.method", "debugger.timeout", "platform.device", "platform.configuration", "platform.profile", "platform.apis", "platform.bootcp", "manifest.others", "manifest.jad", "manifest.manifest"};
    public ComboBoxModel J2ME_PLATFORM_MODEL;
    public ComboBoxModel JDK_PLATOFRM_MODEL;
    private HashMap<String, J2MEPlatform.J2MEProfile> name2ProfileMap;
    JToggleButton.ToggleButtonModel SIGN_ENABLED_MODEL;
    ComboBoxModel SIGN_KEYSTORE_MODEL;
    ComboBoxModel SIGN_ALIAS_MODEL;
    ButtonModel DEPLOYMENT_OVERRIDE_JARURL_MODEL;
    Document DEPLOYMENT_JARURL_MODEL;
    J2MEAttributesPanel.StorableTableModel ATTRIBUTES_TABLE_MODEL;
    String[] ATTRIBUTES_PROPERTY_NAMES = new String[]{"manifest.others", "manifest.jad", "manifest.manifest"};
    public J2MEMIDletsPanel.MIDletsTableModel MIDLETS_TABLE_MODEL;
    public String[] MIDLETS_PROPERTY_NAMES = new String[]{"manifest.midlets"};
    boolean LIBLET_PACKAGING;
    J2MEAPIPermissionsPanel.StorableTableModel API_PERMISSIONS_TABLE_MODEL;
    String[] API_PERMISSIONS_PROPERTY_NAMES = new String[]{"manifest.apipermissions", "manifest.apipermissions.classes"};
    J2MEPushRegistryPanel.StorableTableModel PUSH_REGISTRY_TABLE_MODEL;
    String[] PUSH_REGISTRY_PROPERTY_NAMES = new String[]{"manifest.pushregistry"};
    ButtonModel JAVAC_DEPRECATION_MODEL;
    ButtonModel JAVAC_DEBUG_MODEL;
    ButtonModel DO_DEPEND_MODEL;
    ButtonModel NO_DEPENDENCIES_MODEL;
    ButtonModel ENABLE_ANNOTATION_PROCESSING_MODEL;
    ButtonModel ENABLE_ANNOTATION_PROCESSING_IN_EDITOR_MODEL;
    DefaultListModel ANNOTATION_PROCESSORS_MODEL;
    DefaultTableModel PROCESSOR_OPTIONS_MODEL;
    Document JAVAC_COMPILER_ARG_MODEL;
    private Integer javacDebugBooleanKind;
    ButtonModel JAVADOC_PRIVATE_MODEL;
    ButtonModel JAVADOC_NO_TREE_MODEL;
    ButtonModel JAVADOC_USE_MODEL;
    ButtonModel JAVADOC_NO_NAVBAR_MODEL;
    ButtonModel JAVADOC_NO_INDEX_MODEL;
    ButtonModel JAVADOC_SPLIT_INDEX_MODEL;
    ButtonModel JAVADOC_AUTHOR_MODEL;
    ButtonModel JAVADOC_VERSION_MODEL;
    Document JAVADOC_WINDOW_TITLE_MODEL;
    ButtonModel JAVADOC_PREVIEW_MODEL;
    Document JAVADOC_ADDITIONALPARAM_MODEL;
    private Integer javadocPreviewBooleanKind;
    private final List<ActionListener> optionListeners = new CopyOnWriteArrayList<ActionListener>();
    private Map<String, String> additionalProperties;
    private String includes;
    private String excludes;
    ClassPathSupport cs;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private final J2MEProject project;
    private J2MECompilingPanel compilingPanel = null;
    private J2MERunPanel runPanel = null;

    public J2MEProject getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.project.evaluator();
    }

    public J2MEProjectProperties(@NonNull J2MEProject project) {
        this.project = project;
        this.cs = new ClassPathSupport(this.getEvaluator(), project.getReferenceHelper(), project.getHelper(), project.getUpdateHelper(), null);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new HashMap<String, String>();
        this.init();
    }

    public static boolean isPropertiesSave() {
        return propertiesSave.get();
    }

    public static void postSave(@NonNull Runnable action) {
        Parameters.notNull((CharSequence)"action", (Object)action);
        if (!J2MEProjectProperties.isPropertiesSave()) {
            throw new IllegalStateException("Not in properties save");
        }
        List<Runnable> l = postSaveAction.get();
        l.add(action);
    }

    private void init() {
        PropertyEvaluator evaluator = this.getEvaluator();
        UpdateHelper updateHelper = this.getProject().getUpdateHelper();
        this.CLASS_PATH_LIST_RENDERER = ClassPathListCellRenderer.createClassPathListRenderer((PropertyEvaluator)evaluator, (FileObject)this.project.getProjectDirectory());
        this.SOURCE_ROOTS_MODEL = SourceRootsUi.createModel((SourceRoots)this.project.getSourceRoots());
        this.TEST_ROOTS_MODEL = SourceRootsUi.createModel((SourceRoots)this.project.getTestRoots());
        this.includes = evaluator.getProperty("includes");
        if (this.includes == null) {
            this.includes = "**";
        }
        this.excludes = evaluator.getProperty("excludes");
        if (this.excludes == null) {
            this.excludes = "";
        }
        EditableProperties projectProperties = updateHelper.getProperties("nbproject/project.properties");
        this.JAVAC_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"javac.classpath")));
        String processorPath = projectProperties.get((Object)"javac.processorpath");
        processorPath = processorPath == null ? "${javac.classpath}" : processorPath;
        this.JAVAC_PROCESSORPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(processorPath));
        this.JAVAC_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"javac.test.classpath")));
        this.RUN_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"run.classpath")));
        this.RUN_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"run.test.classpath")));
        this.ENDORSED_CLASSPATH_MODEL = ClassPathUiSupport.createListModel((Iterator)this.cs.itemsIterator(projectProperties.get((Object)"endorsed.classpath")));
        Collection filters = this.project.getLookup().lookupAll(PlatformFilter.class);
        this.PLATFORM_MODEL = filters == null ? PlatformUiSupport.createPlatformComboBoxModel((String)evaluator.getProperty("platform.active")) : PlatformUiSupport.createPlatformComboBoxModel((String)evaluator.getProperty("platform.active"), (Collection)filters);
        this.PLATFORM_LIST_RENDERER = PlatformUiSupport.createPlatformListCellRenderer();
        this.LIBLETS_MODEL = J2MEProjectProperties.createLibletModelFromProps(evaluator);
        this.SHARED_LIBRARIES_MODEL = new PlainDocument();
        try {
            this.SHARED_LIBRARIES_MODEL.insertString(0, this.project.getHelper().getLibrariesLocation(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.NO_DEPENDENCIES_MODEL = this.projectGroup.createInverseToggleButtonModel(evaluator, "no.dependencies");
        this.ADDITIONAL_OBFUSCATION_SETTINGS_MODEL = this.projectGroup.createStringDocument(this.getEvaluator(), OBFUSCATION_CUSTOM);
        this.OBFUSCATION_LEVEL_MODEL = ModelHelper.createSliderModel(this.getEvaluator(), OBFUSCATION_LEVEL, 0, 0, 9);
        this.RUN_CONFIGS = this.readRunConfigs();
        this.activeConfig = evaluator.getProperty("config");
        this.J2ME_PLATFORM_MODEL = ModelHelper.createComboBoxModel(evaluator, "platform.active", Arrays.asList(J2MEProjectUtils.readPlatforms()));
        this.JDK_PLATOFRM_MODEL = this.loadJdkPlatforms();
        this.name2ProfileMap = J2MEProjectUtils.getNameToProfileMap();
        this.SIGN_ENABLED_MODEL = this.projectGroup.createToggleButtonModel(evaluator, PROP_SIGN_ENABLED);
        this.SIGN_KEYSTORE_MODEL = ModelHelper.createComboBoxModel(evaluator, PROP_SIGN_KEYSTORE, this.loadKeystores(), Utilities.toFile((URI)this.project.getProjectDirectory().toURI()));
        this.SIGN_ALIAS_MODEL = ModelHelper.createComboBoxModel(evaluator, PROP_SIGN_ALIAS, this.loadAliases());
        this.DEPLOYMENT_OVERRIDE_JARURL_MODEL = this.projectGroup.createToggleButtonModel(evaluator, DEPLOYMENT_OVERRIDE_JARURL);
        if (this.getEvaluator().getProperty(DEPLOYMENT_OVERRIDE_JARURL) == null) {
            this.DEPLOYMENT_OVERRIDE_JARURL_MODEL.setSelected(false);
        }
        this.DEPLOYMENT_JARURL_MODEL = this.projectGroup.createStringDocument(this.getEvaluator(), DEPLOYMENT_JARURL);
        if (this.getEvaluator().getProperty(DEPLOYMENT_JARURL) == null) {
            try {
                this.DEPLOYMENT_JARURL_MODEL.insertString(0, "${dist.jar.file}", null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.ATTRIBUTES_TABLE_MODEL = new J2MEAttributesPanel.StorableTableModel(this);
        String libletPropValue = evaluator.getProperty(MANIFEST_IS_LIBLET);
        this.LIBLET_PACKAGING = libletPropValue != null ? Boolean.valueOf(libletPropValue) : false;
        this.MIDLETS_TABLE_MODEL = new J2MEMIDletsPanel.MIDletsTableModel(this);
        this.API_PERMISSIONS_TABLE_MODEL = new J2MEAPIPermissionsPanel.StorableTableModel(this);
        this.PUSH_REGISTRY_TABLE_MODEL = new J2MEPushRegistryPanel.StorableTableModel(this);
        Integer[] kind = new Integer[1];
        this.JAVAC_DEPRECATION_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javac.deprecation");
        this.JAVAC_DEBUG_MODEL = ModelHelper.createToggleButtonModel(evaluator, "javac.debug", kind);
        this.javacDebugBooleanKind = kind[0];
        this.DO_DEPEND_MODEL = this.privateGroup.createToggleButtonModel(evaluator, "do.depend");
        this.ENABLE_ANNOTATION_PROCESSING_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "annotation.processing.enabled");
        this.ENABLE_ANNOTATION_PROCESSING_IN_EDITOR_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "annotation.processing.enabled.in.editor");
        String annotationProcessors = projectProperties.get((Object)"annotation.processing.processors.list");
        if (annotationProcessors == null) {
            annotationProcessors = "";
        }
        this.ANNOTATION_PROCESSORS_MODEL = ClassPathUiSupport.createListModel((annotationProcessors.length() > 0 ? Arrays.asList(annotationProcessors.split(",")) : Collections.emptyList()).iterator());
        String processorOptions = projectProperties.get((Object)"annotation.processing.processor.options");
        if (processorOptions == null) {
            processorOptions = "";
        }
        this.PROCESSOR_OPTIONS_MODEL = new DefaultTableModel(new String[0][], new String[]{NbBundle.getMessage(J2MECompilingPanel.class, (String)"LBL_CustomizeCompile_Processor_Options_Key"), NbBundle.getMessage(J2MECompilingPanel.class, (String)"LBL_CustomizeCompile_Processor_Options_Value")}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (String option : processorOptions.split("\\s")) {
            if (!option.startsWith("-A") || option.length() <= 2) continue;
            int sepIndex = option.indexOf(61);
            String key = null;
            String value = null;
            if (sepIndex == -1) {
                key = option.substring(2);
            } else if (sepIndex >= 3) {
                key = option.substring(2, sepIndex);
                value = sepIndex < option.length() - 1 ? option.substring(sepIndex + 1) : null;
            }
            this.PROCESSOR_OPTIONS_MODEL.addRow(new String[]{key, value});
        }
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(evaluator, "javac.compilerargs");
        this.JAVADOC_PRIVATE_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javadoc.private");
        this.JAVADOC_NO_TREE_MODEL = this.projectGroup.createInverseToggleButtonModel(evaluator, "javadoc.notree");
        this.JAVADOC_USE_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javadoc.use");
        this.JAVADOC_NO_NAVBAR_MODEL = this.projectGroup.createInverseToggleButtonModel(evaluator, "javadoc.nonavbar");
        this.JAVADOC_NO_INDEX_MODEL = this.projectGroup.createInverseToggleButtonModel(evaluator, "javadoc.noindex");
        this.JAVADOC_SPLIT_INDEX_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javadoc.splitindex");
        this.JAVADOC_AUTHOR_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javadoc.author");
        this.JAVADOC_VERSION_MODEL = this.projectGroup.createToggleButtonModel(evaluator, "javadoc.version");
        this.JAVADOC_WINDOW_TITLE_MODEL = this.projectGroup.createStringDocument(evaluator, "javadoc.windowtitle");
        this.JAVADOC_PREVIEW_MODEL = ModelHelper.createToggleButtonModel(evaluator, "javadoc.preview", kind);
        this.javadocPreviewBooleanKind = kind[0];
        this.JAVADOC_ADDITIONALPARAM_MODEL = this.projectGroup.createStringDocument(evaluator, "javadoc.additionalparam");
        this.SOURCE_LEVEL_MODEL = new SourceLevelComboBoxModel(this.JDK_PLATOFRM_MODEL, this.J2ME_PLATFORM_MODEL, evaluator.getProperty("javac.source"));
    }

    void collectData() {
    }

    void storeData() {
        propertiesSave.set(Boolean.TRUE);
        try {
            this.saveLibrariesLocation();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    J2MEProjectProperties.this.storeProperties();
                    try {
                        for (Runnable action : (List)postSaveAction.get()) {
                            try {
                                action.run();
                            }
                            catch (Throwable t) {
                                if (t instanceof ThreadDeath) {
                                    throw (ThreadDeath)t;
                                }
                                Exceptions.printStackTrace((Throwable)t);
                            }
                        }
                    }
                    finally {
                        postSaveAction.remove();
                    }
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        finally {
            propertiesSave.remove();
        }
    }

    private void saveLibrariesLocation() throws IOException, IllegalArgumentException {
        try {
            String old;
            String str = this.SHARED_LIBRARIES_MODEL.getText(0, this.SHARED_LIBRARIES_MODEL.getLength()).trim();
            if (str.length() == 0) {
                str = null;
            }
            if (!((old = this.project.getHelper().getLibrariesLocation()) == null && str == null || old != null && old.equals(str))) {
                this.project.getHelper().setLibrariesLocation(str);
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (BadLocationException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void storeProperties() throws IOException {
        JavaPlatform selectedJdkPlatform;
        int i;
        this.resolveProjectDependencies();
        String[] javac_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_CLASSPATH_MODEL));
        String[] javac_pp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_PROCESSORPATH_MODEL));
        String[] javac_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_TEST_CLASSPATH_MODEL));
        String[] run_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.RUN_CLASSPATH_MODEL));
        String[] run_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.RUN_TEST_CLASSPATH_MODEL));
        String[] endorsed_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList((DefaultListModel)this.ENDORSED_CLASSPATH_MODEL));
        this.storeRoots(this.project.getSourceRoots(), this.SOURCE_ROOTS_MODEL);
        EditableProperties projectProperties = this.project.getUpdateHelper().getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.project.getUpdateHelper().getProperties("nbproject/private/private.properties");
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        int libletIndex = 0;
        for (libletIndex = 0; libletIndex < this.LIBLETS_MODEL.getSize(); ++libletIndex) {
            LibletInfo li = (LibletInfo)this.LIBLETS_MODEL.getElementAt(libletIndex);
            String libletDep = li.getType().name().toLowerCase() + ";" + li.getRequirement().name().toLowerCase() + ";" + li.getName() + ";" + li.getVendor() + ";" + li.getVersion();
            projectProperties.put(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_DEPENDENCY, libletDep);
            if (li.getUrl() != null) {
                projectProperties.put(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_URL, li.getUrl());
            }
            projectProperties.put(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_EXTRACT, String.valueOf(li.isExtractClasses()));
        }
        String nextLiblet = null;
        while ((nextLiblet = this.project.evaluator().getProperty(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_DEPENDENCY)) != null) {
            projectProperties.remove((Object)(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_DEPENDENCY));
            projectProperties.remove((Object)(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_URL));
            projectProperties.remove((Object)(PROP_LIBLET_PREFIX + libletIndex + PROP_LIBLET_EXTRACT));
            ++libletIndex;
        }
        if (this.SIGN_ENABLED_MODEL.isSelected() && this.SIGN_KEYSTORE_MODEL.getSelectedItem() != null) {
            void var12_16;
            File ksFile = ((KeyStoreRepository.KeyStoreBean)this.SIGN_KEYSTORE_MODEL.getSelectedItem()).getKeyStoreFile();
            Object var12_12 = null;
            if (this.SIGN_KEYSTORE_MODEL.getSelectedItem().equals(this.SIGN_KEYSTORE_MODEL.getElementAt(0))) {
                String ksPath = ksFile.getAbsolutePath();
                if (ksPath.startsWith(Places.getUserDirectory().getAbsolutePath())) {
                    String string = ksPath.replace(Places.getUserDirectory().getAbsolutePath(), "${netbeans.user}").replace("\\", "/");
                }
            } else {
                File prjDir = Utilities.toFile((URI)this.project.getProjectDirectory().toURI());
                String string = PropertyUtils.relativizeFile((File)prjDir, (File)ksFile);
            }
            projectProperties.put(PROP_SIGN_KEYSTORE, (String)(var12_16 != null ? var12_16 : ksFile.getAbsolutePath()));
            if (this.SIGN_ALIAS_MODEL.getSelectedItem() != null) {
                projectProperties.put(PROP_SIGN_ALIAS, ((KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.SIGN_ALIAS_MODEL.getSelectedItem()).getAlias());
            }
        }
        if (!this.SIGN_ENABLED_MODEL.isSelected()) {
            projectProperties.remove((Object)PROP_SIGN_ENABLED);
            projectProperties.remove((Object)PROP_SIGN_KEYSTORE);
            projectProperties.remove((Object)PROP_SIGN_ALIAS);
        }
        for (Map.Entry entry : this.RUN_CONFIGS.entrySet()) {
            Map config = (Map)entry.getValue();
            if (config == null) continue;
            String platformConfiguration = config.get(PROP_PLATFORM_CONFIGURATION) != null ? (String)config.get(PROP_PLATFORM_CONFIGURATION) : this.RUN_CONFIGS.get(null).get(PROP_PLATFORM_CONFIGURATION);
            String platformProfile = config.get("platform.profile") != null ? (String)config.get("platform.profile") : this.RUN_CONFIGS.get(null).get("platform.profile");
            String platformApis = config.get(PROP_PLATFORM_APIS) != null ? (String)config.get(PROP_PLATFORM_APIS) : this.RUN_CONFIGS.get(null).get(PROP_PLATFORM_APIS);
            StringBuilder sbBootCP = new StringBuilder();
            if (this.name2ProfileMap.get(platformConfiguration) == null || this.name2ProfileMap.get(platformProfile) == null) continue;
            sbBootCP.append(this.name2ProfileMap.get(platformConfiguration).getClassPath());
            sbBootCP.append(":").append(this.name2ProfileMap.get(platformProfile).getClassPath());
            if (platformApis != null) {
                String[] optionalPackages;
                for (String pkg : optionalPackages = platformApis.split(",")) {
                    J2MEPlatform.J2MEProfile profile = this.name2ProfileMap.get(pkg);
                    if (profile == null) continue;
                    sbBootCP.append(":").append(profile.getClassPath());
                }
            }
            if (entry.getKey() == null || !sbBootCP.toString().equals(this.RUN_CONFIGS.get(null).get(PROP_PLATFORM_BOOTCLASSPATH))) {
                config.put(PROP_PLATFORM_BOOTCLASSPATH, sbBootCP.toString());
                continue;
            }
            config.put(PROP_PLATFORM_BOOTCLASSPATH, null);
        }
        this.storeAttributesToRunConfigs();
        this.storeRunConfigs(this.RUN_CONFIGS, projectProperties, privateProperties);
        EditableProperties ep = this.project.getUpdateHelper().getProperties("nbproject/private/config.properties");
        if (this.activeConfig == null) {
            ep.remove((Object)"config");
        } else {
            ep.setProperty("config", this.activeConfig);
        }
        this.project.getUpdateHelper().putProperties("nbproject/private/config.properties", ep);
        projectProperties.setProperty("javac.classpath", javac_cp);
        projectProperties.setProperty("javac.processorpath", javac_pp);
        projectProperties.setProperty("javac.test.classpath", javac_test_cp);
        projectProperties.setProperty("run.classpath", run_cp);
        projectProperties.setProperty("run.test.classpath", run_test_cp);
        projectProperties.setProperty("endorsed.classpath", endorsed_cp);
        if (this.SOURCE_LEVEL_MODEL.getSelectedItem() != null) {
            String string = ((SourceLevelComboBoxModel.SourceLevel)this.SOURCE_LEVEL_MODEL.getSelectedItem()).getSourceLevel();
            projectProperties.put("javac.source", string);
            projectProperties.put("javac.target", string);
        }
        if (this.NO_DEPENDENCIES_MODEL.isSelected()) {
            projectProperties.remove((Object)"no.dependencies");
        }
        projectProperties.putAll(this.additionalProperties);
        projectProperties.put("includes", this.includes);
        projectProperties.put("excludes", this.excludes);
        projectProperties.put(DEPLOYMENT_OVERRIDE_JARURL, Boolean.toString(this.DEPLOYMENT_OVERRIDE_JARURL_MODEL.isSelected()));
        try {
            projectProperties.put(DEPLOYMENT_JARURL, this.DEPLOYMENT_JARURL_MODEL.getText(0, this.DEPLOYMENT_JARURL_MODEL.getLength()));
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        Object[] objectArray = this.MIDLETS_TABLE_MODEL.getDataDelegates();
        for (i = 0; i < objectArray.length; ++i) {
            projectProperties.put(this.MIDLETS_PROPERTY_NAMES[i], this.encode(objectArray[i]));
        }
        Object[] objectArray2 = this.API_PERMISSIONS_TABLE_MODEL.getDataDelegates();
        for (i = 0; i < objectArray2.length; ++i) {
            projectProperties.put(this.API_PERMISSIONS_PROPERTY_NAMES[i], this.encode(objectArray2[i]));
        }
        Object[] objectArray3 = this.PUSH_REGISTRY_TABLE_MODEL.getDataDelegates();
        for (i = 0; i < objectArray3.length; ++i) {
            projectProperties.put(this.PUSH_REGISTRY_PROPERTY_NAMES[i], this.encode(objectArray3[i]));
        }
        JavaPlatform selectedPlatform = (JavaPlatform)this.J2ME_PLATFORM_MODEL.getSelectedItem();
        if (selectedPlatform != null) {
            projectProperties.put("platform.active", (String)selectedPlatform.getProperties().get(PLATFORM_ANT_NAME));
            projectProperties.put(PROP_PLATFORM_TYPE, ((J2MEPlatform)selectedPlatform).getType());
        }
        if ((selectedJdkPlatform = PlatformUiSupport.getPlatform((Object)this.JDK_PLATOFRM_MODEL.getSelectedItem())) != null) {
            projectProperties.put(PLATFORM_SDK, (String)selectedJdkPlatform.getProperties().get(PLATFORM_ANT_NAME));
        }
        projectProperties.put(OBFUSCATION_LEVEL, String.valueOf(this.OBFUSCATION_LEVEL_MODEL.getValue()));
        this.projectGroup.store(projectProperties);
        privateProperties.setProperty("javac.debug", J2MEProjectProperties.encodeBoolean(this.JAVAC_DEBUG_MODEL.isSelected(), this.javacDebugBooleanKind));
        privateProperties.setProperty("javadoc.preview", J2MEProjectProperties.encodeBoolean(this.JAVADOC_PREVIEW_MODEL.isSelected(), this.javadocPreviewBooleanKind));
        StringBuilder sb = new StringBuilder();
        Enumeration elements = this.ANNOTATION_PROCESSORS_MODEL.elements();
        while (elements.hasMoreElements()) {
            sb.append(elements.nextElement());
            if (!elements.hasMoreElements()) continue;
            sb.append(',');
        }
        if (sb.length() > 0) {
            projectProperties.put("annotation.processing.run.all.processors", J2MEProjectProperties.encodeBoolean(false, BOOLEAN_KIND_TF));
            projectProperties.put("annotation.processing.processors.list", sb.toString());
        } else {
            projectProperties.put("annotation.processing.run.all.processors", J2MEProjectProperties.encodeBoolean(true, BOOLEAN_KIND_TF));
            projectProperties.put("annotation.processing.processors.list", "");
        }
        sb = new StringBuilder();
        for (int i2 = 0; i2 < this.PROCESSOR_OPTIONS_MODEL.getRowCount(); ++i2) {
            String key = (String)this.PROCESSOR_OPTIONS_MODEL.getValueAt(i2, 0);
            String value = (String)this.PROCESSOR_OPTIONS_MODEL.getValueAt(i2, 1);
            sb.append("-A").append(key);
            if (value != null && value.length() > 0) {
                sb.append('=').append(value);
            }
            if (i2 >= this.PROCESSOR_OPTIONS_MODEL.getRowCount() - 1) continue;
            sb.append(' ');
        }
        if (sb.length() > 0) {
            projectProperties.put("annotation.processing.processor.options", sb.toString());
        } else {
            projectProperties.remove((Object)"annotation.processing.processor.options");
        }
        this.project.getUpdateHelper().putProperties("nbproject/project.properties", projectProperties);
        this.project.getUpdateHelper().putProperties("nbproject/private/private.properties", privateProperties);
        String value = this.additionalProperties.get("source.encoding");
        if (value != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(value));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    Object decode(String raw) {
        try {
            String line;
            if (raw == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new StringReader(raw));
            HashMap<String, String> map = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                int i = line.indexOf(58);
                if (i < 0) continue;
                map.put(line.substring(0, i), line.substring(i + 1).trim());
            }
            return map;
        }
        catch (IOException ioe) {
            assert (false) : ioe;
            return null;
        }
    }

    public String encode(Object val) {
        HashMap map = (HashMap)val;
        if (map == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (String key : map.keySet()) {
            String value;
            if (key == null || (value = (String)map.get(key)) == null) continue;
            buffer.append(key).append(": ").append(value).append('\n');
        }
        return buffer.toString();
    }

    private static String encodeBoolean(boolean value, Integer kind) {
        if (kind == BOOLEAN_KIND_ED) {
            return value ? "on" : "off";
        }
        if (kind == BOOLEAN_KIND_YN) {
            return value ? "yes" : "no";
        }
        return value ? "true" : "false";
    }

    private void resolveProjectDependencies() {
        HashSet oldArtifacts = new HashSet();
        EditableProperties projectProperties = this.project.getUpdateHelper().getProperties("nbproject/project.properties");
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"javac.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"javac.processorpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"javac.test.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"run.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"run.test.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get((Object)"endorsed.classpath")));
        HashSet newArtifacts = new HashSet();
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_PROCESSORPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.JAVAC_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.RUN_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.RUN_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList((DefaultListModel)this.ENDORSED_CLASSPATH_MODEL));
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 2 && item.getType() != 0) continue;
            this.project.getReferenceHelper().destroyReference(item.getReference());
            if (item.getType() != 0) continue;
            item.removeSourceAndJavadoc(this.project.getUpdateHelper());
        }
        boolean changed = false;
        EditableProperties ep = this.project.getUpdateHelper().getProperties("nbproject/project.properties");
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 1) continue;
            String prop = item.getReference();
            prop = CommonProjectUtils.getAntPropertyName((String)prop);
            ep.remove((Object)prop);
            changed = true;
        }
        if (changed) {
            this.project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
        }
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        LinkedList<URL> oldRootURLs = new LinkedList<URL>(Arrays.asList(roots.getRootURLs(false)));
        LinkedList<String> oldRootLabels = new LinkedList<String>(Arrays.asList(roots.getRootNames()));
        LinkedList<String> oldRootProps = new LinkedList<String>(Arrays.asList(roots.getRootProperties()));
        boolean rootsAreSame = true;
        for (int i = 0; i < data.size(); ++i) {
            File f = (File)data.elementAt(i).elementAt(0);
            rootURLs[i] = Utilities.toURI((File)f).toURL();
            if (!rootURLs[i].toExternalForm().endsWith("/")) {
                rootURLs[i] = new URL(rootURLs[i] + "/");
            }
            this.validateURL(rootURLs[i], f);
            rootLabels[i] = (String)data.elementAt(i).elementAt(1);
            rootsAreSame &= !oldRootURLs.isEmpty() && oldRootURLs.removeFirst().equals(rootURLs[i]) && roots.getRootDisplayName(oldRootLabels.removeFirst(), oldRootProps.removeFirst()).equals(rootLabels[i]);
        }
        if (!rootsAreSame || !oldRootURLs.isEmpty()) {
            roots.putRoots(rootURLs, rootLabels);
        }
    }

    private void validateURL(URL url, File file) {
        try {
            URI uri = url.toURI();
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("URI is not absolute: " + uri.toString() + " File: " + file.getAbsolutePath());
            }
            if (uri.isOpaque()) {
                throw new IllegalArgumentException("URI is not hierarchical: " + uri.toString() + " File: " + file.getAbsolutePath());
            }
            if (!"file".equals(uri.getScheme())) {
                throw new IllegalArgumentException("URI scheme is not \"file\": " + uri.toString() + " File: " + file.getAbsolutePath());
            }
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    @NonNull
    Iterable<? extends ActionListener> getOptionListeners() {
        return this.optionListeners;
    }

    void addOptionListener(@NonNull ActionListener al) {
        Parameters.notNull((CharSequence)"al", (Object)al);
        this.optionListeners.add(al);
    }

    void removeOptionListener(@NonNull ActionListener al) {
        Parameters.notNull((CharSequence)"al", (Object)al);
        this.optionListeners.remove(al);
    }

    public void putAdditionalProperty(String propertyName, String propertyValue) {
        this.additionalProperties.put(propertyName, propertyValue);
    }

    void loadIncludesExcludes(IncludeExcludeVisualizer v) {
        HashSet<File> roots = new HashSet<File>();
        for (DefaultTableModel model : new DefaultTableModel[]{this.SOURCE_ROOTS_MODEL, this.TEST_ROOTS_MODEL}) {
            for (Vector row : model.getDataVector()) {
                File d = (File)row.elementAt(0);
                if (!d.isDirectory()) continue;
                roots.add(d);
            }
        }
        v.setRoots(roots.toArray(new File[roots.size()]));
        v.setIncludePattern(this.includes);
        v.setExcludePattern(this.excludes);
    }

    void storeIncludesExcludes(IncludeExcludeVisualizer v) {
        this.includes = v.getIncludePattern();
        this.excludes = v.getExcludePattern();
    }

    boolean makeSharable() {
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        this.collectLibs(this.JAVAC_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.JAVAC_PROCESSORPATH_MODEL, libs, jars);
        this.collectLibs(this.JAVAC_TEST_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.RUN_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.RUN_TEST_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.ENDORSED_CLASSPATH_MODEL, libs, jars);
        libs.add("CopyLibs");
        String customTasksLibs = this.getProject().evaluator().getProperty("ant.customtasks.libs");
        if (customTasksLibs != null) {
            String[] libIDs;
            for (String libID : libIDs = customTasksLibs.split(",")) {
                libs.add(libID.trim());
            }
        }
        return SharableLibrariesUtils.showMakeSharableWizard((AntProjectHelper)this.getProject().getHelper(), (ReferenceHelper)this.getProject().getReferenceHelper(), libs, jars);
    }

    private void collectLibs(DefaultListModel model, List<String> libs, List<String> jarReferences) {
        for (int i = 0; i < model.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)model.get(i);
            if (item.getType() == 1 && !item.isBroken() && !libs.contains(item.getLibrary().getName())) {
                libs.add(item.getLibrary().getName());
            }
            if (item.getType() != 0 || item.getReference() == null || item.getVariableBasedProperty() != null || jarReferences.contains(item.getReference())) continue;
            jarReferences.add(item.getReference());
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public void store() throws IOException {
    }

    public J2MECompilingPanel getCompilingPanel() {
        if (this.compilingPanel == null) {
            this.compilingPanel = new J2MECompilingPanel(this);
        }
        return this.compilingPanel;
    }

    public J2MERunPanel getRunPanel() {
        if (this.runPanel == null) {
            this.runPanel = new J2MERunPanel(this);
        }
        return this.runPanel;
    }

    private Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> m = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        TreeMap<String, String> def = new TreeMap<String, String>();
        for (String prop : CONFIG_AWARE_PROPERTIES) {
            String v = this.project.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty(prop);
            if (v == null) {
                v = this.project.getUpdateHelper().getProperties("nbproject/project.properties").getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                String relPath;
                if (!kid.hasExt("properties") || (relPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid)) == null) continue;
                m.put(kid.getName(), new TreeMap(this.project.getUpdateHelper().getProperties(relPath)));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                String relPath;
                Map c;
                if (!kid.hasExt("properties") || (c = (Map)m.get(kid.getName())) == null || (relPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid)) == null) continue;
                c.putAll(new HashMap(this.project.getUpdateHelper().getProperties(relPath)));
            }
        }
        return m;
    }

    private void storeRunConfigs(Map<String, Map<String, String>> configs, EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        Map<String, String> def = configs.get(null);
        for (String prop : CONFIG_AWARE_PROPERTIES) {
            EditableProperties ep;
            String v = def.get(prop);
            EditableProperties editableProperties = ep = prop.equals("application.args") || prop.equals("work.dir") || privateProperties.containsKey((Object)prop) ? privateProperties : projectProperties;
            if (Utilities.compareObjects((Object)v, (Object)ep.getProperty(prop))) continue;
            if (v != null && v.length() > 0) {
                ep.setProperty(prop, v);
                continue;
            }
            ep.remove((Object)prop);
        }
        for (Map.Entry entry : configs.entrySet()) {
            String config = (String)entry.getKey();
            if (config == null) continue;
            String sharedPath = "nbproject/configs/" + config + ".properties";
            String privatePath = "nbproject/private/configs/" + config + ".properties";
            Map c = (Map)entry.getValue();
            if (c == null) {
                this.project.getUpdateHelper().putProperties(sharedPath, null);
                this.project.getUpdateHelper().putProperties(privatePath, null);
                continue;
            }
            EditableProperties sharedCfgProps = this.project.getUpdateHelper().getProperties(sharedPath);
            EditableProperties privateCfgProps = this.project.getUpdateHelper().getProperties(privatePath);
            boolean privatePropsChanged = false;
            for (Map.Entry entry2 : c.entrySet()) {
                EditableProperties ep;
                String prop = (String)entry2.getKey();
                String v = (String)entry2.getValue();
                if (Utilities.compareObjects((Object)v, (Object)(ep = prop.equals("application.args") || prop.equals("work.dir") || privateCfgProps.containsKey((Object)prop) ? privateCfgProps : sharedCfgProps).getProperty(prop))) continue;
                if (v != null && (v.length() > 0 || def.get(prop) != null && def.get(prop).length() > 0)) {
                    ep.setProperty(prop, v);
                } else {
                    ep.remove((Object)prop);
                }
                privatePropsChanged |= ep == privateCfgProps;
            }
            this.project.getUpdateHelper().putProperties(sharedPath, sharedCfgProps);
            if (!privatePropsChanged) continue;
            this.project.getUpdateHelper().putProperties(privatePath, privateCfgProps);
        }
    }

    public void storeAttributesToRunConfigs() {
        HashMap[] dataDelegatesAttributes = this.ATTRIBUTES_TABLE_MODEL.getDataDelegates();
        for (int i = 0; i < dataDelegatesAttributes.length; ++i) {
            for (Map.Entry<String, Map<String, String>> entry : this.RUN_CONFIGS.entrySet()) {
                String value = this.encode(dataDelegatesAttributes[i].get(entry.getKey()));
                if (entry.getKey() != null && this.RUN_CONFIGS.get(null).get(this.ATTRIBUTES_PROPERTY_NAMES[i]).equals(value)) {
                    value = null;
                }
                if (entry.getValue() == null) continue;
                entry.getValue().put(this.ATTRIBUTES_PROPERTY_NAMES[i], value);
            }
        }
    }

    List<KeyStoreRepository.KeyStoreBean> loadKeystores() {
        return KeyStoreRepository.getDefault().getKeyStores();
    }

    Set<KeyStoreRepository.KeyStoreBean.KeyAliasBean> loadAliases() {
        return ((KeyStoreRepository.KeyStoreBean)this.SIGN_KEYSTORE_MODEL.getSelectedItem()).aliasses();
    }

    public void reloadJ2MEPlatforms() {
        this.J2ME_PLATFORM_MODEL = ModelHelper.createComboBoxModel(this.project.evaluator(), "platform.active", Arrays.asList(J2MEProjectUtils.readPlatforms()));
    }

    public ComboBoxModel loadJdkPlatforms() {
        ComboBoxModel model = J2MEProjectUtils.createJDKPlatformComboBoxModel();
        String platformActive = this.project.evaluator().getProperty(PLATFORM_SDK);
        if (platformActive != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                JavaPlatform jp = PlatformUiSupport.getPlatform(model.getElementAt(i));
                if (!platformActive.equals(jp.getProperties().get(PLATFORM_ANT_NAME))) continue;
                model.setSelectedItem(model.getElementAt(i));
                break;
            }
        }
        return model;
    }

    private static DefaultComboBoxModel<LibletInfo> createLibletModelFromProps(PropertyEvaluator eval) {
        DefaultComboBoxModel<LibletInfo> model = new DefaultComboBoxModel<LibletInfo>();
        int i = 0;
        String dep = null;
        while ((dep = eval.getProperty(PROP_LIBLET_PREFIX + i + PROP_LIBLET_DEPENDENCY)) != null) {
            String url = eval.getProperty(PROP_LIBLET_PREFIX + i + PROP_LIBLET_URL);
            boolean extractClasses = Boolean.parseBoolean(eval.getProperty(PROP_LIBLET_PREFIX + i + PROP_LIBLET_EXTRACT));
            String[] splittedDep = dep.split(";");
            LibletInfo li = new LibletInfo(LibletInfo.LibletType.valueOf(splittedDep[0].trim().toUpperCase()), splittedDep[2].trim(), splittedDep.length > 3 ? splittedDep[3].trim() : "", splittedDep.length > 4 ? splittedDep[4].trim() : "", LibletInfo.Requirement.valueOf(splittedDep[1].trim().toUpperCase()), url, extractClasses);
            model.addElement(li);
            ++i;
        }
        return model;
    }

    public static class ComboDataSource
    extends DataSource {
        private final JComboBox<?> combo;

        public ComboDataSource(@NonNull String propName, @NonNull JComboBox<J2MEPlatform.Device> combo, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, combo, configCombo, configs);
            Parameters.notNull((CharSequence)"combo", combo);
            this.combo = combo;
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ComboDataSource.this.changed(ComboDataSource.this.getPropertyValue());
                }
            });
        }

        @Override
        public final String getPropertyValue() {
            return this.combo.getSelectedItem() != null ? this.combo.getSelectedItem().toString() : null;
        }

        @Override
        public void update(String activeConfig) {
            String currentValue = this.getPropertyValue(activeConfig, this.getPropertyName());
            if (currentValue == null) {
                currentValue = "";
            }
            ComboBoxModel<?> model = this.combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object itemAt = model.getElementAt(i);
                if (!currentValue.equals(itemAt.toString())) continue;
                this.combo.setSelectedItem(itemAt);
                return;
            }
            if (this.combo.getModel().getSize() != 0) {
                this.combo.setSelectedIndex(0);
                this.changed(this.getPropertyValue());
            }
        }
    }

    public static class ButtonGroupDataSource
    extends DataSource {
        private final List<AbstractButton> options;

        public ButtonGroupDataSource(@NonNull String propName, @NonNull ButtonGroup group, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, null, configCombo, configs);
            Parameters.notNull((CharSequence)"group", (Object)group);
            this.options = Collections.list(group.getElements());
            for (final AbstractButton button : this.options) {
                button.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (button.isSelected()) {
                            ButtonGroupDataSource.this.changed(ButtonGroupDataSource.this.getPropertyValue());
                        }
                    }
                });
            }
        }

        @Override
        public final String getPropertyValue() {
            for (AbstractButton button : this.options) {
                if (!button.isSelected()) continue;
                return button.getActionCommand();
            }
            return null;
        }

        @Override
        public void update(String activeConfig) {
            String selectedOption = this.getPropertyValue(activeConfig, this.getPropertyName());
            if (selectedOption != null) {
                for (AbstractButton button : this.options) {
                    if (!selectedOption.equals(button.getActionCommand())) continue;
                    button.setSelected(true);
                }
            }
        }
    }

    public static abstract class DataSource {
        private final String propName;
        private final JComboBox<?> configCombo;
        private final Map<String, Map<String, String>> configs;
        private final JComponent label;
        private Font basefont = null;
        private Font boldfont = null;

        public DataSource(@NonNull String propName, @NullAllowed JComponent label, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            Parameters.notNull((CharSequence)"propName", (Object)propName);
            Parameters.notNull((CharSequence)"configCombo", configCombo);
            Parameters.notNull((CharSequence)"configs", configs);
            this.propName = propName;
            this.configCombo = configCombo;
            this.configs = configs;
            this.label = label;
            if (label != null) {
                this.basefont = label.getFont();
                this.boldfont = this.basefont.deriveFont(1);
            }
        }

        public final String getPropertyName() {
            return this.propName;
        }

        public final JComponent getLabel() {
            return this.label;
        }

        public final void changed(@NullAllowed String value) {
            String config = (String)this.configCombo.getSelectedItem();
            if (config.length() == 0) {
                config = null;
            }
            if (value != null && config != null && value.equals(this.configs.get(null).get(this.propName))) {
                value = null;
            }
            this.configs.get(config).put(this.propName, value);
        }

        public final void updateFont(@NullAllowed String value) {
            String config = (String)this.configCombo.getSelectedItem();
            if (config.length() == 0) {
                config = null;
            }
            String def = this.configs.get(null).get(this.propName);
            if (this.label != null) {
                this.label.setFont(config != null && !Utilities.compareObjects((Object)(value != null ? value : ""), (Object)(def != null ? def : "")) ? this.boldfont : this.basefont);
            }
        }

        @CheckForNull
        public final String getPropertyValue(@NullAllowed String config, @NonNull String key) {
            Map<String, String> m = this.configs.get(config);
            String v = m.get(key);
            if (v == null) {
                Map<String, String> def = this.configs.get(null);
                v = def.get(this.getPropertyName());
            }
            return v;
        }

        public abstract String getPropertyValue();

        public abstract void update(@NullAllowed String var1);
    }

    public static class ModelHelper {
        public static BoundedRangeModel createSliderModel(PropertyEvaluator evaluator, String propertyName, int extent, int minVal, int maxVal) {
            String value = evaluator.getProperty(propertyName);
            if (value == null) {
                value = "0";
            }
            DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(Integer.valueOf(value), extent, minVal, maxVal);
            return model;
        }

        public static <T> ComboBoxModel<T> createComboBoxModel(PropertyEvaluator evaluator, String propertyName, Collection<T> items) {
            return ModelHelper.createComboBoxModel(evaluator, propertyName, items, null);
        }

        public static <T> ComboBoxModel<T> createComboBoxModel(PropertyEvaluator evaluator, String propertyName, Collection<T> items, @NullAllowed File projectDir) {
            DefaultComboBoxModel<Object> model;
            block4: {
                Class<?> type;
                String value;
                block6: {
                    block5: {
                        if (items == null || items.isEmpty()) {
                            return new DefaultComboBoxModel();
                        }
                        model = new DefaultComboBoxModel<Object>(items.toArray());
                        value = evaluator.getProperty(propertyName);
                        type = items.toArray()[0].getClass();
                        if (value == null) break block4;
                        if (!type.equals(KeyStoreRepository.KeyStoreBean.class) || projectDir == null) break block5;
                        String absolutePath = PropertyUtils.resolveFile((File)projectDir, (String)value).getAbsolutePath();
                        for (T item : items) {
                            if (!absolutePath.equals(((KeyStoreRepository.KeyStoreBean)item).getKeyStorePath())) continue;
                            model.setSelectedItem(item);
                            break block4;
                        }
                        break block4;
                    }
                    if (!type.equals(KeyStoreRepository.KeyStoreBean.KeyAliasBean.class)) break block6;
                    for (T item : items) {
                        if (!value.equals(((KeyStoreRepository.KeyStoreBean.KeyAliasBean)item).getAlias())) continue;
                        model.setSelectedItem(item);
                        break block4;
                    }
                    break block4;
                }
                if (!type.equals(J2MEPlatform.class)) break block4;
                for (T item : items) {
                    if (!value.equals(((JavaPlatform)item).getProperties().get(J2MEProjectProperties.PLATFORM_ANT_NAME))) continue;
                    model.setSelectedItem(item);
                    break;
                }
            }
            return model;
        }

        public static JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator evaluator, String propName, Integer[] kind) {
            assert (evaluator != null && propName != null && kind != null && kind.length == 1);
            String value = evaluator.getProperty(propName);
            boolean isSelected = false;
            if (value == null) {
                isSelected = true;
            } else {
                String lowercaseValue;
                switch (lowercaseValue = value.toLowerCase()) {
                    case "yes": 
                    case "no": {
                        kind[0] = BOOLEAN_KIND_YN;
                        break;
                    }
                    case "on": 
                    case "off": {
                        kind[0] = BOOLEAN_KIND_ED;
                        break;
                    }
                    default: {
                        kind[0] = BOOLEAN_KIND_TF;
                    }
                }
                if (lowercaseValue.equals("true") || lowercaseValue.equals("yes") || lowercaseValue.equals("on")) {
                    isSelected = true;
                }
            }
            JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel();
            bm.setSelected(isSelected);
            return bm;
        }
    }
}

