/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.RepeatableSchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaException;
import org.netbeans.modules.e2e.api.schema.SchemaHolder;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaConstants;
import org.netbeans.modules.e2e.schema.SchemaHolderImpl;
import org.netbeans.modules.e2e.wsdl.WSDLConstants;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaParser
extends DefaultHandler {
    private Stack<String> state = new Stack();
    private Stack<SchemaConstruct> schemaConstructs = new Stack();
    private SchemaHolder schemaHolder;
    private String targetNamespace;
    private boolean elementFormDefault = false;
    private Stack<String> targetNamespaceStack = new Stack();
    private Map<String, String> prefixMapping = new HashMap<String, String>();
    private Locator locator;
    private URL schemaURL;
    private static final String SCHEMA = "schema";
    private static final String ELEMENT = "element";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String EXTENSION = "extension";
    private static final String SEQUENCE = "sequence";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String RESTRICTION = "restriction";
    private static final String ENUMERATION = "enumeration";
    private boolean parseWSDLTags = true;
    private List<WSDL2Java.ValidationResult> validationResults;

    public SchemaParser() {
        this.schemaHolder = new SchemaHolderImpl();
        this.validationResults = new ArrayList<WSDL2Java.ValidationResult>();
        this.addPrimitiveTypes();
    }

    public SchemaParser(boolean parseWSDLTags) {
        this();
        this.parseWSDLTags = parseWSDLTags;
        this.state.push(WSDLConstants.TYPES.getLocalPart());
    }

    private void addPrimitiveTypes() {
        Type string_type = new Type(SchemaConstants.TYPE_STRING, 3);
        string_type.setJavaTypeName("String");
        this.schemaHolder.addSchemaType(string_type);
        Type int_type = new Type(SchemaConstants.TYPE_INT, 3);
        int_type.setJavaTypeName("int");
        this.schemaHolder.addSchemaType(int_type);
        Type short_type = new Type(SchemaConstants.TYPE_SHORT, 3);
        short_type.setJavaTypeName("short");
        this.schemaHolder.addSchemaType(short_type);
        Type long_type = new Type(SchemaConstants.TYPE_LONG, 3);
        long_type.setJavaTypeName("long");
        this.schemaHolder.addSchemaType(long_type);
        Type boolean_type = new Type(SchemaConstants.TYPE_BOOLEAN, 3);
        boolean_type.setJavaTypeName("boolean");
        this.schemaHolder.addSchemaType(boolean_type);
        Type float_type = new Type(SchemaConstants.TYPE_FLOAT, 3);
        float_type.setJavaTypeName("float");
        this.schemaHolder.addSchemaType(float_type);
        Type double_type = new Type(SchemaConstants.TYPE_DOUBLE, 3);
        double_type.setJavaTypeName("double");
        this.schemaHolder.addSchemaType(double_type);
        Type byte_type = new Type(SchemaConstants.TYPE_BYTE, 3);
        byte_type.setJavaTypeName("byte");
        this.schemaHolder.addSchemaType(byte_type);
        Type base64binary_type = new Type(SchemaConstants.TYPE_BASE64_BINARY, 3);
        base64binary_type.setJavaTypeName("byte[]");
        this.schemaHolder.addSchemaType(base64binary_type);
        Type hexBinary_type = new Type(SchemaConstants.TYPE_HEX_BINARY, 3);
        hexBinary_type.setJavaTypeName("byte[]");
        this.schemaHolder.addSchemaType(hexBinary_type);
        Type qname_type = new Type(SchemaConstants.TYPE_QNAME, 3);
        qname_type.setJavaTypeName("javax.xml.namespace.QName");
        this.schemaHolder.addSchemaType(qname_type);
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public List<WSDL2Java.ValidationResult> getValidationResults() {
        return Collections.unmodifiableList(this.validationResults);
    }

    public void parse(InputStream is) throws SchemaException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser parser = spf.newSAXParser();
            parser.parse(is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getException() instanceof SchemaException) {
                throw new SchemaException(e.getCause());
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void parseLocation(URL url, String targetNamespace) throws SchemaException {
        this.targetNamespace = targetNamespace;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser parser = spf.newSAXParser();
            this.schemaURL = url;
            parser.parse(url.toURI().toString(), (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getException() instanceof SchemaException) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Error during parsing of the schema file."));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Schema " + url + " cannot be located."));
        }
        catch (ConnectException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Connection problem. Cannot download schema from " + url + " location."));
        }
        catch (IOException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Connection problem. Cannot download schema from " + url + " location."));
        }
        catch (IllegalArgumentException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, e.getLocalizedMessage()));
        }
        catch (Exception e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, e.getLocalizedMessage()));
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        QName qname = new QName(uri, localName);
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (WSDLConstants.DEFINITIONS.getLocalPart().equals(localName)) {
                this.state.push(WSDLConstants.DEFINITIONS.getLocalPart());
                return;
            }
            if (WSDLConstants.TYPES.getLocalPart().equals(localName)) {
                this.state.push(WSDLConstants.TYPES.getLocalPart());
                return;
            }
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && this.state.size() > 0) {
            Type type;
            QName qn;
            String name;
            if (localName.equals("import")) {
                String namespace = attributes.getValue("namespace");
                String schemaLocation = attributes.getValue("schemaLocation");
                if (schemaLocation == null) {
                    return;
                }
                SchemaParser sp = new SchemaParser(false);
                try {
                    URI u = this.schemaURL.toURI();
                    URI sl = u.resolve(schemaLocation);
                    sp.parseLocation(sl.toURL(), namespace);
                }
                catch (SchemaException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                this.schemaHolder.importSchema(sp.getSchemaHolder());
                this.validationResults.addAll(sp.getValidationResults());
            }
            if (localName.equalsIgnoreCase(SchemaConstants.SCHEMA.getLocalPart())) {
                this.state.push(SCHEMA);
                this.targetNamespace = this.targetNamespaceStack.push(attributes.getValue("targetNamespace") != null ? attributes.getValue("targetNamespace") : this.targetNamespace);
                if ("qualified".equals(attributes.getValue("elementFormDefault"))) {
                    this.elementFormDefault = true;
                }
                return;
            }
            if (localName.equalsIgnoreCase(SchemaConstants.ELEMENT.getLocalPart())) {
                String typeName;
                this.state.push(ELEMENT);
                QName qn2 = null;
                if (attributes.getValue("ref") != null) {
                    this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Reference in element is not supported by this version of stub compiler."));
                } else {
                    qn2 = this.schemaConstructs.isEmpty() || this.elementFormDefault ? new QName(this.targetNamespace, attributes.getValue("name")) : new QName("", attributes.getValue("name"));
                }
                Element e = new Element(qn2);
                if (this.schemaConstructs.isEmpty() || this.elementFormDefault) {
                    e.setTargetNamespace(this.targetNamespace);
                }
                this.parseSchemaConstruct(e, attributes);
                String nillable = attributes.getValue("nillable");
                if (nillable != null && "true".equals(nillable)) {
                    e.setNillable(true);
                }
                if ((typeName = attributes.getValue("type")) != null) {
                    QName typeQName = this.parseQName(typeName);
                    Type type2 = this.schemaHolder.getSchemaType(typeQName);
                    if (type2 == null) {
                        type2 = new Type(typeQName);
                        this.schemaHolder.addSchemaType(type2);
                    }
                    e.setType(type2);
                }
                if (!this.schemaConstructs.isEmpty()) {
                    SchemaConstruct.ConstructType t = this.schemaConstructs.peek().getConstructType();
                    if (SchemaConstruct.ConstructType.TYPE.equals((Object)this.schemaConstructs.peek().getConstructType())) {
                        ((Type)this.schemaConstructs.peek()).addSubconstruct(e);
                    }
                }
                this.schemaHolder.addSchemaElement(e);
                this.schemaConstructs.push(e);
                return;
            }
            if (localName.equalsIgnoreCase(SchemaConstants.COMPLEX_TYPE.getLocalPart())) {
                this.state.push(COMPLEX_TYPE);
                name = attributes.getValue("name");
                qn = null;
                type = null;
                if (name != null) {
                    qn = new QName(this.targetNamespace, name);
                    type = this.schemaHolder.getSchemaType(qn);
                    if (type == null) {
                        type = new Type(qn);
                        this.schemaHolder.addSchemaType(type);
                    } else {
                        type.setFlavor((short)1);
                    }
                }
                if (type == null) {
                    type = new Type();
                    type.setFlavor((short)1);
                }
                if (!this.schemaConstructs.isEmpty() && SchemaConstruct.ConstructType.ELEMENT.equals((Object)this.schemaConstructs.peek().getConstructType())) {
                    Element e = (Element)this.schemaConstructs.peek();
                    e.setType(type);
                } else {
                    this.schemaHolder.addSchemaType(type);
                }
                this.schemaConstructs.push(type);
                return;
            }
            if (localName.equalsIgnoreCase(SchemaConstants.SEQUENCE.getLocalPart())) {
                this.state.push(SEQUENCE);
                SchemaConstruct sc = this.schemaConstructs.peek();
                if (sc instanceof Type) {
                    Type type3 = (Type)sc;
                    type3.setFlavor((short)1);
                }
                return;
            }
            if (localName.equalsIgnoreCase(SchemaConstants.COMPLEX_CONTENT.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.state.push(COMPLEX_CONTENT);
            }
            if (localName.equalsIgnoreCase(SchemaConstants.EXTENSION.getLocalPart()) && this.state.peek().equals(COMPLEX_CONTENT)) {
                this.state.push(EXTENSION);
                name = attributes.getValue("base");
                qn = null;
                type = null;
                if (name != null) {
                    qn = this.parseQName(name);
                    type = this.schemaHolder.getSchemaType(qn);
                    if (type == null) {
                        type = new Type(qn);
                        this.schemaHolder.addSchemaType(type);
                    }
                    SchemaConstruct sc = this.schemaConstructs.peek();
                    sc.setParent(type);
                }
                return;
            }
            if (localName.equals(SchemaConstants.SIMPLE_TYPE.getLocalPart())) {
                String typeName = attributes.getValue("name");
                if (typeName == null) {
                    typeName = "";
                }
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Simple type is not supported by JSR-172 - " + typeName));
            }
            if (localName.equalsIgnoreCase(SchemaConstants.ALL.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "'all' element in complex-type element is not supported by JSR-172."));
            }
            if (localName.equalsIgnoreCase(SchemaConstants.CHOICE.getLocalPart()) && this.state.peek().equals(COMPLEX_TYPE)) {
                this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "'choice' element in complex-type element is not supported by JSR-172."));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (WSDLConstants.DEFINITIONS.getLocalPart().equals(localName)) {
                this.state.pop();
                return;
            }
            if (WSDLConstants.TYPES.getLocalPart().equals(localName)) {
                this.state.pop();
                return;
            }
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2001/XMLSchema") && this.state.size() > 0) {
            if (SchemaConstants.ELEMENT.getLocalPart().equals(localName)) {
                this.schemaConstructs.pop();
                if (!ELEMENT.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'element'."));
                }
                if (!SCHEMA.equals(this.state.peek()) && !SEQUENCE.equals(this.state.peek())) {
                    throw new SAXException("", new SchemaException("Invalid super tag for 'element'."));
                }
            }
            if (SchemaConstants.COMPLEX_TYPE.getLocalPart().equals(localName)) {
                this.schemaConstructs.pop();
                if (!COMPLEX_TYPE.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'complexType'."));
                }
            }
            if (SchemaConstants.SEQUENCE.getLocalPart().equals(localName)) {
                if (!SEQUENCE.equals(this.state.pop())) {
                    throw new SAXException("", new SchemaException("Invalid end tag for 'sequence'."));
                }
                if (!COMPLEX_TYPE.equals(this.state.peek()) && !EXTENSION.equals(this.state.peek())) {
                    throw new SAXException("", new SchemaException("Invalid 'sequence' tag position."));
                }
            }
            if (SchemaConstants.EXTENSION.getLocalPart().equals(localName)) {
                this.state.pop();
            }
            if (SchemaConstants.COMPLEX_CONTENT.getLocalPart().equals(localName)) {
                this.state.pop();
            }
        }
    }

    private void parseSchemaConstruct(RepeatableSchemaConstruct psc, Attributes attributes) {
        String minOccurs = attributes.getValue("minOccurs");
        if (minOccurs != null) {
            int value = Integer.parseInt(minOccurs);
            psc.setMinOccurs(value);
        } else {
            psc.setMinOccurs(1);
        }
        String maxOccurs = attributes.getValue("maxOccurs");
        if (maxOccurs != null) {
            if ("unbounded".equals(maxOccurs)) {
                psc.setMaxOccurs(Integer.MAX_VALUE);
            } else {
                int value = Integer.parseInt(maxOccurs);
                psc.setMaxOccurs(value);
            }
        } else {
            psc.setMaxOccurs(1);
        }
    }

    private QName parseQName(String qName) {
        if (qName == null) {
            return null;
        }
        int colonPos = qName.indexOf(58);
        if (colonPos > 0) {
            String prefix = qName.substring(0, colonPos);
            String uri = this.prefixMapping.get(prefix);
            return new QName(uri, qName.substring(colonPos + 1), prefix);
        }
        return new QName(this.targetNamespaceStack.peek(), qName);
    }
}

