/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.discovery.buildsupport.ToolsWrapperUtility;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.toolchain.support.ToolchainUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HelperLibraryUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.Pair;

public final class BuildTraceSupport {
    public static final String CND_TOOLS = "__CND_TOOLS__";
    public static final String CND_BUILD_LOG = "__CND_BUILD_LOG__";
    public static final String CND_TOOL_WRAPPER = "__CND_TOOL_WRAPPER__";
    public static final String CND_C_WRAPPER = "__CND_C_WRAPPER__";
    public static final String CND_CPP_WRAPPER = "__CND_CPP_WRAPPER__";
    private static final String SEPARATOR = ":";
    private static final boolean USE_WRAPPER = Boolean.getBoolean("cnd.discovery.use.wrapper");

    private BuildTraceSupport() {
    }

    public static boolean useBuildTrace(MakeConfiguration conf) {
        return conf.getCodeAssistanceConfiguration().getBuildAnalyzer().getValue();
    }

    public static boolean resolveSymbolicLinks(MakeConfiguration conf) {
        return conf.getCodeAssistanceConfiguration().getResolveSymbolicLinks().getValue();
    }

    public static String getTools(MakeConfiguration conf, ExecutionEnvironment execEnv) {
        String res = conf.getCodeAssistanceConfiguration().getTools().getValue();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.CCompiler, res);
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.CCCompiler, res);
        res = BuildTraceSupport.prepengTool(compilerSet, execEnv, PredefinedToolKind.FortranCompiler, res);
        return res;
    }

    public static BuildTrace supportedPlatforms(ExecutionEnvironment execEnv, MakeConfiguration conf, Project project) {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            HostInfo.OSFamily osFamily = hostInfo.getOSFamily();
            HostInfo.CpuFamily cpuFamily = hostInfo.getCpuFamily();
            if (!USE_WRAPPER) {
                switch (osFamily) {
                    case LINUX: {
                        if (cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC) {
                            return new BuildTrace(BuildTraceKind.Preload, execEnv, conf, project);
                        }
                    }
                    case SUNOS: {
                        if (cpuFamily != HostInfo.CpuFamily.X86 && cpuFamily != HostInfo.CpuFamily.SPARC) break;
                        return new BuildTrace(BuildTraceKind.Preload, execEnv, conf, project);
                    }
                }
            }
            return new BuildTrace(BuildTraceKind.Wrapper, execEnv, conf, project);
        }
        catch (IOException iOException) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    public static Set<String> getCompilerNames(Project project, PredefinedToolKind kind) {
        HashSet<String> res = new HashSet<String>();
        switch (kind) {
            case CCompiler: {
                res.add("cc");
                res.add("gcc");
                res.add("xgcc");
                res.add("clang");
                res.add("icc");
                BuildTraceSupport.addTool(project, kind, res);
                break;
            }
            case CCCompiler: {
                res.add("CC");
                res.add("g++");
                res.add("c++");
                res.add("clang++");
                res.add("icpc");
                res.add("cl");
                BuildTraceSupport.addTool(project, kind, res);
                break;
            }
            case FortranCompiler: {
                res.add("ffortran");
                res.add("f77");
                res.add("f90");
                res.add("f95");
                res.add("gfortran");
                res.add("g77");
                res.add("g90");
                res.add("g95");
                res.add("ifort");
                BuildTraceSupport.addTool(project, kind, res);
            }
        }
        return res;
    }

    private static String prepengTool(CompilerSet compilerSet, ExecutionEnvironment execEnv, PredefinedToolKind kind, String res) {
        if (compilerSet == null) {
            return res;
        }
        Tool tool = compilerSet.getTool((ToolKind)kind);
        if (tool == null) {
            return res;
        }
        String name = tool.getName();
        if (name == null || name.isEmpty()) {
            return res;
        }
        res = BuildTraceSupport.addIfNeeded(name, res);
        String path = tool.getPath();
        try {
            String canonicalPath = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)execEnv, (String)path);
            if (canonicalPath != null && (name = CndPathUtilities.getBaseName((String)canonicalPath)) != null && !name.isEmpty()) {
                res = BuildTraceSupport.addIfNeeded(name, res);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    private static String addIfNeeded(String name, String res) {
        for (String s : res.split(SEPARATOR)) {
            if (!s.equals(name)) continue;
            return res;
        }
        res = res.isEmpty() ? name : name + SEPARATOR + res;
        return res;
    }

    private static void addTool(Project project, PredefinedToolKind kind, Set<String> res) {
        CompilerSet compilerSet;
        ProjectBridge projectBridge;
        if (project != null && (projectBridge = new ProjectBridge(project)).isValid() && (compilerSet = projectBridge.getCompilerSet()) != null) {
            Tool tool;
            MakeConfiguration activeConfiguration;
            MakeConfigurationDescriptor descriptor;
            ExecutionEnvironment execEnv = null;
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider != null && provider.gotDescriptor() && (descriptor = provider.getConfigurationDescriptor()) != null && (activeConfiguration = descriptor.getActiveConfiguration()) != null) {
                execEnv = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            }
            if ((tool = compilerSet.getTool((ToolKind)kind)) != null) {
                String name = tool.getName();
                if (name != null && !name.isEmpty()) {
                    if (name.endsWith(".exe")) {
                        name = name.substring(0, name.length() - 4);
                    }
                    res.add(name);
                }
                if (execEnv != null) {
                    String path = tool.getPath();
                    try {
                        String canonicalPath = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)execEnv, (String)path);
                        if (canonicalPath != null && (name = CndPathUtilities.getBaseName((String)canonicalPath)) != null && !name.isEmpty()) {
                            if (name.endsWith(".exe")) {
                                name = name.substring(0, name.length() - 4);
                            }
                            res.add(name);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static final class BuildTraceHelper
    extends HelperLibraryUtility {
        private static final BuildTraceHelper INSTANCE = new BuildTraceHelper();

        private BuildTraceHelper() {
            super("org.netbeans.modules.cnd.actions", "bin/${osname}-${platform}${_isa}/libBuildTrace.${soext}");
        }
    }

    public static final class BuildTrace {
        private final BuildTraceKind kind;
        private final ExecutionEnvironment execEnv;
        private final MakeConfiguration conf;
        private final Project project;

        private BuildTrace(BuildTraceKind kind, ExecutionEnvironment execEnv, MakeConfiguration conf, Project project) {
            this.kind = kind;
            this.execEnv = execEnv;
            this.conf = conf;
            this.project = project;
        }

        public void modifyEnv(Env env) {
            CompilerSet wrapper;
            if (this.kind == BuildTraceKind.Wrapper && (wrapper = this.getToolsWrapper()) != null) {
                CompilerSet compilerSet = this.conf.getCompilerSet().getCompilerSet();
                Map envAsMap = env.getenvAsMap();
                Pair modifyPathEnvVariable = ToolchainUtilities.modifyPathEnvVariable((ExecutionEnvironment)this.execEnv, (Map)envAsMap, (CompilerSet)compilerSet, (String)"build");
                PlatformInfo pi = this.conf.getPlatformInfo();
                String defaultPath = wrapper.getDirectory() + pi.pathSeparator() + (String)modifyPathEnvVariable.second();
                env.putenv((String)modifyPathEnvVariable.first(), defaultPath);
                env.putenv(BuildTraceSupport.CND_TOOL_WRAPPER, wrapper.getDirectory());
                Tool tool = wrapper.getTool((ToolKind)PredefinedToolKind.CCompiler);
                if (tool != null) {
                    env.putenv(BuildTraceSupport.CND_C_WRAPPER, tool.getPath());
                }
                if ((tool = wrapper.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null) {
                    env.putenv(BuildTraceSupport.CND_CPP_WRAPPER, tool.getPath());
                }
            }
        }

        public void modifyEnv(Map<String, String> env) {
            CompilerSet wrapper;
            if (this.kind == BuildTraceKind.Wrapper && (wrapper = this.getToolsWrapper()) != null) {
                CompilerSet compilerSet = this.conf.getCompilerSet().getCompilerSet();
                Pair modifyPathEnvVariable = ToolchainUtilities.modifyPathEnvVariable((ExecutionEnvironment)this.execEnv, env, (CompilerSet)compilerSet, (String)"build");
                PlatformInfo pi = this.conf.getPlatformInfo();
                String defaultPath = (String)modifyPathEnvVariable.second();
                defaultPath = wrapper.getDirectory() + pi.pathSeparator() + defaultPath;
                env.put((String)modifyPathEnvVariable.first(), defaultPath);
                env.put(BuildTraceSupport.CND_TOOL_WRAPPER, wrapper.getDirectory());
                Tool tool = wrapper.getTool((ToolKind)PredefinedToolKind.CCompiler);
                if (tool != null) {
                    env.put(BuildTraceSupport.CND_C_WRAPPER, tool.getPath());
                }
                if ((tool = wrapper.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null) {
                    env.put(BuildTraceSupport.CND_CPP_WRAPPER, tool.getPath());
                }
            }
        }

        public void modifyPreloadEnv(Env env) throws IOException, ConnectionManager.CancellationException {
            if (BuildTraceHelper.isMac((ExecutionEnvironment)this.execEnv)) {
                String where;
                String ldPreliad = BuildTraceHelper.getLDPreloadEnvName((ExecutionEnvironment)this.execEnv);
                String merge = env.getenv(ldPreliad);
                String what = BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv);
                if (what.indexOf(58) > 0) {
                    what = what.substring(0, what.indexOf(58));
                }
                if ((where = BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv)).indexOf(58) > 0) {
                    where = where.substring(0, where.indexOf(58));
                }
                String lib = where + '/' + what;
                merge = merge != null && !merge.isEmpty() ? lib + BuildTraceSupport.SEPARATOR + merge : lib;
                env.putenv(ldPreliad, merge);
            } else {
                String ldPreliad = BuildTraceHelper.getLDPreloadEnvName((ExecutionEnvironment)this.execEnv);
                String merge = env.getenv(ldPreliad);
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv) + BuildTraceSupport.SEPARATOR + merge : BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv);
                env.putenv(ldPreliad, merge);
                String ldPath = BuildTraceHelper.getLDPathEnvName((ExecutionEnvironment)this.execEnv);
                merge = env.getenv(ldPath);
                if (merge == null || merge.isEmpty()) {
                    merge = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getEnvironment().get(ldPath);
                }
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv) + BuildTraceSupport.SEPARATOR + merge : BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv);
                env.putenv(ldPath, merge);
            }
        }

        public BuildTraceKind getKind() {
            return this.kind;
        }

        public CompilerSet getToolsWrapper() {
            ToolsWrapperUtility util = new ToolsWrapperUtility(this.execEnv, this.conf, this.project);
            return util.getToolsWrapper();
        }
    }

    public static enum BuildTraceKind {
        Preload,
        Wrapper;

    }
}

