/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.glassfish.common.parser.TreeParser;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public enum ServerDetails {
    GLASSFISH_SERVER_3(NbBundle.getMessage(ServerDetails.class, (String)"STR_3_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6", 300, "http://download.java.net/glassfish/v3/release/glassfish-v3.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post701v3.txt"),
    GLASSFISH_SERVER_3_0_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_301_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6", 301, "http://download.java.net/glassfish/3.0.1/release/glassfish-3.0.1-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post701v3-0-1.txt"),
    GLASSFISH_SERVER_3_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_31_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 310, "http://download.java.net/glassfish/3.1/release/glassfish-3.1-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post701v3-1.txt"),
    GLASSFISH_SERVER_3_1_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_311_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 311, "http://download.java.net/glassfish/3.1.1/release/glassfish-3.1.1-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post701v3-1-1.txt"),
    GLASSFISH_SERVER_3_1_2(NbBundle.getMessage(ServerDetails.class, (String)"STR_312_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 312, "http://download.java.net/glassfish/3.1.2/release/glassfish-3.1.2-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v3-1-2.txt"),
    GLASSFISH_SERVER_3_1_2_2(NbBundle.getMessage(ServerDetails.class, (String)"STR_3122_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 312, "http://download.java.net/glassfish/3.1.2.2/release/glassfish-3.1.2.2-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v3-1-2.txt"),
    GLASSFISH_SERVER_4_0(NbBundle.getMessage(ServerDetails.class, (String)"STR_40_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 400, "http://download.java.net/glassfish/4.0/release/glassfish-4.0-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v4-0.txt"),
    GLASSFISH_SERVER_4_0_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_401_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 401, "http://download.java.net/glassfish/4.0.1/release/glassfish-4.0.1-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v4-0-1.txt"),
    GLASSFISH_SERVER_4_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_41_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 410, "http://download.java.net/glassfish/4.1/release/glassfish-4.1.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v4-1.txt"),
    GLASSFISH_SERVER_4_1_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_411_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 411, "http://download.java.net/glassfish/4.1.1/release/glassfish-4.1.1.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v4-1-1.txt"),
    GLASSFISH_SERVER_5_0(NbBundle.getMessage(ServerDetails.class, (String)"STR_50_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", 500, "http://download.java.net/glassfish/5.0/release/glassfish-5.0.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post71v5-0.txt");

    private String displayName;
    private String uriFragment;
    private String indirectUrl;
    private String directUrl;
    private int versionInt;

    public static WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        return new ServerWizardIterator(new ServerDetails[]{GLASSFISH_SERVER_5_0, GLASSFISH_SERVER_4_1_1, GLASSFISH_SERVER_4_1, GLASSFISH_SERVER_4_0_1, GLASSFISH_SERVER_4_0, GLASSFISH_SERVER_3_1_2_2, GLASSFISH_SERVER_3_1_2, GLASSFISH_SERVER_3_1_1, GLASSFISH_SERVER_3_1, GLASSFISH_SERVER_3_0_1, GLASSFISH_SERVER_3}, new ServerDetails[]{GLASSFISH_SERVER_4_1_1, GLASSFISH_SERVER_4_1, GLASSFISH_SERVER_4_0, GLASSFISH_SERVER_3_1_2_2});
    }

    public static int getVersionFromInstallDirectory(File glassfishDir) {
        if (glassfishDir == null) {
            return -1;
        }
        GlassFishVersion version = ServerUtils.getServerVersion((String)glassfishDir.getAbsolutePath());
        ServerDetails sd = null;
        if (version != null) {
            switch (version) {
                case GF_3: {
                    return GLASSFISH_SERVER_3.getVersion();
                }
                case GF_3_0_1: {
                    return GLASSFISH_SERVER_3_0_1.getVersion();
                }
                case GF_3_1: {
                    return GLASSFISH_SERVER_3_1.getVersion();
                }
                case GF_3_1_1: {
                    return GLASSFISH_SERVER_3_1_1.getVersion();
                }
                case GF_3_1_2: {
                    return GLASSFISH_SERVER_3_1_2.getVersion();
                }
                case GF_3_1_2_2: 
                case GF_3_1_2_3: 
                case GF_3_1_2_4: 
                case GF_3_1_2_5: {
                    return GLASSFISH_SERVER_3_1_2_2.getVersion();
                }
                case GF_4: {
                    return GLASSFISH_SERVER_4_0.getVersion();
                }
                case GF_4_0_1: {
                    return GLASSFISH_SERVER_4_0_1.getVersion();
                }
                case GF_4_1: {
                    return GLASSFISH_SERVER_4_1.getVersion();
                }
                case GF_4_1_1: {
                    return GLASSFISH_SERVER_4_1_1.getVersion();
                }
                case GF_5: {
                    return GLASSFISH_SERVER_5_0.getVersion();
                }
            }
            return -1;
        }
        return null == sd ? -1 : sd.getVersion();
    }

    public static int getVersionFromDomainXml(File domainXml) throws IllegalStateException {
        if (null == domainXml || !domainXml.isFile() || !domainXml.canRead()) {
            return -1;
        }
        return ServerDetails.hasDefaultConfig(domainXml) ? GLASSFISH_SERVER_3_1.getVersion() : GLASSFISH_SERVER_3.getVersion();
    }

    private static boolean hasDefaultConfig(File domainXml) throws IllegalStateException {
        DomainParser dp = new DomainParser();
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/configs/config", dp));
        TreeParser.readXml(domainXml, paths);
        return dp.hasDefaultConfig();
    }

    private ServerDetails(String displayName, String uriFragment, int versionInt, String directUrl, String indirectUrl) {
        this.displayName = displayName;
        this.uriFragment = uriFragment;
        this.indirectUrl = indirectUrl;
        this.directUrl = directUrl;
        this.versionInt = versionInt;
    }

    public String toString() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragment;
    }

    public int getVersion() {
        return this.versionInt;
    }

    public boolean isInstalledInDirectory(File glassfishDir) {
        return ServerDetails.getVersionFromInstallDirectory(glassfishDir) == this.getVersion();
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public String getIndirectUrl() {
        return this.indirectUrl;
    }

    static class DomainParser
    extends TreeParser.NodeReader {
        private boolean hasDefaultConfig = false;

        DomainParser() {
        }

        private boolean hasDefaultConfig() {
            return this.hasDefaultConfig;
        }

        @Override
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            if ("default-config".equals(name)) {
                this.hasDefaultConfig = true;
            }
        }
    }
}

