/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import org.clang.basic.vfs.FileSystem;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileObjectBasedFileSystem;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.Utilities;

public class ClankFileSystemProviderImpl {
    public static final String RFS_PREFIX = "rfs:";
    private static final ClankFileSystemProviderImpl INSTANCE = new ClankFileSystemProviderImpl();

    public static ClankFileSystemProviderImpl getInstance() {
        return INSTANCE;
    }

    public IntrusiveRefCntPtr<FileSystem> getFileSystem() {
        boolean useFS = APTTraceFlags.ALWAYS_USE_NB_FS || Utilities.isWindows();
        return useFS ? new IntrusiveRefCntPtr((Object)ClankFileObjectBasedFileSystem.getInstance()) : null;
    }

    public static String getPathFromUrl(String path) {
        if (CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)RFS_PREFIX)) {
            int pos = CharSequenceUtils.indexOf((CharSequence)path, (CharSequence)":", (int)RFS_PREFIX.length());
            if (pos > 0) {
                ++pos;
                while (pos < path.length() && Character.isDigit(path.charAt(pos))) {
                    ++pos;
                }
                return path.substring(pos, path.length());
            }
            throw new IllegalArgumentException("The path " + path + " starts with " + RFS_PREFIX + " but does not contain a colon after it");
        }
        return path;
    }
}

