/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.remote.api.ui.DirectoryCellEditor;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.api.ui.FileCompletionPopup;
import org.netbeans.modules.remote.api.ui.FileNode;
import org.netbeans.modules.remote.ui.support.RemoteLogger;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;

final class FileChooserUIImpl
extends BasicFileChooserUI {
    static final String USE_SHELL_FOLDER = "FileChooser.useShellFolder";
    static final String NB_USE_SHELL_FOLDER = "nb.FileChooser.useShellFolder";
    static final String START_TIME = "cnd.start.time";
    private static final String DIALOG_IS_CLOSING = "JFileChooserDialogIsClosingProperty";
    private static final Dimension horizontalStrut1 = new Dimension(25, 1);
    private static final Dimension verticalStrut1 = new Dimension(1, 4);
    private static final Dimension verticalStrut2 = new Dimension(1, 6);
    private static final Dimension verticalStrut3 = new Dimension(1, 8);
    private static Dimension PREF_SIZE = new Dimension(425, 245);
    private static Dimension MIN_SIZE = new Dimension(425, 245);
    private static Dimension TREE_PREF_SIZE = new Dimension(380, 230);
    private static final int ACCESSORY_WIDTH = 250;
    private static final Logger LOG = Logger.getLogger(FileChooserUIImpl.class.getName());
    private static final RequestProcessor COMMON_RP = new RequestProcessor("Cnd File Chooser Common Worker", 16);
    private static final RequestProcessor UPDATE_RP = new RequestProcessor("Cnd File Chooser Update Worker");
    private static final RequestProcessor APPROVE_RP = new RequestProcessor("Cnd File Chooser Update Worker");
    private static final String TIMEOUT_KEY = "nb.fileChooser.timeout";
    private JPanel centerPanel;
    private JLabel lookInComboBoxLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterTypeComboBoxModel filterTypeComboBoxModel;
    private JTextField filenameTextField;
    private JComponent placesBar;
    private boolean placesBarFailed = false;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterTypeComboBox;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String homeFolderTooltipText = null;
    private String homeFolderAccessibleName = null;
    private final NewDirectoryAction newFolderAction = new NewDirectoryAction();
    private BasicFileChooserUI.BasicFileView fileView = new DirectoryChooserFileView();
    private JTree tree;
    private DirectoryTreeModel model;
    private LoadingTreeModel loadingModel;
    private FileNode newFolderNode;
    private JComponent treeViewPanel;
    private FileChooserBuilder.JFileChooserEx fileChooser;
    private final AtomicBoolean changeDirectory = new AtomicBoolean(true);
    private boolean showPopupCompletion = false;
    private volatile boolean addNewDirectory = false;
    private JPopupMenu popupMenu;
    private FileCompletionPopup completionPopup;
    private final UpdateWorker updateWorker = new UpdateWorker();
    private volatile ValidationWorkerCheckState currentState = new ValidationWorkerCheckState(Boolean.TRUE, new ValidationResult(Boolean.FALSE, null, false, null));
    private boolean useShellFolder = false;
    private JButton upFolderButton;
    private JButton newFolderButton;
    private JButton homeButton;
    private JComponent topCombo;
    private JComponent topComboWrapper;
    private JComponent topToolbar;
    private JPanel slownessPanel;
    private final ListFilesWorker listFilesWorker = new ListFilesWorker();
    private final RequestProcessor.Task listFilesTask = UPDATE_RP.create((Runnable)this.listFilesWorker);
    private volatile File curDir;
    private final Action approveSelectionAction;
    private Action changeToParentDirectoryAction;
    private final Action cancelSelectionAction;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private final char fileSeparatorChar;
    private String lastDir;
    private File[] lastChildren;

    public FileChooserUIImpl(FileChooserBuilder.JFileChooserEx filechooser) {
        super(filechooser);
        this.approveSelectionAction = new ApproveSelectionAction();
        this.changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
        this.cancelSelectionAction = new CancelSelectionAction();
        this.fileSeparatorChar = filechooser.getFileSeparatorChar();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.fileChooser = (FileChooserBuilder.JFileChooserEx)c;
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        super.uninstallComponents(fc);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        this.fileChooser = (FileChooserBuilder.JFileChooserEx)fc;
        fc.setFocusCycleRoot(true);
        fc.setBorder(new EmptyBorder(4, 10, 10, 10));
        fc.setLayout(new BorderLayout(8, 8));
        this.updateUseShellFolder();
        this.createCenterPanel(fc);
        fc.add((Component)this.centerPanel, "Center");
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.getStringOfFileNames(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.getStringOfFileName(fc.getSelectedFile(), true));
        }
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        this.createPopup();
        this.initUpdateWorker();
    }

    @Override
    public String getDialogTitle(JFileChooser fc) {
        String title = super.getDialogTitle(fc);
        fc.getAccessibleContext().setAccessibleDescription(title);
        return title;
    }

    private void updateUseShellFolder() {
        Boolean prop = (Boolean)this.fileChooser.getClientProperty(USE_SHELL_FOLDER);
        if (prop != null) {
            this.useShellFolder = prop;
        } else {
            File[] cbFolders;
            this.useShellFolder = false;
            File[] roots = this.fileChooser.getFileSystemView().getRoots();
            if (roots != null && roots.length == 1 && (cbFolders = this.getShellFolderRoots()) != null && cbFolders.length > 0 && Arrays.asList(cbFolders).contains(roots[0])) {
                this.useShellFolder = true;
            }
        }
        if (Utilities.isWindows()) {
            if (this.useShellFolder) {
                if (this.placesBar == null) {
                    this.placesBar = this.getPlacesBar();
                }
                if (this.placesBar != null) {
                    this.fileChooser.add((Component)this.placesBar, "Before");
                    if (this.placesBar instanceof PropertyChangeListener) {
                        this.fileChooser.addPropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                    }
                }
            } else if (this.placesBar != null) {
                this.fileChooser.remove(this.placesBar);
                if (this.placesBar instanceof PropertyChangeListener) {
                    this.fileChooser.removePropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                }
                this.placesBar = null;
            }
        }
    }

    private JComponent getPlacesBar() {
        if (this.placesBarFailed) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("sun.swing.WindowsPlacesBar");
            Class[] params = new Class[]{JFileChooser.class, Boolean.TYPE};
            Constructor<?> constr = clazz.getConstructor(params);
            return (JComponent)constr.newInstance(this.fileChooser, this.isXPStyle());
        }
        catch (Exception exc) {
            Logger.getLogger(FileChooserUIImpl.class.getName()).log(Level.FINE, "WindowsPlacesBar class can't be instantiated.", exc);
            this.placesBarFailed = true;
            return null;
        }
    }

    private File getShellFolderForFile(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File)clazz.getMethod("getShellFolder", File.class).invoke(null, file);
        }
        catch (Exception exc) {
            Logger.getLogger(FileChooserUIImpl.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private File getShellFolderForFileLinkLoc(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            Object sf = clazz.getMethod("getShellFolder", File.class).invoke(null, file);
            return (File)clazz.getMethod("getLinkLocation", new Class[0]).invoke(sf, new Object[0]);
        }
        catch (Exception exc) {
            Logger.getLogger(FileChooserUIImpl.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private File[] getShellFolderRoots() {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File[])clazz.getMethod("get", String.class).invoke(null, "fileChooserComboBoxFolders");
        }
        catch (Exception exc) {
            Logger.getLogger(FileChooserUIImpl.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private void createBottomPanel(JFileChooser fc) {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 2));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 3));
        labelPanel.add(Box.createRigidArea(verticalStrut1));
        JLabel fnl = new JLabel(this.fileNameLabelText);
        fnl.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fnl.setAlignmentY(0.0f);
        labelPanel.add(fnl);
        labelPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel ftl = new JLabel(this.filesOfTypeLabelText);
        ftl.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        labelPanel.add(ftl);
        this.bottomPanel.add(labelPanel);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel fileAndFilterPanel = new JPanel();
        fileAndFilterPanel.add(Box.createRigidArea(verticalStrut3));
        fileAndFilterPanel.setLayout(new BoxLayout(fileAndFilterPanel, 1));
        this.filenameTextField = new JTextField(24){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileChooserUIImpl.this.updateCompletions();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileChooserUIImpl.this.updateCompletions();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.filenameTextField.addKeyListener(new TextFieldKeyListener());
        this.filenameTextField.addKeyListener(new AltUpHandler(this.filenameTextField));
        fnl.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!FileChooserUIImpl.this.getFileChooser().isMultiSelectionEnabled()) {
                    FileChooserUIImpl.this.tree.clearSelection();
                }
            }
        });
        Set<AWTKeyStroke> tKeys = this.filenameTextField.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newTKeys = new HashSet<AWTKeyStroke>(tKeys);
        newTKeys.remove(AWTKeyStroke.getAWTKeyStroke(9, 0));
        newTKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        this.filenameTextField.setFocusTraversalKeys(0, newTKeys);
        fileAndFilterPanel.add(this.filenameTextField);
        fileAndFilterPanel.add(Box.createRigidArea(verticalStrut3));
        this.filterTypeComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterTypeComboBoxModel);
        this.filterTypeComboBox = new JComboBox(this.filterTypeComboBoxModel);
        ftl.setLabelFor(this.filterTypeComboBox);
        this.filterTypeComboBox.setRenderer(this.createFilterComboBoxRenderer());
        fileAndFilterPanel.add(this.filterTypeComboBox);
        this.bottomPanel.add(fileAndFilterPanel);
        this.bottomPanel.add(Box.createRigidArea(horizontalStrut1));
        this.createButtonsPanel(fc);
    }

    private void createButtonsPanel(JFileChooser fc) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.approveButton = new JButton(this.getApproveButtonText(fc)){

            @Override
            public Dimension getMaximumSize() {
                return ((FileChooserUIImpl)FileChooserUIImpl.this).approveButton.getPreferredSize().width > ((FileChooserUIImpl)FileChooserUIImpl.this).cancelButton.getPreferredSize().width ? FileChooserUIImpl.this.approveButton.getPreferredSize() : FileChooserUIImpl.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        }
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.buttonPanel.add(Box.createRigidArea(verticalStrut1));
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(Box.createRigidArea(verticalStrut2));
        this.cancelButton = new JButton(this.cancelButtonText){

            @Override
            public Dimension getMaximumSize() {
                return ((FileChooserUIImpl)FileChooserUIImpl.this).approveButton.getPreferredSize().width > ((FileChooserUIImpl)FileChooserUIImpl.this).cancelButton.getPreferredSize().width ? FileChooserUIImpl.this.approveButton.getPreferredSize() : FileChooserUIImpl.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        }
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel.add(this.cancelButton);
    }

    private void createCenterPanel(final JFileChooser fc) {
        this.centerPanel = new JPanel(new BorderLayout());
        this.treeViewPanel = this.createTree();
        this.treeViewPanel.setPreferredSize(TREE_PREF_SIZE);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        JComponent accessory = fc.getAccessory();
        this.topToolbar = this.createTopToolbar();
        this.topCombo = this.createTopCombo(fc);
        this.topComboWrapper = new JPanel(new BorderLayout());
        this.topComboWrapper.add((Component)this.topCombo, "Center");
        if (accessory == null) {
            this.topComboWrapper.add((Component)this.topToolbar, "East");
        }
        treePanel.add((Component)this.topComboWrapper, "North");
        treePanel.add((Component)this.treeViewPanel, "Center");
        this.centerPanel.add((Component)treePanel, "Center");
        JPanel wrapAccessory = new JPanel(){
            private Dimension prefSize = new Dimension(250, 0);
            private Dimension minSize = new Dimension(250, 0);

            @Override
            public Dimension getMinimumSize() {
                if (fc.getAccessory() != null) {
                    this.minSize.height = FileChooserUIImpl.this.getAccessoryPanel().getMinimumSize().height;
                    return this.minSize;
                }
                return super.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                if (fc.getAccessory() != null) {
                    Dimension origPref = FileChooserUIImpl.this.getAccessoryPanel().getPreferredSize();
                    LOG.fine("AccessoryWrapper.getPreferredSize: orig pref size: " + origPref);
                    this.prefSize.height = origPref.height;
                    this.prefSize.width = Math.max(this.prefSize.width, origPref.width);
                    int centerW = FileChooserUIImpl.this.centerPanel.getWidth();
                    if (centerW != 0 && this.prefSize.width > centerW / 2) {
                        this.prefSize.width = centerW / 2;
                    }
                    LOG.fine("AccessoryWrapper.getPreferredSize: resulting pref size: " + this.prefSize);
                    return this.prefSize;
                }
                return super.getPreferredSize();
            }
        };
        wrapAccessory.setLayout(new BorderLayout());
        JPanel accessoryPanel = this.getAccessoryPanel();
        if (accessory != null) {
            accessoryPanel.add((Component)this.topToolbar, "North");
            accessoryPanel.add((Component)accessory, "Center");
        }
        wrapAccessory.add((Component)accessoryPanel, "Center");
        this.centerPanel.add((Component)wrapAccessory, "East");
        this.createBottomPanel(fc);
        this.centerPanel.add((Component)this.bottomPanel, "South");
    }

    private JComponent createTopCombo(JFileChooser fc) {
        JPanel panel = new JPanel();
        if (fc.getAccessory() != null) {
            panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        } else {
            panel.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
        }
        panel.setLayout(new BorderLayout());
        Box labelBox = Box.createHorizontalBox();
        this.lookInComboBoxLabel = new JLabel(this.lookInLabelText);
        this.lookInComboBoxLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInComboBoxLabel.setAlignmentX(0.0f);
        this.lookInComboBoxLabel.setAlignmentY(0.5f);
        labelBox.add(this.lookInComboBoxLabel);
        labelBox.add(Box.createRigidArea(new Dimension(9, 0)));
        this.directoryComboBox = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = 60;
                return d;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 24;
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInComboBoxLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        panel.add((Component)labelBox, "West");
        panel.add((Component)this.directoryComboBox, "Center");
        return panel;
    }

    private JComponent createTopToolbar() {
        JToolBar topPanel = new JToolBar();
        topPanel.setFloatable(false);
        if (Utilities.isWindows()) {
            topPanel.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        this.upFolderButton.setText(null);
        boolean isMac = Utilities.isMac();
        Icon upOneLevelIcon = null;
        if (!isMac) {
            upOneLevelIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        }
        if (isMac || upOneLevelIcon == null || this.jdkBug6840086Workaround()) {
            upOneLevelIcon = isMac ? ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/upFolderIcon_mac.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/upFolderIcon.gif", (boolean)false);
        }
        this.upFolderButton.setIcon(upOneLevelIcon);
        this.upFolderButton.setToolTipText(this.upFolderToolTipText);
        this.upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(1.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.upFolderButton.setFocusPainted(false);
        }
        topPanel.add(this.upFolderButton);
        topPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        if (!Utilities.isWindows()) {
            this.homeButton = new JButton(this.getGoHomeAction());
            Icon homeIcon = null;
            if (!isMac) {
                homeIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
            }
            if (isMac || homeIcon == null) {
                homeIcon = isMac ? ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/homeIcon_mac.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/homeIcon.gif", (boolean)false);
            }
            this.homeButton.setIcon(homeIcon);
            this.homeButton.setText(null);
            String tooltip = this.homeButton.getToolTipText();
            if (tooltip == null) {
                tooltip = this.homeFolderTooltipText;
                if (tooltip == null) {
                    tooltip = NbBundle.getMessage(FileChooserUIImpl.class, (String)"TLTP_HomeFolder");
                }
                this.homeButton.setToolTipText(tooltip);
            }
            if (null != this.homeFolderAccessibleName) {
                this.homeButton.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
            }
            topPanel.add(this.homeButton);
        }
        this.newFolderButton = new JButton(this.newFolderAction);
        this.newFolderButton.setText(null);
        Icon newFoldIcon = null;
        if (!isMac) {
            newFoldIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        }
        if (isMac || newFoldIcon == null || this.jdkBug6840086Workaround()) {
            newFoldIcon = isMac ? ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/newFolderIcon_mac.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/swing/dirchooser/resources/newFolderIcon.gif", (boolean)false);
        }
        this.newFolderButton.setIcon(newFoldIcon);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.newFolderButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        this.newFolderButton.setAlignmentX(1.0f);
        this.newFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.newFolderButton.setFocusPainted(false);
        }
        topPanel.add(this.newFolderButton);
        topPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 9, 8, 0));
        panel.add((Component)topPanel, "Center");
        return panel;
    }

    private JComponent createTree() {
        final DirectoryHandler dirHandler = this.createDirectoryHandler(this.fileChooser);
        this.tree = new JTree(new Object[0]){
            private boolean firstPaint;
            {
                super(x0);
                this.firstPaint = true;
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (this.isEnabled()) {
                    dirHandler.preprocessMouseEvent(e);
                    super.processMouseEvent(e);
                }
            }

            @Override
            public boolean isLargeModel() {
                return true;
            }

            @Override
            public void setRowHeight(int rowHeight) {
                if (rowHeight > 0) {
                    super.setRowHeight(rowHeight);
                }
            }

            @Override
            public void setFont(Font f) {
                this.firstPaint = true;
                super.setFont(f);
            }

            @Override
            public void paint(Graphics g) {
                if (this.firstPaint) {
                    g.setFont(this.getFont());
                    this.setRowHeight(Math.max(17, g.getFontMetrics().getHeight()));
                    this.firstPaint = false;
                    return;
                }
                super.paint(g);
            }
        };
        this.tree.setFocusable(true);
        this.tree.setOpaque(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setToggleClickCount(0);
        this.tree.addTreeExpansionListener(new TreeExpansionHandler());
        TreeKeyHandler keyHandler = new TreeKeyHandler();
        this.tree.addKeyListener(keyHandler);
        this.tree.addKeyListener(new AltUpHandler(this.tree));
        this.tree.addFocusListener(keyHandler);
        this.tree.addMouseListener(dirHandler);
        this.tree.addFocusListener(dirHandler);
        this.tree.addTreeSelectionListener(dirHandler);
        if (this.fileChooser.isMultiSelectionEnabled()) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
        DirectoryCellEditor tce = new DirectoryCellEditor(this.tree, this.fileChooser, new JTextField());
        this.tree.setCellEditor(tce);
        tce.addCellEditorListener(dirHandler);
        this.tree.setCellRenderer(new DirectoryTreeRenderer());
        JScrollPane scrollBar = new JScrollPane(this.tree);
        scrollBar.setViewportView(this.tree);
        this.tree.setInvokesStopCellEditing(true);
        return scrollBar;
    }

    private boolean jdkBug6840086Workaround() {
        return Utilities.isWindows() && "Windows 7".equals(System.getProperty("os.name")) && "1.6.0_16".compareTo(System.getProperty("java.version")) >= 0;
    }

    private List<TreePath> getVisiblePaths() {
        int rowCount = this.tree.getRowCount();
        Object node = null;
        ArrayList<TreePath> result = new ArrayList<TreePath>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            result.add(this.tree.getPathForRow(i));
        }
        return result;
    }

    private void createPopup() {
        this.popupMenu = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(FileChooserUIImpl.getBundle().getString("LBL_NewFolder"));
        item1.addActionListener(this.newFolderAction);
        JMenuItem item2 = new JMenuItem(FileChooserUIImpl.getBundle().getString("LBL_Rename"));
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object lastSelectedPathComponent = FileChooserUIImpl.this.tree.getLastSelectedPathComponent();
                if (lastSelectedPathComponent instanceof FileNode) {
                    FileNode node = (FileNode)lastSelectedPathComponent;
                    FileChooserUIImpl.this.applyEdit(node);
                }
            }
        });
        JMenuItem item3 = new JMenuItem(FileChooserUIImpl.getBundle().getString("LBL_Delete"));
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserUIImpl.this.deleteAction();
            }
        });
        this.popupMenu.add(item1);
        this.popupMenu.add(item2);
        this.popupMenu.add(item3);
    }

    private void deleteAction() {
        final TreePath[] nodePath = this.tree.getSelectionPaths();
        if (nodePath == null) {
            return;
        }
        String message = "";
        if (nodePath.length == 1) {
            File file = FileChooserUIImpl.getLeafFile(nodePath[0]);
            if (!FileChooserUIImpl.canWrite(file)) {
                return;
            }
            message = MessageFormat.format(FileChooserUIImpl.getBundle().getString("MSG_Delete"), file.getName());
        } else {
            message = MessageFormat.format(FileChooserUIImpl.getBundle().getString("MSG_Delete_Multiple"), nodePath.length);
        }
        int answer = JOptionPane.showConfirmDialog(this.fileChooser, message, FileChooserUIImpl.getBundle().getString("MSG_Confirm"), 0);
        if (answer == 0) {
            COMMON_RP.post(new Runnable(){
                FileNode node;
                ArrayList<File> list = new ArrayList();
                int cannotDelete;
                ArrayList<FileNode> nodes2Remove = new ArrayList(nodePath.length);

                @Override
                public void run() {
                    if (!EventQueue.isDispatchThread()) {
                        FileChooserUIImpl.this.setCursor(FileChooserUIImpl.this.fileChooser, 3);
                        this.cannotDelete = 0;
                        for (int i = 0; i < nodePath.length; ++i) {
                            Object lastPathComponent = nodePath[i].getLastPathComponent();
                            if (!(lastPathComponent instanceof FileNode)) continue;
                            FileNode nodeToDelete = (FileNode)lastPathComponent;
                            try {
                                FileChooserUIImpl.this.delete(nodeToDelete.getFile());
                                this.nodes2Remove.add(nodeToDelete);
                                continue;
                            }
                            catch (IOException ignore) {
                                ++this.cannotDelete;
                                if (!FileChooserUIImpl.canWrite(nodeToDelete.getFile())) continue;
                                this.list.add(nodeToDelete.getFile());
                            }
                        }
                        EventQueue.invokeLater(this);
                    } else {
                        for (FileNode curNode : this.nodes2Remove) {
                            FileChooserUIImpl.this.model.removeNodeFromParent(curNode);
                        }
                        FileChooserUIImpl.this.setCursor(FileChooserUIImpl.this.fileChooser, 0);
                        if (this.cannotDelete > 0) {
                            String message = "";
                            message = this.cannotDelete == 1 ? this.cannotDelete + " " + FileChooserUIImpl.getBundle().getString("MSG_Sing_Delete") : this.cannotDelete + " " + FileChooserUIImpl.getBundle().getString("MSG_Plur_Delete");
                            FileChooserUIImpl.this.setSelected(this.list.toArray(new File[this.list.size()]));
                            JOptionPane.showConfirmDialog(FileChooserUIImpl.this.fileChooser, message, FileChooserUIImpl.getBundle().getString("MSG_Confirm"), 0);
                        } else {
                            FileChooserUIImpl.this.setSelected(new File[]{null});
                            FileChooserUIImpl.this.setFileName("");
                        }
                    }
                }
            });
        }
    }

    private void delete(File file) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null && file.equals(FileUtil.toFile((FileObject)fo))) {
            fo.delete();
        } else if (!file.delete()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompletions() {
        String name;
        int slash;
        if (this.showPopupCompletion && (slash = (name = this.normalizeFile(this.getFileName())).lastIndexOf(this.fileSeparatorChar)) != -1) {
            File[] children;
            String prefix = name.substring(0, slash + 1);
            ListFilesWorker listFilesWorker = this.listFilesWorker;
            synchronized (listFilesWorker) {
                if (!prefix.equals(this.lastDir)) {
                    if (this.completionPopup != null) {
                        this.completionPopup.setDataList(new Vector<File>(0));
                        this.completionPopup.detach();
                        this.completionPopup = null;
                    }
                    this.listFilesWorker.d = prefix;
                    this.listFilesTask.schedule(0);
                    return;
                }
                children = this.lastChildren;
            }
            if (children != null) {
                Vector<File> list = this.buildList(name, children, 20);
                if (this.completionPopup == null) {
                    this.completionPopup = new FileCompletionPopup(this.fileChooser, this.filenameTextField, list);
                } else if (this.completionPopup.isShowing() || this.showPopupCompletion && this.fileChooser.isShowing()) {
                    this.completionPopup.setDataList(list);
                }
                if (this.fileChooser.isShowing() && !this.completionPopup.isShowing()) {
                    Point los = this.filenameTextField.getLocation();
                    int popX = los.x;
                    int popY = los.y + this.filenameTextField.getHeight() - 6;
                    this.completionPopup.showPopup(this.filenameTextField, popX, popY);
                }
            }
        }
    }

    public Vector<File> buildList(String text, File[] children, int max) {
        Vector<File> files = new Vector<File>(children.length);
        Arrays.sort(children, FileNode.FILE_NAME_COMPARATOR);
        for (File completion : children) {
            String path = completion.getAbsolutePath();
            if (path.regionMatches(true, 0, text, 0, text.length())) {
                files.add(completion);
            }
            if (files.size() >= max) break;
        }
        return files;
    }

    private String normalizeFile(String text) {
        Matcher m;
        Pattern p = Pattern.compile("(^|[^\\\\])\\$([a-zA-Z_0-9.]+)");
        while ((m = p.matcher(text)).find()) {
            String var = System.getenv(m.group(2));
            if (var == null) {
                var = System.getProperty(m.group(2), "");
            }
            text = text.substring(0, m.end(1)) + var + text.substring(m.end(2));
        }
        if (text.equals("~")) {
            return this.fileChooser.getHomePath();
        }
        if (text.startsWith("~" + this.fileSeparatorChar)) {
            return this.fileChooser.getHomePath() + text.substring(1);
        }
        int i = text.lastIndexOf("//");
        if (i != -1) {
            return text.substring(i + 1);
        }
        i = text.lastIndexOf(this.fileSeparatorChar + "~" + this.fileSeparatorChar);
        if (i != -1) {
            return this.fileChooser.getHomePath() + text.substring(i + 2);
        }
        return text;
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(FileChooserUIImpl.class);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        if (!this.changeDirectory.get()) {
            return;
        }
        super.rescanCurrentDirectory(fc);
        File oldValue = this.curDir;
        File dir = fc.getCurrentDirectory();
        if (oldValue != null && oldValue.equals(dir)) {
            return;
        }
        this.curDir = dir;
        this.updateWorker.updateTree(this.curDir);
        this.fireDirectoryChanged(null);
    }

    private void initUpdateWorker() {
        this.updateWorker.attachFileChooser(this);
    }

    private void markStartTime() {
        this.fileChooser.putClientProperty(START_TIME, System.currentTimeMillis());
    }

    private void checkUpdate() {
        if (Utilities.isWindows() && this.useShellFolder) {
            Long startTime = (Long)this.fileChooser.getClientProperty(START_TIME);
            if (startTime == null) {
                return;
            }
            this.fileChooser.putClientProperty(START_TIME, null);
            long elapsed = System.currentTimeMillis() - startTime;
            long timeOut = NbPreferences.forModule(FileChooserUIImpl.class).getLong(TIMEOUT_KEY, 10000L);
            if (timeOut > 0L && elapsed > timeOut && this.slownessPanel == null) {
                JLabel slownessNote = new JLabel(NbBundle.getMessage(FileChooserUIImpl.class, (String)"MSG_SlownessNote"));
                slownessNote.setForeground(Color.RED);
                this.slownessPanel = new JPanel();
                JButton notShow = new JButton(NbBundle.getMessage(FileChooserUIImpl.class, (String)"BTN_NotShow"));
                notShow.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NbPreferences.forModule(FileChooserUIImpl.class).putLong(FileChooserUIImpl.TIMEOUT_KEY, 0L);
                        FileChooserUIImpl.this.centerPanel.remove(FileChooserUIImpl.this.slownessPanel);
                        FileChooserUIImpl.this.centerPanel.revalidate();
                    }
                });
                JPanel notShowP = new JPanel();
                notShowP.add(notShow);
                this.slownessPanel.setLayout(new BorderLayout());
                this.slownessPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
                this.slownessPanel.add("Center", slownessNote);
                this.slownessPanel.add("South", notShowP);
                this.centerPanel.add("North", this.slownessPanel);
                this.centerPanel.revalidate();
            }
        }
    }

    private Boolean isXPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (themeActive == null) {
            themeActive = Boolean.FALSE;
        }
        if (themeActive.booleanValue() && System.getProperty("swing.noxp") == null) {
            themeActive = Boolean.TRUE;
        }
        return themeActive;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        if (null == this.upFolderToolTipText) {
            this.upFolderToolTipText = NbBundle.getMessage(FileChooserUIImpl.class, (String)"TLTP_UpFolder");
        }
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        if (null == this.upFolderAccessibleName) {
            this.upFolderAccessibleName = NbBundle.getMessage(FileChooserUIImpl.class, (String)"ACN_UpFolder");
        }
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        if (null == this.newFolderToolTipText) {
            this.newFolderToolTipText = NbBundle.getMessage(FileChooserUIImpl.class, (String)"TLTP_NewFolder");
        }
        this.newFolderAccessibleName = NbBundle.getMessage(FileChooserUIImpl.class, (String)"ACN_NewFolder");
        this.homeFolderTooltipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        if (null == this.homeFolderTooltipText) {
            this.homeFolderTooltipText = NbBundle.getMessage(FileChooserUIImpl.class, (String)"TLTP_HomeFolder");
        }
        this.homeFolderAccessibleName = NbBundle.getMessage(FileChooserUIImpl.class, (String)"ACN_HomeFolder");
    }

    @Override
    protected void installListeners(final JFileChooser fc) {
        super.installListeners(fc);
        fc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("directoryChanged".equals(evt.getPropertyName()) && fc == FileChooserUIImpl.this.fileChooser) {
                    FileChooserUIImpl.this.rescanCurrentDirectory(FileChooserUIImpl.this.fileChooser);
                } else if (FileChooserUIImpl.DIALOG_IS_CLOSING.equals(evt.getPropertyName()) && fc == FileChooserUIImpl.this.fileChooser) {
                    FileChooserUIImpl.this.updateWorker.shutdown();
                }
            }
        });
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserUIImpl.this.getCancelSelectionAction().actionPerformed(e);
            }

            @Override
            public boolean isEnabled() {
                return FileChooserUIImpl.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterTypeComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = FileChooserUIImpl.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < FileChooserUIImpl.PREF_SIZE.height ? FileChooserUIImpl.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, FileChooserUIImpl.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String getStringOfFileName(File file, boolean singleSelection) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            if (fc.getFileSystemView().isDrive(file)) {
                return file.getPath();
            }
            return file.getPath();
        }
        if (singleSelection) {
            return file.getName();
        }
        return file.getPath();
    }

    private String getStringOfFileNames(File[] files) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.getStringOfFileName(files[i], files.length <= 1));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void fireSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.getStringOfFileName(f, true));
        }
    }

    private void fireSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || files[0] != null && !files[0].isDirectory())) {
            this.setFileName(this.getStringOfFileNames(files));
        }
    }

    private void fireDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.showPopupCompletion = false;
        this.setFileName("");
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.newFolderAction.enable(currentDirectory);
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (e != null) {
                this.updateWorker.updateTree(currentDirectory);
            }
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(this.getStringOfFileName(fc.getSelectedFile() == null ? currentDirectory : fc.getSelectedFile(), true));
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void fireFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        this.updateWorker.handleValidationParamasChanges();
    }

    private void fireFileSelectionModeChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void fireMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void fireAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent oldAcc = (JComponent)e.getOldValue();
            JComponent newAcc = (JComponent)e.getNewValue();
            JPanel accessoryPanel = this.getAccessoryPanel();
            if (oldAcc != null) {
                accessoryPanel.remove(oldAcc);
            }
            if (oldAcc != null && newAcc == null) {
                accessoryPanel.remove(this.topToolbar);
                this.topComboWrapper.add((Component)this.topToolbar, "East");
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
                this.topCombo.revalidate();
            }
            if (newAcc != null) {
                this.getAccessoryPanel().add((Component)newAcc, "Center");
            }
            if (oldAcc == null && newAcc != null) {
                this.topComboWrapper.remove(this.topToolbar);
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
                accessoryPanel.add((Component)this.topToolbar, "North");
            }
        }
    }

    private void fireApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        }
    }

    private void fireDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        }
        if (chooser.getDialogType() == 1) {
            this.lookInComboBoxLabel.setText(this.saveInLabelText);
        } else {
            this.lookInComboBoxLabel.setText(this.lookInLabelText);
        }
    }

    private void fireApproveButtonMnemonicChanged(PropertyChangeEvent e) {
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        }
    }

    private void fireControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    FileChooserUIImpl.this.fireSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    FileChooserUIImpl.this.fireSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged") && FileChooserUIImpl.this.changeDirectory.get()) {
                    FileChooserUIImpl.this.fireDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    FileChooserUIImpl.this.fireFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    FileChooserUIImpl.this.fireFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    FileChooserUIImpl.this.fireMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    FileChooserUIImpl.this.fireAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileChooserUIImpl.this.fireApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    FileChooserUIImpl.this.fireDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileChooserUIImpl.this.fireApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    FileChooserUIImpl.this.fireControlButtonsChanged(e);
                } else if (s.equals(FileChooserUIImpl.USE_SHELL_FOLDER)) {
                    FileChooserUIImpl.this.updateUseShellFolder();
                    FileChooserUIImpl.this.fireDirectoryChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    FileChooserUIImpl.this.filenameTextField.selectAll();
                    FileChooserUIImpl.this.filenameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.bottomPanel.remove(this.buttonPanel);
    }

    protected void addControlButtons() {
        this.bottomPanel.add(this.buttonPanel);
    }

    @Override
    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    private DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    private FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterTypeComboBoxModel createFilterComboBoxModel() {
        return new FilterTypeComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private void setSelected(File[] files) {
        this.changeDirectory.set(false);
        this.fileChooser.setSelectedFiles(files);
        this.changeDirectory.set(true);
    }

    private DirectoryHandler createDirectoryHandler(JFileChooser chooser) {
        return new DirectoryHandler(chooser);
    }

    private void addNewDirectory(final TreePath path) {
        COMMON_RP.post(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object lastPathComponent = path.getLastPathComponent();
                        if (lastPathComponent instanceof FileNode) {
                            FileNode selectedNode = (FileNode)lastPathComponent;
                            if (selectedNode == null || !FileChooserUIImpl.canWrite(selectedNode.getFile())) {
                                return;
                            }
                            try {
                                FileChooserUIImpl.this.newFolderNode = new FileNode(FileChooserUIImpl.this.fileChooser.getFileSystemView().createNewFolder(selectedNode.getFile()));
                                FileChooserUIImpl.this.model.insertNodeInto(FileChooserUIImpl.this.newFolderNode, selectedNode, selectedNode.getChildCount());
                                FileChooserUIImpl.this.applyEdit(FileChooserUIImpl.this.newFolderNode);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        });
    }

    private void applyEdit(FileNode node) {
        Object[] nodes = this.model.getPathToRoot(node);
        TreePath editingPath = new TreePath(nodes);
        this.tree.setEditable(true);
        this.tree.makeVisible(editingPath);
        this.tree.scrollPathToVisible(editingPath);
        this.tree.setSelectionPath(editingPath);
        this.tree.startEditingAtPath(editingPath);
        JTextField editField = DirectoryCellEditor.getTextField();
        editField.setCursor(Cursor.getPredefinedCursor(2));
        editField.setRequestFocusEnabled(true);
        editField.requestFocus();
        editField.setSelectionStart(0);
        editField.setSelectionEnd(editField.getText().length());
    }

    private static boolean canWrite(File f) {
        boolean writeable = false;
        if (f != null) {
            try {
                writeable = f.canWrite();
            }
            catch (AccessControlException ex) {
                writeable = false;
            }
        }
        return writeable;
    }

    private void expandNode(final JFileChooser fileChooser, final TreePath path) {
        COMMON_RP.post(new Runnable(){
            FileNode node;

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    FileChooserUIImpl.this.markStartTime();
                    FileChooserUIImpl.this.setCursor(fileChooser, 3);
                    Object lastPathComponent = path.getLastPathComponent();
                    if (lastPathComponent instanceof FileNode) {
                        this.node = (FileNode)lastPathComponent;
                        this.node.loadChildren(fileChooser, true);
                        EventQueue.invokeLater(this);
                    }
                } else {
                    ((DefaultTreeModel)FileChooserUIImpl.this.tree.getModel()).nodeStructureChanged(this.node);
                    if (FileChooserUIImpl.this.addNewDirectory) {
                        FileChooserUIImpl.this.addNewDirectory(path);
                        FileChooserUIImpl.this.addNewDirectory = false;
                    }
                    FileChooserUIImpl.this.setCursor(fileChooser, 0);
                    FileChooserUIImpl.this.checkUpdate();
                }
            }
        });
    }

    private void loadNode(final JFileChooser fileChooser, final FileNode node) {
        COMMON_RP.post(new Runnable(){

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    FileChooserUIImpl.this.markStartTime();
                    FileChooserUIImpl.this.setCursor(fileChooser, 3);
                    node.loadChildren(fileChooser, true);
                    EventQueue.invokeLater(this);
                } else {
                    ((DefaultTreeModel)FileChooserUIImpl.this.tree.getModel()).reload(node);
                    FileChooserUIImpl.this.setCursor(fileChooser, 0);
                    FileChooserUIImpl.this.checkUpdate();
                }
            }
        });
    }

    private void setCursor(final JComponent comp, final int type) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileChooserUIImpl.this.setCursor(comp, type);
                }
            });
        } else {
            Window window = SwingUtilities.getWindowAncestor(comp);
            if (window != null) {
                Cursor cursor = Cursor.getPredefinedCursor(type);
                window.setCursor(cursor);
                window.setFocusable(true);
            }
        }
    }

    private void refreshNode(TreePath path, final FileNode node) {
        final File folder = node.getFile();
        if (!folder.exists()) {
            TreePath parentPath = path.getParentPath();
            boolean refreshTree = false;
            if (this.tree.isExpanded(path)) {
                this.tree.collapsePath(path);
                refreshTree = true;
            }
            this.model.removeNodeFromParent(node);
            if (refreshTree) {
                this.tree.expandPath(parentPath);
            }
            return;
        }
        COMMON_RP.post(new Runnable(){
            private Set<String> realDirs;

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    this.realDirs = new HashSet<String>();
                    File[] files = folder.listFiles();
                    for (File file : files = files == null ? new File[]{} : files) {
                        if (!file.isDirectory()) continue;
                        String name = file.getName();
                        this.realDirs.add(name);
                    }
                    SwingUtilities.invokeLater(this);
                } else {
                    HashSet currentNames;
                    int count = node.getChildCount();
                    HashMap<String, FileNode> currentFiles = new HashMap<String, FileNode>();
                    for (int i = 0; i < count; ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!(child instanceof FileNode)) continue;
                        File file = ((FileNode)child).getFile();
                        currentFiles.put(file.getName(), (FileNode)child);
                    }
                    HashSet<String> realCloned = new HashSet<String>(this.realDirs);
                    if (realCloned.removeAll(currentFiles.keySet())) {
                        for (String name : realCloned) {
                            FileNode added = new FileNode(FileChooserUIImpl.this.getFileChooser().getFileSystemView().createFileObject(folder, name));
                            FileChooserUIImpl.this.model.insertNodeInto(added, node, node.getChildCount());
                        }
                    }
                    if ((currentNames = new HashSet(currentFiles.keySet())).removeAll(this.realDirs)) {
                        for (String name : currentNames) {
                            FileNode removed = (FileNode)currentFiles.get(name);
                            FileChooserUIImpl.this.model.removeNodeFromParent(removed);
                        }
                    }
                }
            }
        });
    }

    private void updateTree() {
        ValidationResult validationResult = this.currentState.validationResult;
        TreeNode rootNode = validationResult.node;
        if (validationResult.isValid.booleanValue() && rootNode != null) {
            FileNode fn;
            this.curDir = validationResult.currentFile;
            this.model = new DirectoryTreeModel(rootNode);
            this.tree.setModel(this.model);
            this.tree.repaint();
            this.checkUpdate();
            if (validationResult.isDirectoryChanged) {
                this.fireDirectoryChanged(null);
            }
            boolean isLoading = false;
            if (rootNode instanceof FileNode && !(fn = (FileNode)rootNode).isLoaded()) {
                isLoading = true;
                this.loadNode(this.fileChooser, fn);
            }
            if (!isLoading) {
                this.setCursor(this.fileChooser, 0);
            }
            return;
        }
        if (this.loadingModel == null) {
            this.loadingModel = new LoadingTreeModel();
        }
        this.setCursor(this.fileChooser, 3);
        this.markStartTime();
        this.tree.setModel(this.loadingModel);
        this.tree.repaint();
        this.checkUpdate();
        if (validationResult.isDirectoryChanged) {
            this.fireDirectoryChanged(null);
        }
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    @Override
    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    @Override
    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    private void enableAllButCancel(boolean enable) {
        this.upFolderButton.setEnabled(enable);
        this.newFolderButton.setEnabled(enable);
        this.approveButton.setEnabled(enable);
        this.newFolderButton.setEnabled(enable);
        if (this.homeButton != null) {
            this.homeButton.setEnabled(enable);
        }
        this.popupMenu.setEnabled(enable);
        this.filenameTextField.setEditable(enable);
        this.filenameTextField.setEnabled(enable);
        this.filterTypeComboBox.setEnabled(enable);
        this.tree.setEnabled(enable);
        this.directoryComboBox.setEnabled(enable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void changeDirectory(File dir) {
        JFileChooser fc = this.getFileChooser();
        if (dir != null && FilePane.usesShellFolder(fc)) {
            try {
                ShellFolder shellFolder = ShellFolder.getShellFolder(dir);
                if (shellFolder.isLink()) {
                    ShellFolder linkedTo = shellFolder.getLinkLocation();
                    if (linkedTo != null) {
                        if (!fc.isTraversable(linkedTo)) return;
                        dir = linkedTo;
                    } else {
                        dir = shellFolder;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                return;
            }
        }
        fc.setCurrentDirectory(dir);
        if (fc.getFileSelectionMode() != 2 || !fc.getFileSystemView().isFileSystem(dir)) return;
        this.setFileName(dir.getAbsolutePath());
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser chooser = this.getFileChooser();
            FileFilter currentFilter = chooser.getFileFilter();
            if (currentFilter != null && currentFilter.equals(this.globFilter)) {
                chooser.setFileFilter(this.actualFileFilter);
                chooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private boolean isGlobPattern(String filename) {
        return this.fileSeparatorChar == '\\' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0) || this.fileSeparatorChar == '/' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0 || filename.indexOf(91) >= 0);
    }

    private static File getLeafFile(TreePath path) {
        Object lastPathComponent;
        if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof FileNode) {
            return ((FileNode)lastPathComponent).getFile();
        }
        return null;
    }

    static /* synthetic */ File[] access$3002(FileChooserUIImpl x0, File[] x1) {
        x0.lastChildren = x1;
        return x1;
    }

    static /* synthetic */ RequestProcessor access$7200() {
        return UPDATE_RP;
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String globPattern) {
            char[] gPat = globPattern.toCharArray();
            char[] rPat = new char[gPat.length * 2];
            boolean isWin32 = FileChooserUIImpl.this.fileSeparatorChar == '\\';
            boolean inBrackets = false;
            int j = 0;
            this.globPattern = globPattern;
            if (isWin32) {
                int len = gPat.length;
                if (globPattern.endsWith("*.*")) {
                    len -= 2;
                }
                block16: for (int i = 0; i < len; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            rPat[j++] = 46;
                            rPat[j++] = 42;
                            continue block16;
                        }
                        case '?': {
                            rPat[j++] = 46;
                            continue block16;
                        }
                        case '\\': {
                            rPat[j++] = 92;
                            rPat[j++] = 92;
                            continue block16;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(gPat[i]) >= 0) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < gPat.length; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            if (!inBrackets) {
                                rPat[j++] = 46;
                            }
                            rPat[j++] = 42;
                            continue block17;
                        }
                        case '?': {
                            rPat[j++] = inBrackets ? 63 : 46;
                            continue block17;
                        }
                        case '[': {
                            inBrackets = true;
                            rPat[j++] = gPat[i];
                            if (i >= gPat.length - 1) continue block17;
                            switch (gPat[i + 1]) {
                                case '!': 
                                case '^': {
                                    rPat[j++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    rPat[j++] = gPat[++i];
                                }
                            }
                            continue block17;
                        }
                        case ']': {
                            rPat[j++] = gPat[i];
                            inBrackets = false;
                            continue block17;
                        }
                        case '\\': {
                            if (i == 0 && gPat.length > 1 && gPat[1] == '~') {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            if (i < gPat.length - 1 && "*?[]".indexOf(gPat[i + 1]) >= 0) {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            continue block17;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(gPat[i])) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(rPat, 0, j), 2);
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(f.getName()).matches();
        }

        @Override
        public String getDescription() {
            return this.globPattern;
        }
    }

    private class ApproveSelectionFinisher
    implements Runnable {
        private final String filename;
        private final List<File> selectedFiles;
        private final ActionEvent e;
        private final AtomicBoolean cancelled;
        private volatile boolean isSlectedFileExists;
        private volatile boolean isSlectedFileDir;

        public ApproveSelectionFinisher(ActionEvent e, String filename, List<File> selectedFiles, AtomicBoolean cancelled) {
            this.e = e;
            this.selectedFiles = selectedFiles;
            this.filename = filename;
            this.cancelled = cancelled;
        }

        private void init() {
            if (this.selectedFiles.size() == 1) {
                File selectedFile = this.selectedFiles.get(0);
                this.isSlectedFileExists = selectedFile.exists();
                this.isSlectedFileDir = selectedFile.isDirectory();
            }
        }

        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            FileChooserUIImpl.this.enableAllButCancel(true);
            JFileChooser chooser = FileChooserUIImpl.this.getFileChooser();
            FileChooserUIImpl.this.resetGlobFilter();
            if (this.selectedFiles.size() == 1) {
                boolean isCtrl;
                File selectedFile = this.selectedFiles.get(0);
                FileFilter currentFilter = chooser.getFileFilter();
                if (!this.isSlectedFileExists && FileChooserUIImpl.this.isGlobPattern(this.filename)) {
                    FileChooserUIImpl.this.changeDirectory(selectedFile.getParentFile());
                    if (FileChooserUIImpl.this.globFilter == null) {
                        FileChooserUIImpl.this.globFilter = new GlobFilter();
                    }
                    try {
                        FileChooserUIImpl.this.globFilter.setPattern(selectedFile.getName());
                        if (!(currentFilter instanceof GlobFilter)) {
                            FileChooserUIImpl.this.actualFileFilter = currentFilter;
                        }
                        chooser.setFileFilter(null);
                        chooser.setFileFilter(FileChooserUIImpl.this.globFilter);
                        return;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
                boolean isDir = this.isSlectedFileDir;
                boolean isTrav = chooser.isTraversable(selectedFile);
                boolean isDirSelEnabled = chooser.isDirectorySelectionEnabled();
                boolean isFileSelEnabled = chooser.isFileSelectionEnabled();
                boolean bl = isCtrl = this.e != null && (this.e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                if (isDir && isTrav && (isCtrl || !isDirSelEnabled)) {
                    FileChooserUIImpl.this.changeDirectory(selectedFile);
                    return;
                }
                if (!(!isDir && isFileSelEnabled || isDir && isDirSelEnabled || isDirSelEnabled && !this.isSlectedFileExists)) {
                    this.selectedFiles.clear();
                }
            }
            if (!this.selectedFiles.isEmpty()) {
                if (chooser.isMultiSelectionEnabled()) {
                    File[] selectedFilesArray = this.selectedFiles.toArray(new File[this.selectedFiles.size()]);
                    chooser.setSelectedFiles(selectedFilesArray);
                    chooser.setSelectedFiles(selectedFilesArray);
                } else {
                    chooser.setSelectedFile(this.selectedFiles.get(0));
                }
                chooser.approveSelection();
            } else {
                if (chooser.isMultiSelectionEnabled()) {
                    chooser.setSelectedFiles(null);
                } else {
                    chooser.setSelectedFile(null);
                }
                chooser.cancelSelection();
            }
        }
    }

    private static class ApproveSelectionThreadWorker
    implements Runnable {
        private final ActionEvent e;
        private final String filename;
        private final boolean multySelection;
        private final File currentDir;
        private final FileSystemView fs;
        private final List<File> selectedFiles;
        private final ApproveSelectionFinisher finisher;
        private final AtomicBoolean cancelled;

        public ApproveSelectionThreadWorker(ActionEvent e, String filename, boolean multySelection, File currentDir, FileSystemView fs, List<File> selectedFiles, ApproveSelectionFinisher finisher, AtomicBoolean cancelled) {
            this.e = e;
            this.filename = filename;
            this.multySelection = multySelection;
            this.currentDir = currentDir;
            this.fs = fs;
            this.selectedFiles = selectedFiles;
            this.finisher = finisher;
            this.cancelled = cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.multySelection && this.filename.length() > 1 && this.filename.charAt(0) == '\"' && this.filename.charAt(this.filename.length() - 1) == '\"') {
                    Object[] files = this.filename.substring(1, this.filename.length() - 1).split("\" \"");
                    Arrays.sort(files);
                    Object[] children = null;
                    int childIndex = 0;
                    for (Object str : files) {
                        if (this.cancelled.get()) {
                            return;
                        }
                        Object file = this.fs.createFileObject((String)str);
                        if (!((File)file).isAbsolute()) {
                            if (children == null) {
                                children = this.fs.getFiles(this.currentDir, false);
                                Arrays.sort(children);
                            }
                            for (int k = 0; k < children.length; ++k) {
                                int l = (childIndex + k) % children.length;
                                if (!((File)children[l]).getName().equals(str)) continue;
                                file = children[l];
                                childIndex = l + 1;
                                break;
                            }
                        }
                        this.selectedFiles.add((File)file);
                    }
                } else {
                    File selectedFile = this.fs.createFileObject(this.filename);
                    if (!selectedFile.isAbsolute()) {
                        selectedFile = this.fs.getChild(this.currentDir, this.filename);
                    }
                    this.selectedFiles.add(selectedFile);
                }
                this.finisher.init();
            }
            finally {
                SwingUtilities.invokeLater(this.finisher);
            }
        }
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir;
            if (FileChooserUIImpl.this.isDirectorySelected() && (dir = FileChooserUIImpl.this.getDirectory()) != null) {
                try {
                    dir = ShellFolder.getNormalizedFile(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileChooserUIImpl.this.changeDirectory(dir);
                return;
            }
            String filename = FileChooserUIImpl.this.getFileName();
            if (filename != null) {
                int i;
                for (i = filename.length() - 1; i >= 0 && filename.charAt(i) <= ' '; --i) {
                }
                filename = filename.substring(0, i + 1);
            }
            if (filename == null || filename.length() == 0) {
                FileChooserUIImpl.this.resetGlobFilter();
                return;
            }
            if (FileChooserUIImpl.this.fileChooser.isUnix()) {
                if (filename.startsWith("~/")) {
                    filename = FileChooserUIImpl.this.fileChooser.getHomePath() + filename.substring(1);
                } else if (filename.equals("~")) {
                    filename = FileChooserUIImpl.this.fileChooser.getHomePath();
                }
            }
            ArrayList<File> selectedFiles = new ArrayList<File>();
            FileChooserUIImpl.this.enableAllButCancel(false);
            ApproveSelectionFinisher finisher = new ApproveSelectionFinisher(e, filename, selectedFiles, FileChooserUIImpl.this.cancelled);
            ApproveSelectionThreadWorker worker = new ApproveSelectionThreadWorker(e, filename, FileChooserUIImpl.this.fileChooser.isMultiSelectionEnabled(), FileChooserUIImpl.this.fileChooser.getCurrentDirectory(), FileChooserUIImpl.this.fileChooser.getFileSystemView(), selectedFiles, finisher, FileChooserUIImpl.this.cancelled);
            APPROVE_RP.post((Runnable)worker);
        }
    }

    private class ChangeToParentDirectoryAction
    extends AbstractAction {
        private volatile File parentFile;

        protected ChangeToParentDirectoryAction() {
            super("Go Up");
            this.putValue("ActionCommandKey", "Go Up");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            FileChooserUIImpl.this.setCursor(FileChooserUIImpl.this.fileChooser, 3);
            FileChooserUIImpl.this.enableAllButCancel(false);
            FileChooserUIImpl.this.getApproveSelectionAction();
            final File curr1 = FileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
            COMMON_RP.post(new Runnable(){

                @Override
                public void run() {
                    if (!EventQueue.isDispatchThread()) {
                        File curr2 = FileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
                        if (curr2 != null && curr2.equals(curr1)) {
                            ChangeToParentDirectoryAction.this.parentFile = FileChooserUIImpl.this.getFileChooser().getFileSystemView().getParentDirectory(curr2);
                        } else {
                            ChangeToParentDirectoryAction.this.parentFile = null;
                        }
                        SwingUtilities.invokeLater(this);
                    } else {
                        if (ChangeToParentDirectoryAction.this.parentFile != null) {
                            FileChooserUIImpl.this.getFileChooser().setCurrentDirectory(ChangeToParentDirectoryAction.this.parentFile);
                        }
                        FileChooserUIImpl.this.enableAllButCancel(true);
                        ChangeToParentDirectoryAction.this.setEnabled(true);
                        FileChooserUIImpl.this.setCursor(FileChooserUIImpl.this.fileChooser, 0);
                    }
                }
            });
        }
    }

    private class CancelSelectionAction
    extends AbstractAction {
        private CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUIImpl.this.cancelled.set(true);
            FileChooserUIImpl.this.getFileChooser().cancelSelection();
        }
    }

    private class UpdateWorker
    implements Runnable {
        private FileChooserUIImpl ui;
        private ValidationParams validationParams;
        private final ScheduledExecutorService executor;
        private ScheduledFuture<?> updateTask;
        private long lastEventID = 0L;
        private final Object updateTaskLock = new Object();
        static final int VALIDATION_DELAY = 300;
        private ValidationWorkerCheckState lastCheck = null;

        UpdateWorker() {
            this.executor = Executors.newScheduledThreadPool(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleValidationParamasChanges() {
            if (this.validationParams != null) {
                this.validationParams.setRequestID(++this.lastEventID);
            }
            ValidationResult validationResult = new ValidationResult(Boolean.FALSE, null, false, null);
            FileChooserUIImpl.this.currentState = new ValidationWorkerCheckState(Boolean.TRUE, validationResult);
            this.ui.updateTree();
            Object object = this.updateTaskLock;
            synchronized (object) {
                block7: {
                    if (this.updateTask != null) {
                        this.updateTask.cancel(true);
                    }
                    try {
                        this.updateTask = this.executor.schedule(this, 300L, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException ex) {
                        if (!RemoteLogger.getInstance().isLoggable(Level.FINEST)) break block7;
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        public void updateTree(File file) {
            this.validationParams = new ValidationParams(file);
            this.handleValidationParamasChanges();
        }

        public void attachFileChooser(FileChooserUIImpl ui) {
            this.ui = ui;
        }

        public ValidationResult validate() {
            if (this.validationParams.eventID < this.lastEventID || !FileChooserUIImpl.this.fileChooser.isDisplayable()) {
                return new ValidationResult(Boolean.FALSE, null, false, FileChooserUIImpl.this.curDir);
            }
            File oldValue = FileChooserUIImpl.this.curDir;
            File file = this.validationParams.file;
            File prev = null;
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false, FileChooserUIImpl.this.curDir);
            }
            while (!FileChooserUIImpl.this.fileChooser.isTraversable(file) && prev != file) {
                prev = file;
                file = FileChooserUIImpl.this.fileChooser.getFileSystemView().getParentDirectory(file);
            }
            if (Thread.interrupted()) {
                return new ValidationResult(Boolean.FALSE, null, false, FileChooserUIImpl.this.curDir);
            }
            if (file == null) {
                Callable<String> currentDirectoryPath = FileChooserUIImpl.this.fileChooser.getAndClearDefaultDirectory();
                if (currentDirectoryPath != null) {
                    try {
                        String currentDir = currentDirectoryPath.call();
                        file = currentDir == null || currentDir.isEmpty() ? FileChooserUIImpl.this.fileChooser.getFileSystemView().getDefaultDirectory() : FileChooserUIImpl.this.fileChooser.getFileSystemView().createFileObject(currentDir);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                        return new ValidationResult(Boolean.FALSE, null, false, FileChooserUIImpl.this.curDir);
                    }
                } else {
                    File file2 = file = oldValue == null ? FileChooserUIImpl.this.fileChooser.getFileSystemView().getDefaultDirectory() : oldValue;
                }
                if (file != null && file.isFile()) {
                    file = file.getParentFile();
                }
            }
            if (file == null) {
                return new ValidationResult(Boolean.FALSE, null, false, null);
            }
            boolean directoryChanged = !file.equals(oldValue);
            FileNode node = new FileNode(file);
            return new ValidationResult(Boolean.TRUE, node, directoryChanged, file);
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                ValidationResult validationResult;
                ValidationWorkerCheckState curStatus = this.lastCheck;
                FileChooserUIImpl.this.currentState = curStatus;
                ValidationResult validationResult2 = validationResult = curStatus == null ? null : curStatus.validationResult;
                if (curStatus == null || curStatus.checking == null) {
                    validationResult = validationResult == null ? new ValidationResult(Boolean.FALSE, null, false, null) : new ValidationResult(Boolean.TRUE, validationResult.node, validationResult.isDirectoryChanged, validationResult.currentFile);
                    FileChooserUIImpl.this.currentState = new ValidationWorkerCheckState(null, validationResult);
                }
                if (validationResult.isDirectoryChanged) {
                    FileChooserUIImpl.this.fileChooser.setCurrentDirectory(validationResult.currentFile);
                }
                this.ui.updateTree();
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException curStatus) {
                    // empty catch block
                }
                ValidationResult result = this.validate();
                if (Thread.interrupted()) {
                    return;
                }
                this.lastCheck = new ValidationWorkerCheckState(result.isValid != false ? null : Boolean.FALSE, result);
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Object object = this.updateTaskLock;
            synchronized (object) {
                if (this.updateTask != null) {
                    this.updateTask.cancel(true);
                }
            }
        }

        private void restoreCursor() {
            this.ui.setCursor(FileChooserUIImpl.this.fileChooser, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            Object object = this.updateTaskLock;
            synchronized (object) {
                if (this.updateTask != null) {
                    this.updateTask.cancel(true);
                }
                this.executor.shutdown();
            }
        }
    }

    private static final class ValidationParams {
        private final File file;
        private long eventID;

        ValidationParams(File file) {
            this.file = file;
        }

        void setRequestID(long eventID) {
            this.eventID = eventID;
        }
    }

    private static final class ValidationWorkerCheckState {
        private final Boolean checking;
        private final ValidationResult validationResult;

        private ValidationWorkerCheckState(Boolean checking, ValidationResult validationResult) {
            this.checking = checking;
            this.validationResult = validationResult;
        }
    }

    private static class ValidationResult {
        private final Boolean isValid;
        private final TreeNode node;
        private final boolean isDirectoryChanged;
        private final File currentFile;

        ValidationResult(Boolean isValid, TreeNode rootNode, boolean isDirectoryChanged, File file) {
            this.isValid = isValid;
            this.node = rootNode;
            this.isDirectoryChanged = isDirectoryChanged;
            this.currentFile = file;
        }
    }

    private class DirectoryTreeModel
    extends DefaultTreeModel {
        public DirectoryTreeModel(TreeNode root) {
            super(root);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            File newFile;
            FileNode node;
            File f;
            boolean refreshTree = false;
            Object lastPathComponent = path.getLastPathComponent();
            if (lastPathComponent instanceof FileNode && (f = (node = (FileNode)lastPathComponent).getFile()).renameTo(newFile = FileChooserUIImpl.this.getFileChooser().getFileSystemView().createFileObject(f.getParentFile(), (String)newValue))) {
                if (FileChooserUIImpl.this.tree.isExpanded(path)) {
                    FileChooserUIImpl.this.tree.collapsePath(path);
                    refreshTree = true;
                }
                node.setFile(newFile);
                node.removeAllChildren();
                ((DefaultTreeModel)FileChooserUIImpl.this.tree.getModel()).nodeStructureChanged(node);
                if (refreshTree) {
                    FileChooserUIImpl.this.tree.expandPath(path);
                }
            }
        }
    }

    private static class LoadingNode
    extends DefaultMutableTreeNode {
        LoadingNode() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(NbBundle.getMessage(FileChooserUIImpl.class, (String)"LOADING"), false);
            this.add(defaultMutableTreeNode);
        }

        Icon getIcon() {
            return UIManager.getIcon("FileView.directoryIcon");
        }
    }

    private class LoadingTreeModel
    extends DefaultTreeModel {
        LoadingTreeModel() {
            super(new LoadingNode());
        }
    }

    private class DirectoryTreeRenderer
    implements TreeCellRenderer {
        HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

        private DirectoryTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Component stringDisplayer = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof FileNode) {
                tree.setShowsRootHandles(true);
                node = (FileNode)value;
                ((JLabel)stringDisplayer).setIcon(this.getNodeIcon((FileNode)node));
                ((JLabel)stringDisplayer).setText(this.getNodeText((FileNode)node));
            } else if (value instanceof LoadingNode) {
                tree.setShowsRootHandles(true);
                node = (LoadingNode)value;
                ((JLabel)stringDisplayer).setIcon(((LoadingNode)node).getIcon());
                ((JLabel)stringDisplayer).setText(node.getUserObject() + "");
            }
            Font f = stringDisplayer.getFont();
            stringDisplayer.setPreferredSize(new Dimension(stringDisplayer.getPreferredSize().width, 30));
            ((JComponent)stringDisplayer).setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            stringDisplayer.setSize(stringDisplayer.getPreferredSize());
            return stringDisplayer;
        }

        private Icon getNodeIcon(FileNode node) {
            return node.getIcon(FileChooserUIImpl.this.fileChooser);
        }

        private String getNodeText(FileNode node) {
            return node.getText(FileChooserUIImpl.this.fileChooser);
        }
    }

    private class NewDirectoryAction
    extends AbstractAction {
        private final RequestProcessor.Task enableTask = FileChooserUIImpl.access$7200().create((Runnable)new ActionEnabler());
        private File file;

        private NewDirectoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = FileChooserUIImpl.this.tree.getSelectionPath();
            if (path == null) {
                Object root = FileChooserUIImpl.this.tree.getModel().getRoot();
                if (root instanceof LoadingNode) {
                    return;
                }
                if (root instanceof FileNode) {
                    FileChooserUIImpl.this.addNewDirectory(new TreePath(FileChooserUIImpl.this.model.getPathToRoot((FileNode)root)));
                }
            }
            if (path != null) {
                if (FileChooserUIImpl.this.tree.isExpanded(path)) {
                    FileChooserUIImpl.this.addNewDirectory(path);
                } else {
                    FileChooserUIImpl.this.addNewDirectory = true;
                    FileChooserUIImpl.this.tree.expandPath(path);
                }
            }
        }

        private void enable(File file) {
            this.setEnabled(false);
            this.file = file;
            this.enableTask.schedule(0);
        }

        private class ActionEnabler
        implements Runnable {
            private ActionEnabler() {
            }

            @Override
            public void run() {
                final File f = NewDirectoryAction.this.file;
                if (FileChooserUIImpl.canWrite(f)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (f == NewDirectoryAction.this.file) {
                                NewDirectoryAction.this.setEnabled(true);
                            }
                        }
                    });
                }
            }
        }
    }

    private class TreeExpansionHandler
    implements TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            Object lastPathComponent = path.getLastPathComponent();
            if (lastPathComponent instanceof FileNode) {
                FileNode node = (FileNode)lastPathComponent;
                if (!node.isLoaded()) {
                    FileChooserUIImpl.this.expandNode(FileChooserUIImpl.this.fileChooser, path);
                } else {
                    if (FileChooserUIImpl.this.addNewDirectory) {
                        FileChooserUIImpl.this.addNewDirectory(path);
                        FileChooserUIImpl.this.addNewDirectory = false;
                    }
                    FileChooserUIImpl.this.refreshNode(path, node);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private class DirectoryHandler
    extends MouseAdapter
    implements TreeSelectionListener,
    CellEditorListener,
    ActionListener,
    FocusListener,
    Runnable {
        private JFileChooser fileChooser;
        private WeakReference<TreePath> curSelPath;
        private Timer renameTimer;
        private Timer dblClickTimer;
        private TreePath pathToRename;

        public DirectoryHandler(JFileChooser fileChooser) {
            this.fileChooser = fileChooser;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            FileChooserUIImpl.this.showPopupCompletion = false;
            FileSystemView fsv = this.fileChooser.getFileSystemView();
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getSelectionPath();
            TreePath curSel = e.getNewLeadSelectionPath();
            WeakReference<TreePath> weakReference = this.curSelPath = curSel != null ? new WeakReference<TreePath>(curSel) : null;
            if (path != null) {
                if (!(path.getLastPathComponent() instanceof FileNode)) {
                    return;
                }
                FileNode node = (FileNode)path.getLastPathComponent();
                File file = node.getFile();
                if (file != null) {
                    FileChooserUIImpl.this.setSelected(this.getSelectedNodes(tree.getSelectionPaths()));
                    FileChooserUIImpl.this.newFolderAction.setEnabled(false);
                    if (!node.isLeaf()) {
                        FileChooserUIImpl.this.newFolderAction.enable(file);
                        FileChooserUIImpl.this.setDirectorySelected(true);
                    }
                }
            }
        }

        private File[] getSelectedNodes(TreePath[] paths) {
            LinkedList<File> files = new LinkedList<File>();
            for (int i = 0; i < paths.length; ++i) {
                File file = FileChooserUIImpl.getLeafFile(paths[i]);
                if (file == null || file.isDirectory() && this.fileChooser.isTraversable(file) && !this.fileChooser.getFileSystemView().isFileSystem(file)) continue;
                files.add(file);
            }
            return files.toArray(new File[files.size()]);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            JTree tree = (JTree)e.getSource();
            Point p = e.getPoint();
            int x = e.getX();
            int row = tree.getRowForLocation(x, y = e.getY());
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof FileNode)) {
                    return;
                }
                FileNode node = (FileNode)lastPathComponent;
                FileChooserUIImpl.this.newFolderAction.enable(node.getFile());
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    this.handleDblClick(node);
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && this.pathToRename != null) {
                    if (this.dblClickTimer != null) {
                        this.handleDblClick(node);
                        return;
                    }
                    this.renameTimer = new Timer(800, this);
                    this.renameTimer.setRepeats(false);
                    this.renameTimer.start();
                    this.startDblClickTimer();
                }
                this.startDblClickTimer();
                ((DirectoryTreeModel)tree.getModel()).nodeChanged(node);
                if (row == 0) {
                    tree.revalidate();
                    tree.repaint();
                }
            }
        }

        private void handleDblClick(FileNode node) {
            this.cancelRename();
            this.cancelDblClick();
            if (node.getFile().isFile() && !node.getFile().getPath().endsWith(".lnk")) {
                this.fileChooser.approveSelection();
            } else {
                this.changeTreeDirectory(node.getFile());
            }
        }

        private void startDblClickTimer() {
            this.cancelDblClick();
            this.dblClickTimer = new Timer(500, this);
            this.dblClickTimer.setRepeats(false);
            this.dblClickTimer.start();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopupMenu(e);
        }

        private void handlePopupMenu(MouseEvent e) {
            int y;
            if (!e.isPopupTrigger()) {
                return;
            }
            JTree tree = (JTree)e.getSource();
            Point p = e.getPoint();
            int x = e.getX();
            int row = tree.getRowForLocation(x, y = e.getY());
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof FileNode) {
                    FileNode node = (FileNode)lastPathComponent;
                    ((DirectoryTreeModel)tree.getModel()).nodeChanged(node);
                    if (!this.fileChooser.getFileSystemView().isFileSystem(node.getFile())) {
                        return;
                    }
                }
                tree.setSelectionPath(path);
                FileChooserUIImpl.this.popupMenu.show(tree, x, y);
            }
        }

        private void changeTreeDirectory(File dir) {
            if (FileChooserUIImpl.this.fileSeparatorChar == '\\' && dir.getPath().endsWith(".lnk")) {
                File linkLocation = FileChooserUIImpl.this.getShellFolderForFileLinkLoc(dir);
                if (linkLocation != null && this.fileChooser.isTraversable(linkLocation)) {
                    dir = linkLocation;
                } else {
                    return;
                }
            }
            this.fileChooser.setCurrentDirectory(dir);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            FileNode node = (FileNode)FileChooserUIImpl.this.tree.getLastSelectedPathComponent();
            if (node != null) {
                FileChooserUIImpl.this.setFileName(FileChooserUIImpl.this.getStringOfFileName(node.getFile(), true));
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileNode node;
            Object lastSelectedPathComponent;
            if (FileChooserUIImpl.this.tree.isFocusOwner() && this.isSelectionKept(this.pathToRename) && e.getSource() == this.renameTimer && (lastSelectedPathComponent = FileChooserUIImpl.this.tree.getLastSelectedPathComponent()) instanceof FileNode && (node = (FileNode)lastSelectedPathComponent) != null) {
                FileChooserUIImpl.this.applyEdit(node);
            }
            if (e.getSource() != this.dblClickTimer) {
                this.cancelRename();
            }
            this.cancelDblClick();
        }

        void preprocessMouseEvent(MouseEvent e) {
            if (e.getID() != 501 || e.getButton() != 1) {
                return;
            }
            TreePath clickedPath = FileChooserUIImpl.this.tree.getPathForLocation(e.getX(), e.getY());
            if (clickedPath != null && this.isSelectionKept(clickedPath)) {
                this.pathToRename = clickedPath;
            }
        }

        private boolean isSelectionKept(TreePath selPath) {
            TreePath oldSel;
            return this.curSelPath != null && (oldSel = (TreePath)this.curSelPath.get()) != null && oldSel.equals(selPath);
        }

        private void cancelRename() {
            if (this.renameTimer != null) {
                this.renameTimer.stop();
                this.renameTimer = null;
            }
            this.pathToRename = null;
        }

        private void cancelDblClick() {
            Timer t = this.dblClickTimer;
            if (t != null) {
                t.stop();
                this.dblClickTimer = null;
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.cancelRename();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.cancelRename();
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            FileChooserUIImpl.this.showPopupCompletion = true;
            int keyCode = evt.getKeyCode();
            if (FileChooserUIImpl.this.completionPopup != null && !FileChooserUIImpl.this.completionPopup.isVisible()) {
                if (keyCode == 10) {
                    FileChooserUIImpl.this.getApproveSelectionAction().actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), ""));
                    evt.consume();
                }
                if (keyCode == 9 || keyCode == 40 || keyCode == 39 && FileChooserUIImpl.this.filenameTextField.getCaretPosition() >= FileChooserUIImpl.this.filenameTextField.getDocument().getLength() - 1) {
                    FileChooserUIImpl.this.updateCompletions();
                }
            }
            if (FileChooserUIImpl.this.filenameTextField.isFocusOwner() && (FileChooserUIImpl.this.completionPopup == null || !FileChooserUIImpl.this.completionPopup.isVisible()) && keyCode == 27) {
                FileChooserUIImpl.this.fileChooser.cancelSelection();
            }
        }
    }

    private class DirectoryChooserFileView
    extends BasicFileChooserUI.BasicFileView
    implements Runnable {
        private final ScheduledExecutorService executor;
        private ScheduledFuture<?> iconTask;
        private final Object iconTaskLock;
        static final int LOADING_DELAY = 30;
        private File lookingForIcon;

        private DirectoryChooserFileView() {
            super(FileChooserUIImpl.this);
            this.iconTaskLock = new Object();
            this.executor = Executors.newScheduledThreadPool(1);
        }

        private void loadIcon() {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Thread.interrupted()) {
                this.lookingForIcon = null;
                return;
            }
            Icon icon = FileChooserUIImpl.this.fileChooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            this.cacheIcon(this.lookingForIcon, icon);
            this.lookingForIcon = null;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                FileChooserUIImpl.this.fileChooser.repaint();
            } else {
                this.loadIcon();
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            Object object = this.iconTaskLock;
            synchronized (object) {
                block8: {
                    if (this.iconTask != null) {
                        this.iconTask.cancel(true);
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                    }
                    try {
                        this.iconTask = this.executor.schedule(this, 30L, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException ex) {
                        if (!RemoteLogger.getInstance().isLoggable(Level.FINEST)) break block8;
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return icon;
        }
    }

    private class DirectoryComboBoxAction
    implements ActionListener {
        private DirectoryComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)FileChooserUIImpl.this.directoryComboBox.getSelectedItem();
            FileChooserUIImpl.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class FilterTypeComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterTypeComboBoxModel() {
            this.filters = FileChooserUIImpl.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                FileChooserUIImpl.this.getFileChooser().setFileFilter((FileFilter)filter);
                FileChooserUIImpl.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = FileChooserUIImpl.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    FileChooserUIImpl.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return FileChooserUIImpl.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return FileChooserUIImpl.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    private static class FilterComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public FilterComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = FileChooserUIImpl.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = FileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File f;
            File sf;
            if (!SwingUtilities.isEventDispatchThread()) {
                DLightLibsCommonLogger.printStackTraceOnce((Throwable)((Object)new AssertionError((Object)"fireDirectoryChanged should be called from EDT only!")), (Level)Level.SEVERE, (boolean)true);
            }
            if (directory == null) {
                return;
            }
            this.directories.clear();
            if (FileChooserUIImpl.this.useShellFolder) {
                this.directories.addAll(Arrays.asList(FileChooserUIImpl.this.getShellFolderRoots()));
            } else {
                this.directories.addAll(Arrays.asList(FileChooserUIImpl.this.fileChooser.getFileSystemView().getRoots()));
            }
            File canonical = directory;
            File file = sf = FileChooserUIImpl.this.useShellFolder ? FileChooserUIImpl.this.getShellFolderForFile(canonical) : canonical;
            if (sf == null) {
                sf = canonical;
            }
            Vector<File> path = new Vector<File>(10);
            for (f = sf; f != null; f = f.getParentFile()) {
                path.addElement(f);
            }
            int pathCount = path.size();
            for (int i = 0; i < pathCount; ++i) {
                f = (File)path.get(i);
                if (!this.directories.contains(f)) continue;
                int topIndex = this.directories.indexOf(f);
                for (int j = i - 1; j >= 0; --j) {
                    this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                }
                break;
            }
            this.calculateDepths();
            this.setSelectedItem(sf);
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    private class DirectoryComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        IconIndenter indenter = new IconIndenter();

        public DirectoryComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            this.setName("ComboBox.listRenderer");
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(FileChooserUIImpl.this.getFileChooser().getName(directory));
            this.indenter.icon = icon = FileChooserUIImpl.this.getFileChooser().getIcon(directory);
            this.indenter.depth = FileChooserUIImpl.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.indenter);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private static class IconIndenter
    implements Icon {
        static final int space = 10;
        Icon icon = null;
        int depth = 0;

        private IconIndenter() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon == null) {
                return;
            }
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon != null ? this.icon.getIconWidth() + this.depth * 10 : 0;
        }

        @Override
        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 0;
        }
    }

    private class ListFilesWorker
    implements Runnable {
        private String d;

        private ListFilesWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path;
            ListFilesWorker listFilesWorker = this;
            synchronized (listFilesWorker) {
                path = this.d;
            }
            File dir = FileChooserUIImpl.this.getFileChooser().getFileSystemView().createFileObject(path);
            LinkedList<File> files = new LinkedList<File>();
            File[] children = dir.listFiles();
            if (children != null) {
                for (File f : children) {
                    if (!FileChooserUIImpl.this.fileChooser.accept(f)) continue;
                    if (FileChooserUIImpl.this.fileChooser.getFileSelectionMode() == 1) {
                        if (!f.isDirectory()) continue;
                        files.add(f);
                        continue;
                    }
                    if (FileChooserUIImpl.this.fileChooser.getFileSelectionMode() == 0) {
                        if (!f.isFile()) continue;
                        files.add(f);
                        continue;
                    }
                    if (FileChooserUIImpl.this.fileChooser.getFileSelectionMode() != 2) continue;
                    files.add(f);
                }
            }
            ListFilesWorker listFilesWorker2 = this;
            synchronized (listFilesWorker2) {
                FileChooserUIImpl.this.lastDir = path;
                FileChooserUIImpl.access$3002(FileChooserUIImpl.this, files.toArray(new File[files.size()]));
            }
            if (FileChooserUIImpl.this.lastChildren.length > 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileChooserUIImpl.this.updateCompletions();
                    }
                });
            }
        }
    }

    class TreeKeyHandler
    extends KeyAdapter
    implements FocusListener {
        StringBuffer searchBuf = new StringBuffer();
        List<TreePath> paths;
        private final Timer resetBufferTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeKeyHandler.this.resetBuffer();
            }
        });

        TreeKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            JTree tree;
            int selRow;
            Object lastSelectedPathComponent;
            if (evt.getKeyCode() == 127) {
                FileChooserUIImpl.this.deleteAction();
            }
            if (evt.getKeyCode() == 113 && (lastSelectedPathComponent = FileChooserUIImpl.this.tree.getLastSelectedPathComponent()) instanceof FileNode) {
                FileNode node = (FileNode)lastSelectedPathComponent;
                FileChooserUIImpl.this.applyEdit(node);
            }
            if (this.isCharForSearch(evt)) {
                evt.consume();
            } else {
                this.resetBuffer();
            }
            if (evt.getKeyCode() == 121 && evt.isShiftDown() && !FileChooserUIImpl.this.popupMenu.isShowing() && (selRow = (tree = (JTree)evt.getSource()).getLeadSelectionRow()) >= 0) {
                Rectangle bounds = tree.getRowBounds(selRow);
                FileChooserUIImpl.this.popupMenu.show(tree, bounds.x + bounds.width / 2, bounds.y + bounds.height * 3 / 5);
                evt.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char keyChar = evt.getKeyChar();
            if (this.isCharForSearch(evt)) {
                if (this.paths == null) {
                    this.paths = FileChooserUIImpl.this.getVisiblePaths();
                }
                this.searchBuf.append(keyChar);
                this.resetBufferTimer.restart();
                TreePath activePath = FileChooserUIImpl.this.tree.getSelectionPath();
                for (int i = 0; i < 2; ++i) {
                    String searchedText = this.searchBuf.toString().toLowerCase();
                    String curFileName = null;
                    if (i == 0 && activePath != null && (curFileName = FileChooserUIImpl.this.fileChooser.getName(FileChooserUIImpl.getLeafFile(activePath))) != null && curFileName.toLowerCase().startsWith(searchedText)) {
                        return;
                    }
                    for (TreePath path : this.paths) {
                        File file = FileChooserUIImpl.getLeafFile(path);
                        if (file == null || (curFileName = FileChooserUIImpl.this.fileChooser.getName(file)) == null || !curFileName.toLowerCase().startsWith(searchedText)) continue;
                        FileChooserUIImpl.this.tree.makeVisible(path);
                        FileChooserUIImpl.this.tree.scrollPathToVisible(path);
                        FileChooserUIImpl.this.tree.setSelectionPath(path);
                        return;
                    }
                    this.searchBuf.delete(0, this.searchBuf.length() - 1);
                }
            } else {
                this.resetBuffer();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.resetBuffer();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.resetBuffer();
        }

        private boolean isCharForSearch(KeyEvent evt) {
            char ch = evt.getKeyChar();
            if (ch == '\b') {
                return false;
            }
            if (evt.getModifiers() != 0) {
                return false;
            }
            return Character.isJavaIdentifierPart(ch) && !Character.isIdentifierIgnorable(ch) || Character.isSpaceChar(ch);
        }

        private void resetBuffer() {
            this.searchBuf.delete(0, this.searchBuf.length());
            this.paths = null;
        }
    }

    private class AltUpHandler
    extends KeyAdapter {
        private final JComponent component;

        public AltUpHandler(JComponent component) {
            this.component = component;
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 38 && (evt.getModifiers() & 8) == 8) {
                Action action = FileChooserUIImpl.this.getChangeToParentDirectoryAction();
                action.actionPerformed(new ActionEvent(evt.getSource(), 0, ""));
                this.component.requestFocus();
            }
        }
    }
}

