/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.api;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class SVNNotificationHandler {
    private Set<ISVNNotifyListener> notifylisteners = new HashSet<ISVNNotifyListener>();
    private boolean logEnabled = true;
    private VCSFileProxy baseDir;

    public void notifyListenersOfChange(VCSFileProxy path) {
        if (this.logEnabled) {
            for (ISVNNotifyListener l : this.notifylisteners) {
                l.onNotify(path, SVNNodeKind.NONE);
            }
        }
    }

    public void logCommandLine(String commandLine) {
        if (this.logEnabled) {
            for (ISVNNotifyListener l : this.notifylisteners) {
                l.logCommandLine(commandLine);
            }
        }
    }

    public void logMessage(String message) {
        if (this.logEnabled) {
            for (ISVNNotifyListener l : this.notifylisteners) {
                l.logMessage(message);
            }
        }
    }

    public void logError(String message) {
        if (this.logEnabled) {
            for (ISVNNotifyListener l : this.notifylisteners) {
                l.logError(message);
            }
        }
    }

    public void logCompleted(String string) {
        if (this.logEnabled) {
            for (ISVNNotifyListener l : this.notifylisteners) {
                l.logCompleted(string);
            }
        }
    }

    public void add(ISVNNotifyListener l) {
        this.notifylisteners.add(l);
    }

    public void remove(ISVNNotifyListener l) {
        this.notifylisteners.remove(l);
    }

    public void enableLog() {
        this.logEnabled = true;
    }

    public void disableLog() {
        this.logEnabled = false;
    }

    public void setBaseDir(VCSFileProxy baseDir) {
        this.baseDir = baseDir;
    }
}

