/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.remote.config.SvnConfigFiles;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class SvnClientFactory {
    private static final Map<FileSystem, SvnClientFactory> instances = new HashMap<FileSystem, SvnClientFactory>();
    private ClientAdapterFactory factory;
    private SVNClientException exception;
    private final FileSystem fileSystem;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.subversion.remote.client.SvnClientFactory");
    public static final String FACTORY_TYPE_COMMANDLINE = "commandline";
    public static final String DEFAULT_FACTORY = "commandline";
    private boolean cli16Version;

    private SvnClientFactory(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static synchronized SvnClientFactory getInstance(Context context) {
        return SvnClientFactory.getFactory(context);
    }

    private static synchronized SvnClientFactory getFactory(Context context) {
        FileSystem fs = context.getFileSystem();
        if (fs != null) {
            SvnClientFactory fac = instances.get(fs);
            if (fac == null) {
                fac = new SvnClientFactory(fs);
                fac.setup();
                instances.put(fs, fac);
            }
            return fac;
        }
        return null;
    }

    public static synchronized void resetClient() {
        for (Map.Entry<FileSystem, SvnClientFactory> entry : instances.entrySet()) {
            SvnConfigFiles.getInstance(entry.getKey()).reset();
        }
        instances.clear();
    }

    public static boolean isCLI() {
        return true;
    }

    public boolean isCLIOldFormat() {
        return this.cli16Version;
    }

    public SvnClient createSvnClient(Context context) throws SVNClientException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.factory.createSvnClient();
    }

    public SvnClient createSvnClient(Context context, SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) throws SVNClientException {
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            return this.factory.createSvnClient(context, repositoryUrl, support, username, password, handledExceptions);
        }
        catch (Error err) {
            throw new SVNClientException(err);
        }
    }

    private void setup() {
        try {
            this.exception = null;
            if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)this.fileSystem)) {
                throw new SVNClientException("Remote host " + this.fileSystem + " is not connected.");
            }
            SvnConfigFiles.getInstance(this.fileSystem);
            String factoryType = this.getDefaultFactoryType();
            if (!factoryType.trim().equals("commandline")) {
                throw new SVNClientException("Unknown factory: " + factoryType);
            }
            this.setupCommandline();
        }
        catch (SVNClientException e) {
            this.exception = e;
        }
        catch (Throwable ex) {
            this.exception = new SVNClientException(ex);
        }
    }

    public static void checkClientAvailable(Context root) throws SVNClientException {
        SvnClientFactory res = SvnClientFactory.getFactory(root);
        if (res != null && res.exception != null) {
            throw res.exception;
        }
    }

    public static boolean isClientAvailable(Context root) {
        SvnClientFactory res = SvnClientFactory.getFactory(root);
        return res != null && res.exception == null;
    }

    public static boolean isInitialized(Context context) {
        FileSystem fs = context.getFileSystem();
        if (fs != null) {
            return instances.get(fs) != null;
        }
        return false;
    }

    private void setupCommandline() {
        if (!this.checkCLIExecutable()) {
            return;
        }
        this.factory = new ClientAdapterFactory(this.fileSystem);
        LOG.info("running on commandline");
    }

    private boolean checkCLIExecutable() {
        this.exception = null;
        SVNClientException ex = null;
        try {
            this.checkVersion();
        }
        catch (SVNClientException e) {
            ex = e;
        }
        if (ex == null) {
            LOG.fine("svn client returns correct version");
            return true;
        }
        String execPath = SvnModuleConfig.getDefault(this.fileSystem).getExecutableBinaryPath();
        if (execPath != null && !execPath.trim().equals("")) {
            this.exception = ex;
            LOG.log(Level.WARNING, "executable binary path set to {0} yet client not available.", new Object[]{execPath});
            return false;
        }
        LOG.fine("svn client isn't set on path yet. Will check known locations...");
        String[] locations = new String[]{"/usr/local/bin/", "/usr/bin/"};
        String name = "svn";
        for (String loc : locations) {
            File file = new File(loc, name);
            LOG.log(Level.FINE, "checking existence of {0}", new Object[]{file.getAbsolutePath()});
            if (!file.exists()) continue;
            SvnModuleConfig.getDefault(this.fileSystem).setExecutableBinaryPath(loc);
            try {
                this.checkVersion();
            }
            catch (SVNClientException e) {
                ex = e;
                continue;
            }
            LOG.log(Level.INFO, "found svn executable binary. Setting executable binary path to {0}", new Object[]{loc});
            return true;
        }
        this.exception = ex;
        return false;
    }

    private void checkVersion() throws SVNClientException {
        CommandlineClient cc = new CommandlineClient(this.fileSystem);
        try {
            this.setConfigDir(cc);
            this.cli16Version = cc.checkSupportedVersion();
        }
        catch (SVNClientException e) {
            LOG.log(Level.FINE, "checking version", e);
            throw e;
        }
    }

    private void setConfigDir(SvnClient client) {
        if (client != null) {
            try {
                VCSFileProxy nbConfigPath = SvnConfigFiles.getNBConfigPath(this.fileSystem);
                if (nbConfigPath != null) {
                    VCSFileProxy configDir = nbConfigPath.normalizeFile();
                    client.setConfigDirectory(configDir);
                }
            }
            catch (IOException | SVNClientException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
    }

    private String getDefaultFactoryType() {
        SvnModuleConfig config = SvnModuleConfig.getDefault(this.fileSystem);
        String factoryType = config.getGlobalSvnFactory();
        config.setForceCommnandlineClient(false);
        if (factoryType == null || factoryType.trim().isEmpty()) {
            factoryType = config.getPreferredFactoryType("commandline");
        }
        return factoryType;
    }

    private final class ClientAdapterFactory {
        private final FileSystem fileSystem;

        private ClientAdapterFactory(FileSystem fs) {
            this.fileSystem = fs;
        }

        protected CommandlineClient createAdapter() {
            return new CommandlineClient(this.fileSystem);
        }

        protected SvnClientInvocationHandler getInvocationHandler(CommandlineClient adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
            return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions);
        }

        SvnClient createSvnClient() {
            SvnClientInvocationHandler handler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            SvnClient client = this.createSvnClient(handler);
            SvnClientFactory.this.setConfigDir(client);
            return client;
        }

        public SvnClient createSvnClient(Context context, SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) {
            CommandlineClient adapter = this.createAdapter();
            SvnClientInvocationHandler handler = this.getInvocationHandler(adapter, this.createDescriptor(repositoryUrl), support, handledExceptions);
            this.setupAdapter(adapter, username, password);
            return this.createSvnClient(handler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl repositoryUrl) {
            return new SvnClientDescriptor(){

                @Override
                public SVNUrl getSvnUrl() {
                    return repositoryUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler handler) {
            Class<?> proxyClass = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                Constructor<?> c = proxyClass.getConstructor(InvocationHandler.class);
                return (SvnClient)c.newInstance(handler);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, null, e);
                return null;
            }
        }

        protected void setupAdapter(CommandlineClient adapter, String username, char[] password) {
            adapter.setUsername(username);
            adapter.setPassword(password == null ? "" : new String(password));
            try {
                VCSFileProxy nbConfigPath = SvnConfigFiles.getNBConfigPath(this.fileSystem);
                if (nbConfigPath != null) {
                    VCSFileProxy configDir = nbConfigPath.normalizeFile();
                    adapter.setConfigDirectory(configDir);
                }
            }
            catch (IOException | SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(new Context(VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot())), ex, false, false);
            }
        }
    }
}

