/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

class Commandline {
    private String executable;
    private ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
    private final FileSystem fileSystem;

    Commandline(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.executable = SvnModuleConfig.getDefault(fileSystem).getExecutableBinaryPath();
        if (this.executable == null || this.executable.trim().equals("")) {
            this.executable = "svn";
        } else if (!this.executable.endsWith("/svn")) {
            this.executable = this.executable + "/svn";
        }
    }

    public void interrupt() {
        try {
            this.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void destroy() throws IOException {
        this.canceled.cancel();
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.fine("cli: Process destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void exec(SvnCommand command) throws IOException {
        block23: {
            this.canceled = new ProcessUtils.Canceler();
            command.prepareCommand();
            String cmd = this.executable + " " + command.getStringCommand();
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, "cli: Executing \"{0}\"", cmd);
                Subversion.LOG.fine("cli: Creating process...");
            }
            command.commandStarted();
            try {
                ProcessBuilder processBuilder = VersioningSupport.createProcessBuilder((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
                String[] args = command.getCliArguments();
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine("cli: process created");
                }
                ProcessUtils.ExitStatus exitStatus = ProcessUtils.executeInDir((String)"/", this.getEnvVar(), (boolean)command.hasBinaryOutput(), (ProcessUtils.Canceler)this.canceled, (ProcessBuilder)processBuilder, (String)this.executable, (String[])args);
                if (command.hasBinaryOutput()) {
                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                        Subversion.LOG.fine("cli: ready for binary OUTPUT \"");
                    }
                    if (Subversion.LOG.isLoggable(Level.FINER)) {
                        Subversion.LOG.log(Level.FINER, "cli: BIN OUTPUT \"{0}\"", new String(exitStatus.bytes, "UTF-8"));
                    }
                    command.output(exitStatus.bytes);
                } else {
                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                        Subversion.LOG.fine("cli: ready for OUTPUT \"");
                    }
                    if (Subversion.LOG.isLoggable(Level.FINER)) {
                        Subversion.LOG.log(Level.FINE, "cli: OUTPUT \"{0}\"", exitStatus.output);
                    }
                    if (exitStatus.output != null && !exitStatus.output.isEmpty()) {
                        for (String line : exitStatus.output.split("\n")) {
                            command.outputText(line);
                        }
                    }
                }
                if (exitStatus.error != null && !exitStatus.error.isEmpty()) {
                    for (String line : exitStatus.error.split("\n")) {
                        if (line.isEmpty()) continue;
                        command.errorText(line);
                    }
                }
                if (this.canceled.canceled()) {
                    return;
                }
                command.commandCompleted(exitStatus.exitCode);
            }
            catch (Throwable t) {
                if (this.canceled.canceled()) {
                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                        Subversion.LOG.fine(t.getMessage());
                    }
                    break block23;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
            finally {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine("cli: process finnished");
                }
                command.commandFinished();
            }
        }
    }

    private Map<String, String> getEnvVar() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("LC_ALL", "");
        ret.put("LC_MESSAGES", "C");
        ret.put("LC_TIME", "C");
        return ret;
    }
}

