/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.JcBasicParser;
import com.sun.javacard.tools.util.JCToolsLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public abstract class SubCommand {
    public static final String SHORT_VERBOSE = "v";
    public static final String LONG_VERBOSE = "verbose";
    protected ResourceBundle resourceBundle;
    protected JCToolsLogger toolsLogger;
    protected String name;
    protected boolean verbose;
    protected CommandLine commandLine = null;
    protected Options options = new Options();
    protected String[] argumentsArray;
    protected Option[] optionsArray;

    public SubCommand(String string) {
        this.name = string;
        this.options.addOption((Option)new CommandOption(SHORT_VERBOSE, LONG_VERBOSE, false));
    }

    public void parse(String[] stringArray) throws Exception {
        JcBasicParser jcBasicParser = new JcBasicParser();
        this.commandLine = jcBasicParser.parse(this.options, stringArray);
        this.optionsArray = this.commandLine.getOptions();
        this.argumentsArray = this.commandLine.getArgs();
        for (Option option : this.optionsArray) {
            if (!option.getOpt().equals(SHORT_VERBOSE)) continue;
            this.verbose = true;
        }
    }

    public final void addOption(Option option) {
        this.options.addOption(option);
    }

    public final void addOptionGroup(OptionGroup optionGroup) {
        this.options.addOptionGroup(optionGroup);
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public final void setLogger(JCToolsLogger jCToolsLogger) {
        this.toolsLogger = jCToolsLogger;
    }

    public final String getResourceString(String string) {
        return this.resourceBundle.getString(string);
    }

    public final String getFormattedResourceString(String string, Object ... objectArray) {
        String string2 = this.resourceBundle.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public final String getName() {
        return this.name;
    }

    public final void printLines(String string) {
        try {
            String string2 = null;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    string2 = this.getResourceString(string + "." + i);
                }
                catch (Exception exception) {
                    break;
                }
                string2 = string2.trim();
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                System.out.println(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public final String[] getArgumentsArray() {
        return this.argumentsArray;
    }

    public final Option[] getOptionsArray() {
        return this.optionsArray;
    }

    public abstract void setup();

    public abstract int execute() throws Exception;
}

