/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.efbuilder;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class ExportFileBuilder {
    private JcPackage jc_package;
    private boolean debugFlag;
    private boolean remoteFlag;

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    public ExportFileBuilder(JcPackage jcPackage, ConversionProfile conversionProfile) {
        this.jc_package = jcPackage;
    }

    public EfExportFile build() {
        if (this.debugFlag) {
            System.out.println("Building an export file for " + this.jc_package.getPackageName());
        }
        byte by = 0;
        JcAppletInfo[] jcAppletInfoArray = this.jc_package.getAppletInfos();
        if (jcAppletInfoArray.length == 0) {
            by = EfExportFile.LIBRARY_PACKAGE;
        }
        EfConstantPool efConstantPool = new EfConstantPool();
        JcClass[] jcClassArray = this.jc_package.getClasses();
        Vector<EfClass> vector = new Vector<EfClass>(20);
        for (JcClass jcClass : jcClassArray) {
            if (!jcClass.isAPIElement(this.jc_package)) continue;
            EfClass efClass = this.generateExportClass(jcClass, jcClass.isShareableType(), efConstantPool);
            vector.addElement(efClass);
        }
        ClassDefinition[] classDefinitionArray = new EfClass[vector.size()];
        vector.copyInto(classDefinitionArray);
        int n = this.remoteFlag ? 2 : 1;
        EfExportFile efExportFile = new EfExportFile(2, (byte)n, by, this.jc_package, efConstantPool, (EfClass[])classDefinitionArray);
        return efExportFile;
    }

    private EfClass generateExportClass(JcClass jcClass, boolean bl, EfConstantPool efConstantPool) {
        Object[] objectArray;
        EfMethod efMethod;
        if (this.debugFlag) {
            System.out.println("\n\n\nGenerating EfClass for " + jcClass.getClassName());
            System.out.println("Class token = " + jcClass.getClassToken());
        }
        String[] stringArray = jcClass.getPublicSuperClasses();
        String[] stringArray2 = jcClass.getPublicSuperInterfaces();
        boolean bl2 = jcClass.isRemote();
        Vector<EfField> vector = new Vector<EfField>(20);
        JcField[] jcFieldArray = jcClass.getFields();
        for (JcField methodDefinitionArray2 : jcFieldArray) {
            int n = methodDefinitionArray2.getAccessFlags();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            EfField efClass = new EfField(methodDefinitionArray2, efConstantPool);
            vector.addElement(efClass);
        }
        FieldDefinition[] fieldDefinitionArray = new EfField[vector.size()];
        vector.copyInto(fieldDefinitionArray);
        Vector<EfMethod> vector2 = new Vector<EfMethod>(20);
        JcMethod[] jcMethodArray = jcClass.getMethods();
        if (jcMethodArray == null) {
            // empty if block
        }
        for (JcMethod jcMethod : jcMethodArray) {
            int n = jcMethod.getAccessFlags();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n) || !Modifier.isStatic(n) && !jcMethod.getMethodName().equals("<init>")) continue;
            efMethod = new EfMethod(jcMethod, efConstantPool);
            vector2.addElement(efMethod);
        }
        for (MethodDefinition methodDefinition : objectArray = jcClass.getPublicMethodTable().getMethods()) {
            efMethod = new EfMethod(methodDefinition, efConstantPool);
            vector2.addElement(efMethod);
        }
        Object[] objectArray2 = new EfMethod[vector2.size()];
        vector2.copyInto(objectArray2);
        EfClass efClass = new EfClass(jcClass, bl, stringArray, stringArray2, efConstantPool, (EfField[])fieldDefinitionArray, (EfMethod[])objectArray2);
        if (bl2) {
            efClass.setRemote(true);
            this.remoteFlag = true;
        }
        if (this.debugFlag) {
            if (jcClass.getEfClass() != null) {
                jcClass.getEfClass().printFields();
            }
            jcClass.printFields();
            efClass.printFields();
            if (jcClass.getEfClass() != null) {
                jcClass.getEfClass().printMethods();
            }
            jcClass.printMethods();
            efClass.printMethods();
        }
        return efClass;
    }
}

