/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.index;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.util.BytesRef;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.Ctags;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.index.Filter;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.index.IndexChangedListener;
import org.opensolaris.opengrok.search.QueryBuilder;
import org.opensolaris.opengrok.search.SearchEngine;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.web.Util;

public class IndexDatabase {
    private Project project;
    private FSDirectory indexDirectory;
    private IndexWriter writer;
    private TermsEnum uidIter;
    private IgnoredNames ignoredNames;
    private Filter includedNames;
    private AnalyzerGuru analyzerGuru;
    private File xrefDir;
    private boolean interrupted;
    private List<IndexChangedListener> listeners;
    private File dirtyFile;
    private final Object lock = new Object();
    private boolean dirty;
    private boolean running;
    private List<String> directories;
    static final Logger log = Logger.getLogger(IndexDatabase.class.getName());
    private Ctags ctags;
    private LockFactory lockfact;
    private final BytesRef emptyBR = new BytesRef((CharSequence)"");
    private static final String INDEX_DIR = "index";

    public IndexDatabase() throws IOException {
        this(null);
    }

    public IndexDatabase(Project project) throws IOException {
        this.project = project;
        this.lockfact = new SimpleFSLockFactory();
        this.initialize();
    }

    public static void updateAll(ExecutorService executor) throws IOException {
        IndexDatabase.updateAll(executor, null);
    }

    static void updateAll(ExecutorService executor, IndexChangedListener listener) throws IOException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        ArrayList<IndexDatabase> dbs = new ArrayList<IndexDatabase>();
        if (env.hasProjects()) {
            for (Project project : env.getProjects()) {
                dbs.add(new IndexDatabase(project));
            }
        } else {
            dbs.add(new IndexDatabase());
        }
        Iterator<Project> iterator = dbs.iterator();
        while (iterator.hasNext()) {
            IndexDatabase d;
            final IndexDatabase db = d = (IndexDatabase)((Object)iterator.next());
            if (listener != null) {
                db.addIndexChangedListener(listener);
            }
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        db.update();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, "Problem updating lucene index database: ", e);
                    }
                }
            });
        }
    }

    public static void update(ExecutorService executor, IndexChangedListener listener, List<String> paths) throws IOException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        ArrayList<IndexDatabase> dbs = new ArrayList<IndexDatabase>();
        for (String path : paths) {
            Project project = Project.getProject(path);
            if (project == null && env.hasProjects()) {
                log.log(Level.WARNING, "Could not find a project for \"{0}\"", path);
            } else {
                try {
                    IndexDatabase db = project == null ? new IndexDatabase() : new IndexDatabase(project);
                    int idx = dbs.indexOf(db);
                    if (idx != -1) {
                        db = (IndexDatabase)dbs.get(idx);
                    }
                    if (db.addDirectory(path)) {
                        if (idx == -1) {
                            dbs.add(db);
                        }
                    } else {
                        log.log(Level.WARNING, "Directory does not exist \"{0}\"", path);
                    }
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while updating index", e);
                }
            }
            for (final IndexDatabase db : dbs) {
                db.addIndexChangedListener(listener);
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            db.update();
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, "An error occured while updating index", e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        IndexDatabase indexDatabase = this;
        synchronized (indexDatabase) {
            RuntimeEnvironment env = RuntimeEnvironment.getInstance();
            File indexDir = new File(env.getDataRootFile(), INDEX_DIR);
            if (this.project != null) {
                indexDir = new File(indexDir, this.project.getPath());
            }
            if (!(indexDir.exists() || indexDir.mkdirs() || indexDir.exists())) {
                throw new FileNotFoundException("Failed to create root directory [" + indexDir.getAbsolutePath() + "]");
            }
            if (!env.isUsingLuceneLocking()) {
                this.lockfact = NoLockFactory.getNoLockFactory();
            }
            this.indexDirectory = FSDirectory.open((File)indexDir, (LockFactory)this.lockfact);
            this.ignoredNames = env.getIgnoredNames();
            this.includedNames = env.getIncludedNames();
            this.analyzerGuru = new AnalyzerGuru();
            if (env.isGenerateHtml()) {
                this.xrefDir = new File(env.getDataRootFile(), "xref");
            }
            this.listeners = new ArrayList<IndexChangedListener>();
            this.dirtyFile = new File(indexDir, "dirty");
            this.dirty = this.dirtyFile.exists();
            this.directories = new ArrayList<String>();
        }
    }

    public boolean addDirectory(String dir) {
        String directory = dir;
        if (directory.startsWith("\\")) {
            directory = directory.replace('\\', '/');
        } else if (directory.charAt(0) != '/') {
            directory = "/" + directory;
        }
        File file = new File(RuntimeEnvironment.getInstance().getSourceRootFile(), directory);
        if (file.exists()) {
            this.directories.add(directory);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, HistoryException {
        String filename;
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                throw new IOException("Indexer already running!");
            }
            this.running = true;
            this.interrupted = false;
        }
        String ctgs = RuntimeEnvironment.getInstance().getCtags();
        if (ctgs != null) {
            this.ctags = new Ctags();
            this.ctags.setBinary(ctgs);
        }
        if (this.ctags == null) {
            log.severe("Unable to run ctags! searching definitions will not work!");
        }
        if (this.ctags != null && (filename = RuntimeEnvironment.getInstance().getCTagsExtraOptionsFile()) != null) {
            this.ctags.setCTagsExtraOptionsFile(filename);
        }
        try {
            FileAnalyzer analyzer = AnalyzerGuru.getAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig(SearchEngine.LUCENE_VERSION, (Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            iwc.setRAMBufferSizeMB(RuntimeEnvironment.getInstance().getRamBufferSize());
            this.writer = new IndexWriter((Directory)this.indexDirectory, iwc);
            this.writer.commit();
            if (this.directories.isEmpty()) {
                if (this.project == null) {
                    this.directories.add("");
                } else {
                    this.directories.add(this.project.getPath());
                }
            }
            for (String dir : this.directories) {
                File sourceRoot = "".equals(dir) ? RuntimeEnvironment.getInstance().getSourceRootFile() : new File(RuntimeEnvironment.getInstance().getSourceRootFile(), dir);
                HistoryGuru.getInstance().ensureHistoryCacheExists(sourceRoot);
                String startuid = Util.path2uid(dir, "");
                DirectoryReader reader = DirectoryReader.open((Directory)this.indexDirectory);
                Terms terms = null;
                int numDocs = reader.numDocs();
                if (numDocs > 0) {
                    Fields uFields = MultiFields.getFields((IndexReader)reader);
                    terms = uFields.terms("u");
                }
                try {
                    if (numDocs > 0) {
                        this.uidIter = terms.iterator(this.uidIter);
                        TermsEnum.SeekStatus stat = this.uidIter.seekCeil(new BytesRef((CharSequence)startuid));
                        if (stat == TermsEnum.SeekStatus.END) {
                            this.uidIter = null;
                            log.log(Level.WARNING, "Couldn't find a start term for {0}, empty u field?", startuid);
                        }
                    }
                    int file_cnt = 0;
                    if (RuntimeEnvironment.getInstance().isPrintProgress()) {
                        log.log(Level.INFO, "Counting files in {0} ...", dir);
                        file_cnt = this.indexDown(sourceRoot, dir, true, 0, 0);
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "Need to process: {0} files for {1}", new Object[]{file_cnt, dir});
                        }
                    }
                    this.indexDown(sourceRoot, dir, false, 0, file_cnt);
                    while (this.uidIter != null && this.uidIter.term() != null && this.uidIter.term().utf8ToString().startsWith(startuid)) {
                        this.removeFile();
                        BytesRef next = this.uidIter.next();
                        if (next != null) continue;
                        this.uidIter = null;
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.prepareCommit();
                    this.writer.commit();
                    this.writer.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while closing writer", e);
                }
            }
            if (this.ctags != null) {
                try {
                    this.ctags.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while closing ctags process", e);
                }
            }
            Object e = this.lock;
            synchronized (e) {
                this.running = false;
            }
        }
        if (!this.isInterrupted() && this.isDirty()) {
            if (RuntimeEnvironment.getInstance().isOptimizeDatabase()) {
                this.optimize();
            }
            RuntimeEnvironment env = RuntimeEnvironment.getInstance();
            File timestamp = new File(env.getDataRootFile(), "timestamp");
            String purpose = "used for timestamping the index database.";
            if (timestamp.exists()) {
                if (!timestamp.setLastModified(System.currentTimeMillis())) {
                    log.log(Level.WARNING, "Failed to set last modified time on ''{0}'', {1}", new Object[]{timestamp.getAbsolutePath(), purpose});
                }
            } else if (!timestamp.createNewFile()) {
                log.log(Level.WARNING, "Failed to create file ''{0}'', {1}", new Object[]{timestamp.getAbsolutePath(), purpose});
            }
        }
    }

    static void optimizeAll(ExecutorService executor) throws IOException {
        ArrayList<IndexDatabase> dbs = new ArrayList<IndexDatabase>();
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (env.hasProjects()) {
            for (Project project : env.getProjects()) {
                dbs.add(new IndexDatabase(project));
            }
        } else {
            dbs.add(new IndexDatabase());
        }
        for (IndexDatabase d : dbs) {
            final IndexDatabase db = d;
            if (!db.isDirty()) continue;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        db.update();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, "Problem updating lucene index database: ", e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                log.warning("Optimize terminated... Someone else is updating / optimizing it!");
                return;
            }
            this.running = true;
        }
        IndexWriter wrt = null;
        try {
            log.info("Optimizing the index ... ");
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchEngine.LUCENE_VERSION);
            IndexWriterConfig conf = new IndexWriterConfig(SearchEngine.LUCENE_VERSION, (Analyzer)analyzer);
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            wrt = new IndexWriter((Directory)this.indexDirectory, conf);
            wrt.forceMerge(1);
            log.info("done");
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.dirtyFile.exists() && !this.dirtyFile.delete()) {
                    log.log(Level.FINE, "Failed to remove \"dirty-file\": {0}", this.dirtyFile.getAbsolutePath());
                }
                this.dirty = false;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "ERROR: optimizing index: {0}", e);
        }
        finally {
            if (wrt != null) {
                try {
                    wrt.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while closing writer", e);
                }
            }
            Object object3 = this.lock;
            synchronized (object3) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.dirty && !this.dirtyFile.createNewFile()) {
                    if (!this.dirtyFile.exists()) {
                        log.log(Level.FINE, "Failed to create \"dirty-file\": {0}", this.dirtyFile.getAbsolutePath());
                    }
                    this.dirty = true;
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, "When creating dirty file: ", e);
            }
        }
    }

    private void removeFile() throws IOException {
        String path = Util.uid2url(this.uidIter.term().utf8ToString());
        for (IndexChangedListener listener : this.listeners) {
            listener.fileRemove(path);
        }
        this.writer.deleteDocuments(new Term("u", this.uidIter.term()));
        this.writer.prepareCommit();
        this.writer.commit();
        File xrefFile = RuntimeEnvironment.getInstance().isCompressXref() ? new File(this.xrefDir, path + ".gz") : new File(this.xrefDir, path);
        File parent = xrefFile.getParentFile();
        if (!xrefFile.delete() && xrefFile.exists()) {
            log.log(Level.INFO, "Failed to remove obsolete xref-file: {0}", xrefFile.getAbsolutePath());
        }
        if (parent.delete()) {
            log.log(Level.FINE, "Removed empty xref dir:{0}", parent.getAbsolutePath());
        }
        this.setDirty();
        for (IndexChangedListener listener : this.listeners) {
            listener.fileRemoved(path);
        }
    }

    private void addFile(File file, String path) throws IOException {
        FileAnalyzer fa;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        Object object = null;
        try {
            fa = AnalyzerGuru.getAnalyzer(in, path);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)in).close();
                }
            }
        }
        for (IndexChangedListener listener : this.listeners) {
            listener.fileAdd(path, ((Object)((Object)fa)).getClass().getSimpleName());
        }
        fa.setCtags(this.ctags);
        fa.setProject(Project.getProject(path));
        Document doc = new Document();
        try (Writer xrefOut = this.getXrefWriter(fa, path);){
            this.analyzerGuru.populateDocument(doc, file, path, fa, xrefOut);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Skipped file ''{0}'' because the analyzer didn''t understand it.", path);
            log.log(Level.FINE, "Exception from analyzer " + ((Object)((Object)fa)).getClass().getName(), e);
            this.cleanupResources(doc);
            return;
        }
        try {
            this.writer.addDocument((Iterable)doc, (Analyzer)fa);
        }
        catch (Throwable t) {
            this.cleanupResources(doc);
            throw t;
        }
        this.setDirty();
        for (IndexChangedListener listener : this.listeners) {
            listener.fileAdded(path, ((Object)((Object)fa)).getClass().getSimpleName());
        }
    }

    private void cleanupResources(Document doc) {
        for (IndexableField f : doc) {
            IOUtils.close(f.readerValue());
            if (!(f instanceof Field)) continue;
            IOUtils.close((Closeable)((Field)f).tokenStreamValue());
        }
    }

    private boolean accept(File file) {
        if (!(this.includedNames.isEmpty() || file.isDirectory() || this.includedNames.match(file))) {
            return false;
        }
        if (this.ignoredNames.ignore(file)) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (!file.canRead()) {
            log.log(Level.WARNING, "Warning: could not read {0}", absolutePath);
            return false;
        }
        try {
            String canonicalPath = file.getCanonicalPath();
            if (!absolutePath.equals(canonicalPath) && !this.acceptSymlink(absolutePath, canonicalPath)) {
                log.log(Level.FINE, "Skipped symlink ''{0}'' -> ''{1}''", new Object[]{absolutePath, canonicalPath});
                return false;
            }
            if (!file.isFile() && !file.isDirectory()) {
                log.log(Level.WARNING, "Warning: ignored special file {0}", absolutePath);
                return false;
            }
        }
        catch (IOException exp) {
            log.log(Level.WARNING, "Warning: Failed to resolve name: {0}", absolutePath);
            log.log(Level.FINE, "Stack Trace: ", exp);
        }
        if (file.isDirectory()) {
            return true;
        }
        if (HistoryGuru.getInstance().hasHistory(file)) {
            return true;
        }
        return !RuntimeEnvironment.getInstance().isIndexVersionedFilesOnly();
    }

    boolean accept(File parent, File file) {
        try {
            File f1 = parent.getCanonicalFile();
            File f2 = file.getCanonicalFile();
            if (f1.equals(f2)) {
                log.log(Level.INFO, "Skipping links to itself...: {0} {1}", new Object[]{parent.getAbsolutePath(), file.getAbsolutePath()});
                return false;
            }
            File t1 = f1;
            while ((t1 = t1.getParentFile()) != null) {
                if (!f2.equals(t1)) continue;
                log.log(Level.INFO, "Skipping links to parent...: {0} {1}", new Object[]{parent.getAbsolutePath(), file.getAbsolutePath()});
                return false;
            }
            return this.accept(file);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Warning: Failed to resolve name: {0} {1}", new Object[]{parent.getAbsolutePath(), file.getAbsolutePath()});
            return false;
        }
    }

    private boolean acceptSymlink(String absolutePath, String canonicalPath) throws IOException {
        if (this.isLocal(canonicalPath)) {
            return true;
        }
        for (String allowedSymlink : RuntimeEnvironment.getInstance().getAllowedSymlinks()) {
            String allowedTarget;
            if (!absolutePath.startsWith(allowedSymlink) || !canonicalPath.startsWith(allowedTarget = new File(allowedSymlink).getCanonicalPath()) || !absolutePath.substring(allowedSymlink.length()).equals(canonicalPath.substring(allowedTarget.length()))) continue;
            return true;
        }
        return false;
    }

    private boolean isLocal(String path) {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        String srcRoot = env.getSourceRootPath();
        boolean local = false;
        if (path.startsWith(srcRoot)) {
            if (env.hasProjects()) {
                String relPath = path.substring(srcRoot.length());
                if (this.project.equals(Project.getProject(relPath))) {
                    local = true;
                }
            } else {
                local = true;
            }
        }
        return local;
    }

    private int indexDown(File dir, String parent, boolean count_only, int cur_count, int est_total) throws IOException {
        int lcur_count = cur_count;
        if (this.isInterrupted()) {
            return lcur_count;
        }
        if (!this.accept(dir)) {
            return lcur_count;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            log.log(Level.SEVERE, "Failed to get file listing for: {0}", dir.getAbsolutePath());
            return lcur_count;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File p1, File p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        for (File file : files) {
            if (!this.accept(dir, file)) continue;
            String path = parent + '/' + file.getName();
            if (file.isDirectory()) {
                lcur_count = this.indexDown(file, path, count_only, lcur_count, est_total);
                continue;
            }
            ++lcur_count;
            if (count_only) continue;
            if (RuntimeEnvironment.getInstance().isPrintProgress() && est_total > 0 && log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Progress: {0} ({1}%)", new Object[]{lcur_count, Float.valueOf((float)lcur_count * 100.0f / (float)est_total)});
            }
            if (this.uidIter != null) {
                BytesRef next;
                String uid = Util.path2uid(path, DateTools.timeToString((long)file.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND));
                BytesRef buid = new BytesRef((CharSequence)uid);
                while (this.uidIter != null && this.uidIter.term() != null && this.uidIter.term().compareTo(this.emptyBR) != 0 && this.uidIter.term().compareTo(buid) < 0) {
                    this.removeFile();
                    next = this.uidIter.next();
                    if (next != null) continue;
                    this.uidIter = null;
                }
                if (this.uidIter != null && this.uidIter.term() != null && this.uidIter.term().bytesEquals(buid)) {
                    next = this.uidIter.next();
                    if (next != null) continue;
                    this.uidIter = null;
                    continue;
                }
            }
            try {
                this.addFile(file, path);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to add file " + file.getAbsolutePath(), e);
            }
        }
        return lcur_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.lock;
        synchronized (object) {
            this.interrupted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.interrupted;
        }
    }

    public void addIndexChangedListener(IndexChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeIndexChangedListener(IndexChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static void listAllFiles() throws IOException {
        IndexDatabase.listAllFiles(null);
    }

    public static void listAllFiles(List<String> subFiles) throws IOException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (env.hasProjects()) {
            if (subFiles == null || subFiles.isEmpty()) {
                for (Project project : env.getProjects()) {
                    IndexDatabase db = new IndexDatabase(project);
                    db.listFiles();
                }
            } else {
                for (String path : subFiles) {
                    Project project = Project.getProject(path);
                    if (project == null) {
                        log.log(Level.WARNING, "Warning: Could not find a project for \"{0}\"", path);
                        continue;
                    }
                    IndexDatabase db = new IndexDatabase(project);
                    db.listFiles();
                }
            }
        } else {
            IndexDatabase db = new IndexDatabase();
            db.listFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listFiles() throws IOException {
        DirectoryReader ireader = null;
        TermsEnum iter = null;
        Terms terms = null;
        try {
            ireader = DirectoryReader.open((Directory)this.indexDirectory);
            int numDocs = ireader.numDocs();
            if (numDocs > 0) {
                Fields uFields = MultiFields.getFields((IndexReader)ireader);
                terms = uFields.terms("u");
            }
            iter = terms.iterator(iter);
            while (iter != null && iter.term() != null) {
                log.fine(Util.uid2url(iter.term().utf8ToString()));
                BytesRef next = iter.next();
                if (next != null) continue;
                iter = null;
            }
        }
        finally {
            if (ireader != null) {
                try {
                    ireader.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while closing index reader", e);
                }
            }
        }
    }

    static void listFrequentTokens() throws IOException {
        IndexDatabase.listFrequentTokens(null);
    }

    static void listFrequentTokens(List<String> subFiles) throws IOException {
        int limit = 4;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (env.hasProjects()) {
            if (subFiles == null || subFiles.isEmpty()) {
                for (Project project : env.getProjects()) {
                    IndexDatabase db = new IndexDatabase(project);
                    db.listTokens(4);
                }
            } else {
                for (String path : subFiles) {
                    Project project = Project.getProject(path);
                    if (project == null) {
                        log.log(Level.WARNING, "Warning: Could not find a project for \"{0}\"", path);
                        continue;
                    }
                    IndexDatabase db = new IndexDatabase(project);
                    db.listTokens(4);
                }
            }
        } else {
            IndexDatabase db = new IndexDatabase();
            db.listTokens(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listTokens(int freq) throws IOException {
        DirectoryReader ireader = null;
        TermsEnum iter = null;
        Terms terms = null;
        try {
            ireader = DirectoryReader.open((Directory)this.indexDirectory);
            int numDocs = ireader.numDocs();
            if (numDocs > 0) {
                Fields uFields = MultiFields.getFields((IndexReader)ireader);
                terms = uFields.terms("defs");
            }
            iter = terms.iterator(iter);
            while (iter != null && iter.term() != null) {
                BytesRef next;
                if (iter.docFreq() > 16 && iter.term().utf8ToString().length() > freq) {
                    log.warning(iter.term().utf8ToString());
                }
                if ((next = iter.next()) != null) continue;
                iter = null;
            }
        }
        finally {
            if (ireader != null) {
                try {
                    ireader.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occured while closing index reader", e);
                }
            }
        }
    }

    public static IndexReader getIndexReader(String path) {
        DirectoryReader ret = null;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        File indexDir = new File(env.getDataRootFile(), INDEX_DIR);
        if (env.hasProjects()) {
            Project p = Project.getProject(path);
            if (p == null) {
                return null;
            }
            indexDir = new File(indexDir, p.getPath());
        }
        try {
            FSDirectory fdir = FSDirectory.open((File)indexDir, (LockFactory)NoLockFactory.getNoLockFactory());
            if (indexDir.exists() && DirectoryReader.indexExists((Directory)fdir)) {
                ret = DirectoryReader.open((Directory)fdir);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Failed to open index: {0}", indexDir.getAbsolutePath());
            log.log(Level.FINE, "Stack Trace: ", ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Definitions getDefinitions(File file) throws IOException, ParseException, ClassNotFoundException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        String path = env.getPathRelativeToSourceRoot(file, 0);
        IndexReader ireader = IndexDatabase.getIndexReader(path = path.replace("\\", "/"));
        if (ireader == null) {
            return null;
        }
        try {
            IndexableField tags;
            Query q = new QueryBuilder().setPath(path).build();
            IndexSearcher searcher = new IndexSearcher(ireader);
            TopDocs top = searcher.search(q, 1);
            if (top.totalHits == 0) {
                Definitions definitions = null;
                return definitions;
            }
            Document doc = searcher.doc(top.scoreDocs[0].doc);
            String foundPath = doc.get("path");
            if (path.equals(foundPath) && (tags = doc.getField("tags")) != null) {
                Definitions definitions = Definitions.deserialize(tags.binaryValue().bytes);
                return definitions;
            }
        }
        finally {
            ireader.close();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDatabase other = (IndexDatabase)obj;
        return this.project == other.project || this.project != null && this.project.equals(other.project);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.project == null ? 0 : this.project.hashCode());
        return hash;
    }

    private Writer getXrefWriter(FileAnalyzer fa, String path) throws IOException {
        FileAnalyzer.Genre g = fa.getFactory().getGenre();
        if (this.xrefDir != null && (g == FileAnalyzer.Genre.PLAIN || g == FileAnalyzer.Genre.XREFABLE)) {
            File xrefFile = new File(this.xrefDir, path);
            if (!xrefFile.getParentFile().mkdirs()) assert (xrefFile.getParentFile().exists());
            RuntimeEnvironment env = RuntimeEnvironment.getInstance();
            boolean compressed = env.isCompressXref();
            File file = new File(this.xrefDir, path + (compressed ? ".gz" : ""));
            return new BufferedWriter(new OutputStreamWriter(compressed ? new GZIPOutputStream(new FileOutputStream(file)) : new FileOutputStream(file)));
        }
        return null;
    }
}

