/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.util;

import java.util.regex.Pattern;

public final class StringUtils {
    static final Pattern javaClassPattern = Pattern.compile("([a-z][A-Za-z]*\\.)+[A-Z][A-Za-z0-9]*");

    private StringUtils() {
    }

    public static boolean isOnlyWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPossiblyJavaClass(String s) {
        return javaClassPattern.matcher(s).matches();
    }

    public static String getReadableTime(long time_ms) {
        String output = "";
        long time_delta = time_ms;
        int milliseconds = (int)(time_delta % 1000L);
        int seconds = (int)((time_delta /= 1000L) % 60L);
        int minutes = (int)((time_delta /= 60L) % 60L);
        int hours = (int)((time_delta /= 60L) % 24L);
        int days = (int)(time_delta / 24L);
        if (days != 0) {
            output = output + String.format("%d day", days);
            if (days > 1) {
                output = output + "s";
            }
            if (hours != 0 || minutes != 0 || seconds != 0) {
                output = output + " ";
            }
        }
        if (hours != 0 || minutes != 0) {
            return output + String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        if (seconds != 0) {
            return output + String.format("%d.%d seconds", seconds, milliseconds);
        }
        if (milliseconds != 0) {
            return output + String.format("%d ms", milliseconds);
        }
        return output.length() == 0 ? "0" : output;
    }
}

