/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.util.Map;
import java.util.TreeMap;

public enum Prefix {
    UNKNOWN(""),
    XREF_P("/xref"),
    XREF_S("/xr"),
    MORE_P("/more"),
    MORE_S("/mo"),
    DIFF_P("/diff"),
    DIFF_S("/di"),
    HIST_P("/hist"),
    HIST_S("/hi"),
    HIST_L("/history"),
    RSS_P("/rss"),
    DOWNLOAD_P("/download"),
    RAW_P("/raw"),
    SEARCH_P("/search"),
    SEARCH_R("/s"),
    SEARCH_O("/opensearch"),
    NOT_FOUND("/enoent"),
    ERROR("/error");

    private String prefix;
    private static Map<String, Prefix> lookupTable;

    private Prefix(String prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return this.prefix;
    }

    public static Prefix get(String servletPath) {
        if (servletPath == null || servletPath.length() < 3 || servletPath.charAt(0) != '/') {
            return UNKNOWN;
        }
        int idx = servletPath.indexOf(47, 1);
        String pathPrefix = idx == -1 ? servletPath : servletPath.substring(0, idx);
        Prefix p = lookupTable.get(pathPrefix);
        return p == null ? UNKNOWN : p;
    }

    static {
        lookupTable = new TreeMap<String, Prefix>();
        for (Prefix p : Prefix.values()) {
            lookupTable.put(p.toString(), p);
        }
    }
}

