/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHierarchyUtils {
    private static final Comparator<NodeDescriptor> NODE_DESCRIPTOR_COMPARATOR = (first, second) -> first.getIndex() - second.getIndex();

    public static Comparator<NodeDescriptor> getComparator(Project project) {
        if (HierarchyBrowserManager.getInstance((Project)project).getState().SORT_ALPHABETICALLY) {
            return AlphaComparator.INSTANCE;
        }
        return NODE_DESCRIPTOR_COMPARATOR;
    }

    @Nullable
    public static JSPsiElementBase getJSFunction(DataContext dataContext) {
        return JSHierarchyUtils.getJSFunction(dataContext, false);
    }

    @Nullable
    public static JSPsiElementBase getJSFunction(DataContext dataContext, boolean allowJSFunctionExpression) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        JSPsiElementBase method = JSHierarchyUtils.getJSFunction(element, allowJSFunctionExpression);
        if (method != null) {
            return method;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 instanceof XmlFile) {
            Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file2);
            if (injEditor instanceof EditorWindow) {
                PsiFile injFile = ((EditorWindow)injEditor).getInjectedFile();
                int offset = injEditor.getCaretModel().getOffset();
                element = injFile.findElementAt(offset);
            }
        } else if (file2 instanceof JSFile) {
            int offset = editor.getCaretModel().getOffset();
            element = file2.findElementAt(offset);
        }
        return JSHierarchyUtils.getJSFunction(element, allowJSFunctionExpression);
    }

    @Nullable
    public static JSFunction getJSFunction(JSCallExpression callExpression) {
        PsiElement method;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && (method = ((JSReferenceExpression)methodExpression).resolve()) instanceof JSFunction) {
            return (JSFunction)method;
        }
        return null;
    }

    @Nullable
    public static JSSourceElement getJSFunctionOrClass(JSCallExpression callExpression) {
        PsiElement psiElement;
        JSExpression methodExpression;
        JSExpression jSExpression = methodExpression = callExpression == null ? null : callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && ((psiElement = ((JSReferenceExpression)methodExpression).resolve()) instanceof JSFunction || psiElement instanceof JSClass && callExpression instanceof JSNewExpression)) {
            return (JSSourceElement)psiElement;
        }
        return null;
    }

    @Nullable
    private static JSPsiElementBase getJSFunction(PsiElement psiElement, boolean allowJSFunctionExpression) {
        JSElement jsElement;
        JSFunction method = null;
        JSElement jSElement = jsElement = psiElement == null ? null : (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSCallExpression.class, JSFunction.class, JSDefinitionExpression.class, JSVariable.class, JSImplicitElement.class});
        if (jsElement instanceof JSCallExpression) {
            method = JSHierarchyUtils.getJSFunction((JSCallExpression)jsElement);
        } else if (jsElement instanceof JSFunction) {
            method = (JSFunction)jsElement;
        } else if (jsElement instanceof JSDefinitionExpression) {
            method = (JSDefinitionExpression)jsElement;
        } else if (jsElement instanceof JSVariable) {
            method = (JSVariable)jsElement;
        } else if (jsElement instanceof JSImplicitElement && !((JSImplicitElement)jsElement).hasMinorImportance()) {
            method = (JSImplicitElement)jsElement;
        }
        if (method == null && allowJSFunctionExpression && psiElement instanceof JSPsiElementBase && JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)psiElement) != null) {
            return (JSPsiElementBase)psiElement;
        }
        return allowJSFunctionExpression ? method : (method instanceof JSFunctionExpression ? null : method);
    }

    @Nullable
    public static String getQName(@NotNull JSPsiElementBase jsFunction) {
        if (jsFunction == null) {
            JSHierarchyUtils.$$$reportNull$$$0(0);
        }
        return jsFunction.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFunction", "com/intellij/lang/javascript/hierarchy/JSHierarchyUtils", "getQName"));
    }
}

