/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextLevel {
    @NotNull
    public final JSNamespace myNamespace;
    public final int myRelativeLevel;

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel) {
        if (namespace == null) {
            JSContextLevel.$$$reportNull$$$0(0);
        }
        this.myNamespace = namespace;
        this.myRelativeLevel = relativeLevel;
    }

    public String toString() {
        return this.myNamespace.toString() + " ," + this.myRelativeLevel;
    }

    public boolean isElementInScope(@NotNull JSPsiElementBase element, @NotNull PsiFile currentFile) {
        PsiElement localScope;
        if (element == null) {
            JSContextLevel.$$$reportNull$$$0(1);
        }
        if (currentFile == null) {
            JSContextLevel.$$$reportNull$$$0(2);
        }
        if ((localScope = this.myNamespace.getLocalScope()) != null) {
            JSPsiElementBase scope = element;
            while (scope != null) {
                if (localScope.equals(scope)) {
                    return true;
                }
                scope = JSPsiImplUtils.getExecutionScope((PsiElement)scope);
            }
            return false;
        }
        boolean isElementLocal = element.getJSNamespace().isLocal();
        if (isElementLocal && !element.getContainingFile().isEquivalentTo((PsiElement)currentFile)) {
            return false;
        }
        return !isElementLocal || !element.isNamespaceExplicitlyDeclared() || this.myNamespace.isLocal();
    }

    public boolean isGlobal() {
        return !this.myNamespace.isLocal();
    }

    @Nullable
    public PsiFile getScopeFile() {
        PsiElement localScope = this.myNamespace.getLocalScope();
        return localScope != null ? localScope.getContainingFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSContextLevel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementInScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

