/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class PlainGherkinKeywordProvider
implements GherkinKeywordProvider {
    public static GherkinKeywordTable DEFAULT_KEYWORD_TABLE = new GherkinKeywordTable();
    public static Map<String, IElementType> DEFAULT_KEYWORDS = new HashMap<String, IElementType>();
    private static final Set<String> ourKeywordsWithNoSpaceAfter = new HashSet<String>();

    @Override
    public Collection<String> getAllKeywords(String language) {
        return DEFAULT_KEYWORDS.keySet();
    }

    @Override
    public IElementType getTokenType(String language, String keyword) {
        return DEFAULT_KEYWORDS.get(keyword);
    }

    @Override
    public String getBaseKeyword(String language, String keyword) {
        return keyword;
    }

    @Override
    public boolean isSpaceAfterKeyword(String language, String keyword) {
        return !ourKeywordsWithNoSpaceAfter.contains(keyword);
    }

    @Override
    public boolean isStepKeyword(String keyword) {
        return DEFAULT_KEYWORDS.get(keyword) == GherkinTokenTypes.STEP_KEYWORD;
    }

    @Override
    @NotNull
    public GherkinKeywordTable getKeywordsTable(@Nullable String language) {
        GherkinKeywordTable gherkinKeywordTable = DEFAULT_KEYWORD_TABLE;
        if (gherkinKeywordTable == null) {
            PlainGherkinKeywordProvider.$$$reportNull$$$0(0);
        }
        return gherkinKeywordTable;
    }

    static {
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.FEATURE_KEYWORD, "Feature");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.BACKGROUND_KEYWORD, "Background");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.SCENARIO_KEYWORD, "Scenario");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD, "Scenario Outline");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.EXAMPLES_KEYWORD, "Examples");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.EXAMPLES_KEYWORD, "Scenarios");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "Given");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "When");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "Then");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "And");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "But");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "*");
        DEFAULT_KEYWORD_TABLE.put(GherkinTokenTypes.STEP_KEYWORD, "Lorsqu'");
        ourKeywordsWithNoSpaceAfter.add("Lorsqu'");
        DEFAULT_KEYWORD_TABLE.putAllKeywordsInto(DEFAULT_KEYWORDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/PlainGherkinKeywordProvider", "getKeywordsTable"));
    }
}

