/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.dbimport.ImportUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CsvPreviewModel {
    private static final int MAX_BYTES = 5000;
    private final byte[] myBytes;
    private Charset myCharset;
    private final VirtualFile myFile;

    public CsvPreviewModel(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            CsvPreviewModel.$$$reportNull$$$0(0);
        }
        this.myBytes = CsvPreviewModel.loadBytes(file);
        this.myCharset = file.getCharset();
        this.myFile = file;
    }

    @NotNull
    public String getText() {
        String s = new String(this.myBytes, this.myCharset);
        String string = StringUtil.convertLineSeparators((String)s);
        if (string == null) {
            CsvPreviewModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            CsvPreviewModel.$$$reportNull$$$0(2);
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            CsvPreviewModel.$$$reportNull$$$0(3);
        }
        this.myCharset = charset;
    }

    public void acceptCharset() {
        this.myFile.setCharset(this.myCharset);
    }

    private static byte[] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            CsvPreviewModel.$$$reportNull$$$0(4);
        }
        byte[] bytes = new byte[5000];
        try (InputStream stream = ImportUtil.getInputStream(file);){
            int read2 = Math.max(stream.read(bytes), 0);
            byte[] byArray = Arrays.copyOf(bytes, read2);
            return byArray;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/csv/CsvPreviewModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/csv/CsvPreviewModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

