/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorUtil {
    public static JComponent labeledDecorator(@NotNull JComponent label, @NotNull JBTable table) {
        if (label == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(0);
        }
        if (table == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(1);
        }
        return DatabaseEditorUtil.labeledDecorator(label, ToolbarDecorator.createDecorator((JTable)table));
    }

    @NotNull
    public static JComponent labeledDecorator(@NotNull JComponent label, ToolbarDecorator decorator) {
        if (label == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(2);
        }
        decorator.setToolbarPosition(ActionToolbarPosition.TOP);
        JPanel p2 = decorator.createPanel();
        decorator.getActionsPanel().setToolbarLabel(label, ActionToolbarPosition.LEFT);
        decorator.getActionsPanel().getToolbar().setReservePlaceAutoPopupIcon(false);
        JPanel jPanel = p2;
        if (jPanel == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public static int computeLength(@NotNull Iterable<Pair<String, TextAttributesKey>> iterable) {
        if (iterable == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(4);
        }
        int length = 0;
        for (Pair<String, TextAttributesKey> pair : iterable) {
            length += ((String)pair.first).length();
        }
        return length;
    }

    public static void padText(@NotNull ColoredFragmentsBuilder builder, int maxLength, int length) {
        if (builder == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < maxLength - length + 1; ++i2) {
            builder.append(" ");
        }
    }

    public static <T> ListTableModel<T> createTableModel(final @NotNull ObjectEditorModel model, final @NotNull EditorModelHelper<T> helper, final boolean canExchange) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(6);
        }
        if (helper == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(7);
        }
        return new ListTableModel<T>(new ColumnInfo[0]){

            public void addRow() {
                Object row = helper.createRow();
                if (row == null) {
                    return;
                }
                this.addRow(row);
                model.commit();
            }

            public void removeRow(int idx) {
                if (!helper.removeRow(this.getItem(idx), idx)) {
                    return;
                }
                super.removeRow(idx);
                model.commit();
            }

            public boolean canExchangeRows(int oldIndex, int newIndex) {
                return canExchange;
            }

            public void exchangeRows(int idx1, int idx2) {
                if (idx1 == idx2) {
                    return;
                }
                if (!helper.exchangeRows(this.getItem(idx1), idx1, this.getItem(idx2), idx2)) {
                    return;
                }
                super.exchangeRows(idx1, idx2);
                model.commit();
            }
        };
    }

    public static <Ed extends DatabaseEditorBaseEx, Das extends DasObject> void cleanupEditors(@NotNull ListTableModel<Ed> model, @NotNull Iterable<? extends Das> objects, @NotNull Function<Das, Ed> fac) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(8);
        }
        if (objects == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(9);
        }
        if (fac == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(10);
        }
        HashMap editors = ContainerUtil.newHashMap();
        ArrayList newItems = ContainerUtil.newArrayList();
        for (DatabaseEditorBaseEx editor : model.getItems()) {
            editors.put(editor.getKeyObject(), editor);
        }
        for (DasObject column2 : objects) {
            DatabaseEditorBaseEx editor = (DatabaseEditorBaseEx)editors.get(column2);
            if (editor == null) {
                editor = (DatabaseEditorBaseEx)fac.fun((Object)column2);
            }
            editors.remove(column2);
            newItems.add(editor);
        }
        for (DatabaseEditorBaseEx editor : editors.values()) {
            Disposer.dispose((Disposable)editor);
        }
        if (model.getItems().equals(newItems)) {
            return;
        }
        model.setItems((List)newItems);
    }

    public static void setTableDecoratorMinSize(@NotNull JComponent component, @NotNull JTable table) {
        if (component == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(11);
        }
        if (table == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    public static <T extends EmbeddableEditor> DbListTableWithEditor createTableWithEditor(@NotNull ListTableModel<T> model, @NotNull DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(14);
        }
        DbListTableWithEditor<T> dbListTableWithEditor = new DbListTableWithEditor<T>(model, editor, rows, width, contextMenu);
        if (dbListTableWithEditor == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(15);
        }
        return dbListTableWithEditor;
    }

    @NotNull
    public static ShutSplitter createHideableSplitter(@NotNull String separatorText, @NotNull JComponent first, @NotNull JComponent second, @Nullable String key2) {
        if (separatorText == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(16);
        }
        if (first == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(17);
        }
        if (second == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(18);
        }
        ShutSplitter splitter = new ShutSplitter(separatorText, key2);
        splitter.setFirstComponent(first);
        splitter.setSecondComponent(second);
        ShutSplitter shutSplitter = splitter;
        if (shutSplitter == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(19);
        }
        return shutSplitter;
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T startItemEditing(@Nullable DeObject object, JBListTable table, ListTableModel<T> model) {
        int index2 = DatabaseEditorUtil.findObjectIndex(object, model);
        if (index2 == -1) {
            return null;
        }
        TableUtil.selectRows((JTable)table.getTable(), (int[])new int[]{index2});
        TableUtil.editCellAt((JTable)table.getTable(), (int)index2, (int)0);
        TableUtil.scrollSelectionToVisible((JTable)table.getTable());
        return (T)((DatabaseEditorBaseEx)model.getItem(index2));
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T getEditedItem(JBListTable table, ListTableModel<T> model) {
        int index2 = table.getTable().getEditingRow();
        if (index2 == -1) {
            return null;
        }
        return (T)((DatabaseEditorBaseEx)model.getItem(index2));
    }

    public static <T extends DatabaseEditorBaseEx> int findObjectIndex(@Nullable DeObject object, ListTableModel<T> model) {
        int index2 = 0;
        for (DatabaseEditorBaseEx ed : model.getItems()) {
            if (ed.getKeyObject() == object) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    public static void setSmallFontRecursive(@Nullable JComponent component) {
        for (Component c2 : UIUtil.uiTraverser((Component)component)) {
            if (!(c2 instanceof JLabel) && !(c2 instanceof AbstractButton)) continue;
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)c2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "labeledDecorator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableWithEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideableSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "labeledDecorator";
                break;
            }
            case 3: 
            case 15: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "padText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTableModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanupEditors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTableDecoratorMinSize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTableWithEditor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createHideableSplitter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class JBTableRowEditorWrapper<T extends EmbeddableEditor>
    extends JBTableRowEditor {
        protected final T myComponent;

        protected JBTableRowEditorWrapper(T component) {
            this.myComponent = component;
        }

        public void prepareEditor(JTable table, int row) {
            this.setLayout(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            JComponent component = this.myComponent.getComponent();
            DatabaseEditorUtil.setSmallFontRecursive(component);
            this.add(component, "Center");
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myComponent.getPreferredFocusedComponent();
        }

        public JComponent[] getFocusableComponents() {
            return this.myComponent.getFocusableComponents();
        }
    }

    public static class FlagUpdater
    implements AnActionButtonUpdater {
        private boolean myEnabled = true;

        public FlagUpdater(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                FlagUpdater.$$$reportNull$$$0(0);
            }
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseEditorUtil$FlagUpdater", "isEnabled"));
        }
    }

    public static class DbListTableWithEditor<T extends EmbeddableEditor>
    extends DbListTable<T> {
        private boolean myEditable = true;

        public DbListTableWithEditor(ListTableModel<T> model, DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
            super(model, editor, rows, width, contextMenu);
        }

        private boolean isSelecting() {
            return this.myMouseEvent != null && ((this.myMouseEvent.getModifiers() & 2) != 0 || (this.myMouseEvent.getModifiers() & 1) != 0 || (this.myMouseEvent.getModifiers() & 8) != 0 || (this.myMouseEvent.getModifiers() & 4) != 0 || this.isNotDoubleClick());
        }

        private boolean isNotDoubleClick() {
            return (this.myMouseEvent.getID() == 500 || this.myMouseEvent.getID() == 502 || this.myMouseEvent.getID() == 501) && this.myMouseEvent.getClickCount() < 2;
        }

        @Override
        protected JBTableRowEditor getRowEditor(final int row) {
            if (this.isSelecting()) {
                return null;
            }
            EmbeddableEditor editor = (EmbeddableEditor)this.getEditor(row);
            if (!this.myEditable || !editor.canDoAnything()) {
                return null;
            }
            return new JBTableRowEditorWrapper<T>(editor){

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column2) {
                            return myInternalTable.getValueAt(row, column2);
                        }
                    };
                }

                @Override
                public JComponent[] getFocusableComponents() {
                    return (JComponent[])Arrays.stream(super.getFocusableComponents()).filter(Component::isEnabled).toArray(JComponent[]::new);
                }
            };
        }

        public void setEditable(boolean editable) {
            this.myEditable = editable;
        }
    }

    public static class DbListTable<T extends RowStringProvider>
    extends JBListTable {
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        public DbListTable(@NotNull ListTableModel<T> model, final @NotNull DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
            if (model == null) {
                DbListTable.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                DbListTable.$$$reportNull$$$0(1);
            }
            super((JTable)new TableView<T>(model){

                public void tableChanged(TableModelEvent e) {
                    super.tableChanged(e);
                }
            }, (Disposable)editor);
            this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(editor.getContext().getProject(), (FileType)editor.getContext().getSqlDialect().getAssociatedFileType(), editor){

                protected String getText(JTable table, int row) {
                    return "";
                }

                private Iterable<Pair<String, TextAttributesKey>> getText(int row) {
                    return this.getEditor(row).getRowText();
                }

                @Nullable
                protected TextAttributes getTextAttributes(JTable table, int row) {
                    return this.getEditor(row).isObjectValid() ? null : this.getColorScheme(table).getAttributes(HighlighterColors.BAD_CHARACTER);
                }

                protected void customizeEditor(@NotNull EditorEx textEditor, JTable table, Object value, boolean selected, int row, int column2) {
                    if (textEditor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    VirtualFile file = FileDocumentManager.getInstance().getFile((Document)textEditor.getDocument());
                    SqlLanguageDialect dialect = editor.getContext().getSqlDialect();
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)editor.getContext().getProject(), (VirtualFile)file);
                    EditorColorsScheme scheme = textEditor.getColorsScheme();
                    textEditor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, scheme));
                    textEditor.getMarkupModel().removeAllHighlighters();
                    StringBuilder text2 = new StringBuilder(" ");
                    Iterable<Pair<String, TextAttributesKey>> fragments = this.getText(row);
                    TIntArrayList ranges = new TIntArrayList();
                    ranges.add(text2.length());
                    for (Pair<String, TextAttributesKey> pair : fragments) {
                        text2.append((String)pair.first);
                        ranges.add(text2.length());
                    }
                    textEditor.getDocument().setText((CharSequence)text2);
                    ((EditorImpl)textEditor).resetSizes();
                    textEditor.getHighlighter().setText((CharSequence)text2);
                    int i2 = 0;
                    for (Pair<String, TextAttributesKey> pair : fragments) {
                        if (pair.second != null) {
                            textEditor.getMarkupModel().addRangeHighlighter(ranges.get(i2), ranges.get(i2 + 1), 4000, scheme.getAttributes((TextAttributesKey)pair.second), HighlighterTargetArea.EXACT_RANGE);
                        }
                        ++i2;
                    }
                    textEditor.getMarkupModel().addRangeHighlighter(0, textEditor.getDocument().getTextLength(), 4000, this.getTextAttributes(table, row), HighlighterTargetArea.EXACT_RANGE);
                    ((EditorImpl)textEditor).setPaintSelection(selected);
                    SelectionModel selectionModel = textEditor.getSelectionModel();
                    selectionModel.setSelection(0, selected ? textEditor.getDocument().getTextLength() : 0);
                }

                @NotNull
                protected EditorTextFieldCellRenderer.RendererComponent createRendererComponent(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
                    EditorTextFieldCellRenderer.SimpleRendererComponent simpleRendererComponent = new EditorTextFieldCellRenderer.SimpleRendererComponent(project, fileType, inheritFontFromLaF);
                    if (simpleRendererComponent == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return simpleRendererComponent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "textEditor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeEditor";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            JBTable table = this.getTable();
            table.setCellSelectionEnabled(true);
            table.getSelectionModel().setSelectionMode(2);
            if (contextMenu != null) {
                PopupHandler.installUnknownPopupHandler((JComponent)table, (ActionGroup)contextMenu, (ActionManager)ActionManager.getInstance());
            }
            table.setSurrendersFocusOnKeystroke(true);
            table.setStriped(true);
            table.getSelectionModel().setSelectionInterval(0, 0);
            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            int height = table.getRowHeight();
            table.setPreferredScrollableViewportSize(new Dimension(width, height * Math.max(4, rows)));
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected T getEditor(int row) {
            return (T)((RowStringProvider)((TableView)this.myInternalTable).getTableViewModel().getItems().get(row));
        }

        protected JBTableRowEditor getRowEditor(int row) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class EmbeddableEditorAdapter
    implements EmbeddableEditor {
        @Override
        public boolean canDoAnything() {
            return true;
        }

        @Override
        public boolean isObjectValid() {
            return true;
        }

        @Override
        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> getRowText() {
            List<Pair<String, TextAttributesKey>> list = Collections.emptyList();
            if (list == null) {
                EmbeddableEditorAdapter.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil$EmbeddableEditorAdapter", "getRowText"));
        }
    }

    public static interface EmbeddableEditor
    extends RowStringProvider {
        public boolean canDoAnything();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        @NotNull
        public JComponent[] getFocusableComponents();
    }

    public static interface RowStringProvider {
        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> getRowText();

        public boolean isObjectValid();
    }

    public static class ColoredFragmentsBuilder {
        private JBIterable<Pair<String, TextAttributesKey>> myResult = JBIterable.empty();
        private final StringBuilder myBuffer = new StringBuilder();

        public ColoredFragmentsBuilder append(@NotNull String frag) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(0);
            }
            return this.append(frag, null);
        }

        public ColoredFragmentsBuilder appendRef(@NotNull String frag, boolean good) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(1);
            }
            return this.append(frag, good ? null : CodeInsightColors.WARNINGS_ATTRIBUTES);
        }

        public ColoredFragmentsBuilder append(@NotNull String frag, @Nullable TextAttributesKey attrs) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(2);
            }
            if (attrs == null) {
                this.myBuffer.append(frag);
            } else {
                this.finish();
                this.myResult = this.myResult.append((Object)Pair.create((Object)frag, (Object)attrs));
            }
            return this;
        }

        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> build() {
            this.finish();
            JBIterable<Pair<String, TextAttributesKey>> jBIterable = this.myResult;
            if (jBIterable == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private void finish() {
            if (this.myBuffer.length() == 0) {
                return;
            }
            this.myResult = this.myResult.append((Object)Pair.create((Object)this.myBuffer.toString(), null));
            this.myBuffer.setLength(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendRef";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class EditorModelHelper<T> {
        @Nullable
        public T createRow() {
            return null;
        }

        public boolean removeRow(T item, int idx) {
            return false;
        }

        public boolean exchangeRows(T item0, int idx0, T item1, int idx1) {
            return false;
        }
    }
}

