/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import a.b.lb;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTreeHasher
implements TreeHasher {
    protected final boolean myForIndexing;
    protected final FragmentsCollector myCallBack;
    private static final long d = lb.a(5720039836448877578L, -854565688113605966L, MethodHandles.lookup().lookupClass()).a(174042674350447L);

    public AbstractTreeHasher(FragmentsCollector cb2, boolean forIndexing) {
        this.myCallBack = cb2;
        this.myForIndexing = forIndexing;
    }

    @Override
    public final void hash(@NotNull PsiElement root, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            AbstractTreeHasher.a(0);
        }
        if (hasher == null) {
            AbstractTreeHasher.a(1);
        }
        this.hash(root, null, hasher);
    }

    protected abstract TreeHashResult hash(@NotNull PsiElement var1, PsiFragment var2, @NotNull NodeSpecificHasher var3);

    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        int n2;
        int n3;
        if (root == null) {
            AbstractTreeHasher.a(2);
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        ProgressManager.checkCanceled();
        List<PsiElement> list2 = hasher.getNodeChildren(root);
        int n4 = list2.size();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        TreePsiFragment treePsiFragment = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            treePsiFragment.setParent(upper);
        }
        if (n4 == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(hasher.getNodeHash(root), hasher.getNodeCost(root), treePsiFragment);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            TreeHashResult treeHashResult = this.hash(list2.get(n3), treePsiFragment, hasher);
            nArray[n3] = treeHashResult.getHash();
            nArray2[n3] = treeHashResult.getCost();
        }
        n3 = hasher.getNodeCost(root) + AbstractTreeHasher.vector(nArray2);
        int n5 = hasher.getNodeHash(root);
        int n6 = this.getDiscardCost(root);
        for (n2 = 0; n2 < n4; ++n2) {
            if (nArray2[n2] > n6 || !this.ignoreChildHash(list2.get(n2))) continue;
            nArray[n2] = 0;
        }
        n2 = n5 + AbstractTreeHasher.vector(nArray);
        if (this.myCallBack != null) {
            this.myCallBack.add(n2, n3, treePsiFragment);
        }
        return new TreeHashResult(n2, n3, treePsiFragment);
    }

    protected TreePsiFragment buildFragment(NodeSpecificHasher hasher, PsiElement root, int cost) {
        if (this.myForIndexing) {
            return new TreePsiFragment(hasher, root, cost){

                @Override
                protected PsiAnchor createAnchor(PsiElement element) {
                    return new PsiAnchor.HardReference(element);
                }

                @Override
                protected Language calcLanguage(PsiElement element) {
                    return null;
                }
            };
        }
        return new TreePsiFragment(hasher, root, cost);
    }

    protected TreePsiFragment buildFragment(NodeSpecificHasher hasher, List<? extends PsiElement> elements, int from, int to) {
        if (this.myForIndexing) {
            return new TreePsiFragment(hasher, elements, from, to){

                @Override
                protected PsiAnchor createAnchor(PsiElement element) {
                    return new PsiAnchor.HardReference(element);
                }

                @Override
                protected Language calcLanguage(PsiElement element) {
                    return null;
                }
            };
        }
        return new TreePsiFragment(hasher, elements, from, to);
    }

    protected abstract int getDiscardCost(PsiElement var1);

    protected boolean ignoreChildHash(PsiElement element) {
        return false;
    }

    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher) {
        return this.hashCodeBlock(statements, upper, hasher, false);
    }

    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        int n2 = statements.size();
        if (n2 == 1) {
            return this.hash(statements.get(0), upper, hasher);
        }
        if (n2 > 0 && (n2 < 20 || forceHash)) {
            PsiFragment[] psiFragmentArray = new PsiFragment[n2];
            TreePsiFragment treePsiFragment = this.buildFragment(hasher, statements, 0, n2 - 1);
            treePsiFragment.setParent(upper);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i10 = 0; i10 < n2; ++i10) {
                TreeHashResult treeHashResult = this.hash(statements.get(i10), null, hasher);
                nArray[i10] = treeHashResult.getHash();
                nArray2[i10] = treeHashResult.getCost();
                psiFragmentArray[i10] = treeHashResult.getFragment();
            }
            if (this.myCallBack != null) {
                PsiFragment[] psiFragmentArray2 = new PsiFragment[n2];
                for (int i11 = 0; i11 < n2; ++i11) {
                    int n3 = 0;
                    int n4 = 0;
                    for (int i12 = i11; i12 < n2 && i12 - i11 < 20; ++i12) {
                        PsiFragment psiFragment;
                        n3 = 31 * n3 + nArray[i12];
                        n4 += nArray2[i12];
                        PsiFragment psiFragment2 = i11 == i12 ? psiFragmentArray[i11] : (psiFragment = i11 == 0 && i12 == n2 - 1 ? treePsiFragment : this.buildFragment(hasher, statements, i11, i12));
                        if (i11 > 0) {
                            psiFragment.setParent(psiFragmentArray2[i12]);
                        }
                        psiFragmentArray2[i12] = psiFragment;
                        if (i12 > i11) {
                            psiFragmentArray2[i12 - 1].setParent(psiFragment);
                        }
                        this.myCallBack.add(n3, n4, psiFragment);
                    }
                }
            }
            return new TreeHashResult(AbstractTreeHasher.vector(nArray, 31), AbstractTreeHasher.vector(nArray2), treePsiFragment);
        }
        return new TreeHashResult(1, 0, this.buildFragment(hasher, statements, 0, n2 - 1));
    }

    protected int getCost(PsiElement root) {
        return 0;
    }

    public static int vector(int[] args) {
        return AbstractTreeHasher.vector(args, 1);
    }

    public static int vector(int[] args, int mult) {
        int n2 = 0;
        for (int n3 : args) {
            n2 = mult * n2 + n3;
        }
        return n2;
    }

    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l3 = d ^ 0x7CFCD086E5DCL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/AbstractTreeHasher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeElementHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

