/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.FileStatusMap");
    public static final String CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING = "PSI/document/model changes are not allowed during highlighting";
    private final Project myProject;
    private final Map<Document, FileStatus> myDocumentToStatusMap;
    private volatile boolean myAllowDirt;
    private static final RangeMarker WHOLE_FILE_DIRTY_MARKER = new RangeMarker(){

        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            return false;
        }

        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "WHOLE_FILE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ConcurrentMap<Thread, Integer> threads = ContainerUtil.createConcurrentWeakMap();

    public FileStatusMap(@NotNull Project project) {
        if (project == null) {
            FileStatusMap.$$$reportNull$$$0(0);
        }
        this.myDocumentToStatusMap = ContainerUtil.createWeakMap();
        this.myAllowDirt = true;
        this.myProject = project;
    }

    public void dispose() {
        this.markAllFilesDirty("FileStatusMap dispose");
    }

    @Nullable(value="null means the file is clean")
    public static TextRange getDirtyTextRange(@NotNull Editor editor, int passId) {
        if (editor == null) {
            FileStatusMap.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        FileStatusMap me = DaemonCodeAnalyzerEx.getInstanceEx(editor.getProject()).getFileStatusMap();
        TextRange dirtyScope = me.getFileDirtyScope(document, passId);
        if (dirtyScope == null) {
            return null;
        }
        TextRange documentRange = TextRange.from((int)0, (int)document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorFoundFlag(@NotNull Project project, @NotNull Document document, boolean errorFound) {
        if (project == null) {
            FileStatusMap.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(3);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                if (!errorFound) {
                    return;
                }
                status = new FileStatus(project);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.errorFound = errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasErrorFound(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(4);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && status.errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAllFilesDirty(@NotNull @NonNls Object reason) {
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(5);
        }
        this.assertAllowModifications();
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            if (!this.myDocumentToStatusMap.isEmpty()) {
                FileStatusMap.log("Mark all dirty: ", reason);
            }
            this.myDocumentToStatusMap.clear();
        }
    }

    private void assertAllowModifications() {
        try {
            assert (this.myAllowDirt) : "PSI/document/model changes are not allowed during highlighting";
        }
        finally {
            this.myAllowDirt = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileUpToDate(@NotNull Document document, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(6);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.computeIfAbsent(document, __ -> new FileStatus(this.myProject));
            status.defensivelyMarked = false;
            if (passId == 9) {
                status.wolfPassFinished = true;
            } else if (status.dirtyScopes.containsKey(passId)) {
                status.setDirtyScope(passId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(7);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
                return null;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return file2 == null ? null : file2.getTextRange();
            }
            if (status.defensivelyMarked) {
                status.markWholeFileDirty(this.myProject);
                status.defensivelyMarked = false;
            }
            if (!status.dirtyScopes.containsKey(passId)) {
                throw new IllegalStateException("Unknown pass " + passId);
            }
            RangeMarker marker = (RangeMarker)status.dirtyScopes.get(passId);
            TextRange textRange = marker == null ? null : (marker.isValid() ? TextRange.create((Segment)marker) : new TextRange(0, document.getTextLength()));
            return textRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirtyDefensively(@NotNull PsiFile file2, @NotNull @NonNls Object reason) {
        if (file2 == null) {
            FileStatusMap.$$$reportNull$$$0(8);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(9);
        }
        this.assertAllowModifications();
        FileStatusMap.log("Mark dirty file defensively: ", file2.getName(), reason);
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file2);
            if (document == null) {
                return;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            status.defensivelyMarked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirty(@NotNull Document document, @NotNull TextRange scope, int fileLength, @NotNull @NonNls Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FileStatusMap.$$$reportNull$$$0(11);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(12);
        }
        this.assertAllowModifications();
        FileStatusMap.log("Mark scope dirty: ", scope, reason);
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (status.defensivelyMarked) {
                status.defensivelyMarked = false;
            }
            status.combineScopesWith(scope, fileLength, document);
        }
    }

    @NotNull
    private static RangeMarker combineScopes(RangeMarker old, @NotNull TextRange scope, int textLength, @NotNull Document document) {
        if (scope == null) {
            FileStatusMap.$$$reportNull$$$0(13);
        }
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(14);
        }
        if (old == null) {
            if (scope.equalsToRange(0, textLength)) {
                RangeMarker rangeMarker = WHOLE_FILE_DIRTY_MARKER;
                if (rangeMarker == null) {
                    FileStatusMap.$$$reportNull$$$0(15);
                }
                return rangeMarker;
            }
            RangeMarker rangeMarker = document.createRangeMarker(scope);
            if (rangeMarker == null) {
                FileStatusMap.$$$reportNull$$$0(16);
            }
            return rangeMarker;
        }
        if (old == WHOLE_FILE_DIRTY_MARKER) {
            RangeMarker rangeMarker = old;
            if (rangeMarker == null) {
                FileStatusMap.$$$reportNull$$$0(17);
            }
            return rangeMarker;
        }
        TextRange oldRange = TextRange.create((Segment)old);
        TextRange union = scope.union(oldRange);
        if (old.isValid() && union.equals((Object)oldRange)) {
            RangeMarker rangeMarker = old;
            if (rangeMarker == null) {
                FileStatusMap.$$$reportNull$$$0(18);
            }
            return rangeMarker;
        }
        if (union.getEndOffset() > textLength) {
            union = union.intersection(new TextRange(0, textLength));
        }
        assert (union != null);
        RangeMarker rangeMarker = document.createRangeMarker(union);
        if (rangeMarker == null) {
            FileStatusMap.$$$reportNull$$$0(19);
        }
        return rangeMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(20);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(21);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            assert (status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull()) : status;
        }
    }

    void allowDirt(boolean allow) {
        this.myAllowDirt = allow;
    }

    private static int getThreadNum() {
        return (Integer)ConcurrencyUtil.cacheOrGet(threads, (Object)Thread.currentThread(), (Object)threads.size());
    }

    public static void log(Object ... info) {
        if (info == null) {
            FileStatusMap.$$$reportNull$$$0(22);
        }
        if (LOG.isDebugEnabled()) {
            String s = StringUtil.repeatSymbol((char)' ', (int)(FileStatusMap.getThreadNum() * 4)) + Arrays.asList(info) + "\n";
            LOG.debug(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/FileStatusMap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "combineScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyTextRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setErrorFoundFlag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wasErrorFound";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markAllFilesDirty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markFileUpToDate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileDirtyScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markFileScopeDirtyDefensively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markFileScopeDirty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "combineScopes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "allDirtyScopesAreNull";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "assertAllDirtyScopesAreNull";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileStatus {
        private boolean defensivelyMarked;
        private boolean wolfPassFinished;
        private final TIntObjectHashMap<RangeMarker> dirtyScopes;
        private boolean errorFound;

        private FileStatus(@NotNull Project project) {
            if (project == null) {
                FileStatus.$$$reportNull$$$0(0);
            }
            this.dirtyScopes = new TIntObjectHashMap();
            this.markWholeFileDirty(project);
        }

        private void markWholeFileDirty(@NotNull Project project) {
            if (project == null) {
                FileStatus.$$$reportNull$$$0(1);
            }
            this.setDirtyScope(4, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(8, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(7, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(11, WHOLE_FILE_DIRTY_MARKER);
            TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project);
            for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
                this.setDirtyScope(factory.getPassId(), WHOLE_FILE_DIRTY_MARKER);
            }
        }

        private boolean allDirtyScopesAreNull() {
            for (Object o : this.dirtyScopes.getValues()) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        private void combineScopesWith(@NotNull TextRange scope, int fileLength, @NotNull Document document) {
            if (scope == null) {
                FileStatus.$$$reportNull$$$0(2);
            }
            if (document == null) {
                FileStatus.$$$reportNull$$$0(3);
            }
            this.dirtyScopes.transformValues(oldScope -> {
                RangeMarker newScope;
                if (scope == null) {
                    FileStatus.$$$reportNull$$$0(4);
                }
                if (document == null) {
                    FileStatus.$$$reportNull$$$0(5);
                }
                if ((newScope = FileStatusMap.combineScopes(oldScope, scope, fileLength, document)) != oldScope && oldScope != null) {
                    oldScope.dispose();
                }
                return newScope;
            });
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("defensivelyMarked = ").append(this.defensivelyMarked);
            s.append("; wolfPassFinfished = ").append(this.wolfPassFinished);
            s.append("; errorFound = ").append(this.errorFound);
            s.append("; dirtyScopes: (");
            this.dirtyScopes.forEachEntry((passId, rangeMarker) -> {
                s.append(" pass: ").append(passId).append(" -> ").append((Object)(rangeMarker == WHOLE_FILE_DIRTY_MARKER ? "Whole file" : rangeMarker)).append(";");
                return true;
            });
            s.append(")");
            return s.toString();
        }

        private void setDirtyScope(int passId, RangeMarker scope) {
            RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
            if (marker != scope) {
                if (marker != null) {
                    marker.dispose();
                }
                this.dirtyScopes.put(passId, (Object)scope);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markWholeFileDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "combineScopesWith";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$combineScopesWith$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

