/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.rmi.PortableRemoteObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance(RemoteProcessSupport.class);
    private final Class<EntryPoint> myValueClass;
    private final HashMap<Pair<Target, Parameters>, Info> myProcMap;

    public RemoteProcessSupport(@NotNull Class<EntryPoint> valueClass) {
        if (valueClass == null) {
            RemoteProcessSupport.$$$reportNull$$$0(0);
        }
        this.myProcMap = new HashMap();
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(@NotNull Target var1);

    protected void logText(@NotNull Parameters configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RemoteProcessSupport.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            RemoteProcessSupport.$$$reportNull$$$0(3);
        }
        String text = StringUtil.notNullize((String)event.getText());
        if (outputType == ProcessOutputTypes.STDERR) {
            LOG.warn(text.trim());
        } else {
            LOG.debug(text.trim());
        }
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Info o : this.myProcMap.values()) {
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            return;
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            if (wait) {
                for (Info o : infos) {
                    o.handler.waitFor();
                }
            }
        });
        if (wait) {
            try {
                future2.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (java.util.concurrent.ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target2) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(4);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target2) continue;
                result2.add(pair.second);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            return new HashSet<Pair<Target, Parameters>>(this.myProcMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target2, @NotNull Parameters configuration) throws Exception {
        RunningInfo info;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(6);
        }
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Ref ref = Ref.create(null);
        Pair key = Pair.create(target2, configuration);
        if (!this.getExistingInfo((Ref<RunningInfo>)ref, key)) {
            this.startProcess(target2, configuration, key);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            ProgressManager.checkCanceled();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ProgressManager.checkCanceled();
                }
            }
        }
        if ((info = (RunningInfo)ref.get()) instanceof FailedInfo) {
            FailedInfo o = (FailedInfo)info;
            String message = o.cause != null && StringUtil.isEmptyOrSpaces((String)o.stderr) ? o.cause.getMessage() : o.stderr;
            throw new ExecutionException(message, o.cause);
        }
        if (info == null || info.handler == null) {
            throw new ExecutionException("Unable to acquire remote proxy for: " + this.getName(target2));
        }
        return this.acquire(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> release(@NotNull Target target2, @Nullable Parameters configuration) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(7);
        }
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> key : this.myProcMap.keySet()) {
                if (key.first != target2 || configuration != null && key.second != configuration) continue;
                Info o = this.myProcMap.get(key);
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            FixedFuture fixedFuture = new FixedFuture(null);
            if (fixedFuture == null) {
                RemoteProcessSupport.$$$reportNull$$$0(8);
            }
            return fixedFuture;
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            this.fireModificationCountChanged();
            for (Info o : infos) {
                o.handler.waitFor();
            }
        });
        if (future2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(9);
        }
        return future2;
    }

    private static void destroyProcessesImpl(@NotNull List<Info> infos) {
        if (infos == null) {
            RemoteProcessSupport.$$$reportNull$$$0(10);
        }
        for (Info o : infos) {
            LOG.info("Terminating: " + o);
            o.handler.destroyProcess();
        }
    }

    private void startProcess(@NotNull Target target2, @NotNull Parameters configuration, @NotNull Pair<Target, Parameters> key) {
        ProcessHandler processHandler2;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(12);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(13);
        }
        DefaultProgramRunner runner = new DefaultProgramRunner(){

            @NotNull
            public String getRunnerId() {
                if ("MyRunner" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "MyRunner";
            }

            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (profile2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/rmi/RemoteProcessSupport$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRunnerId";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "canRun";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            RunProfileState state = this.getRunProfileState(target2, configuration, executor);
            ExecutionResult result2 = state.execute(executor, (ProgramRunner)runner);
            processHandler2 = result2.getProcessHandler();
        }
        catch (Throwable e) {
            this.dropProcessInfo(key, e, null);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(@NotNull Target var1, @NotNull Parameters var2, @NotNull Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key) {
        Info info;
        if (ref == null) {
            RemoteProcessSupport.$$$reportNull$$$0(14);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(15);
        }
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            try {
                while (info != null && (!(info instanceof RunningInfo) || info.handler.isProcessTerminating() || info.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info instanceof RunningInfo) {
            hashMap = ref;
            synchronized (hashMap) {
                ref.set((Object)((RunningInfo)info));
                ref.notifyAll();
            }
        }
        return info != null;
    }

    private EntryPoint acquire(RunningInfo port) throws Exception {
        Object result2;
        port.entryPointHardRef = result2 = RemoteUtil.executeWithClassLoader(() -> {
            Registry registry = LocateRegistry.getRegistry(RemoteProcessSupport.getLocalHost(), port.port);
            Remote remote = (Remote)ObjectUtils.assertNotNull((Object)registry.lookup(port.name));
            if (Remote.class.isAssignableFrom(this.myValueClass)) {
                EntryPoint entryPoint = RemoteProcessSupport.narrowImpl(remote, this.myValueClass);
                if (entryPoint == null) {
                    return null;
                }
                return RemoteUtil.substituteClassLoader(entryPoint, (ClassLoader)this.myValueClass.getClassLoader());
            }
            return RemoteUtil.castToLocal((Object)remote, this.myValueClass);
        }, (ClassLoader)this.getClass().getClassLoader());
        return (EntryPoint)result2;
    }

    @Nullable
    private static <T> T narrowImpl(@Nullable Remote remote, @NotNull Class<T> to) {
        if (to == null) {
            RemoteProcessSupport.$$$reportNull$$$0(16);
        }
        return (T)(to.isInstance(remote) ? remote : PortableRemoteObject.narrow((Object)remote, to));
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(17);
        }
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                HashMap hashMap = RemoteProcessSupport.this.myProcMap;
                synchronized (hashMap) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                PendingInfo info;
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(4);
                }
                String text = StringUtil.notNullize((String)event.getText());
                RemoteProcessSupport.this.logText(key.second, event, outputType);
                RunningInfo result2 = null;
                Ref<RunningInfo> ref = RemoteProcessSupport.this.myProcMap;
                synchronized (ref) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix = "Port/ID:";
                            if (text.startsWith(prefix)) {
                                String pair = text.substring(prefix.length()).trim();
                                int idx = pair.indexOf("/");
                                result2 = new RunningInfo(info.handler, Integer.parseInt(pair.substring(0, idx)), pair.substring(idx + 1));
                                RemoteProcessSupport.this.myProcMap.put(key, result2);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(text);
                        }
                    } else {
                        info = null;
                    }
                }
                if (result2 != null) {
                    ref = info.ref;
                    synchronized (ref) {
                        info.ref.set(result2);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        RemoteDeadHand.TwoMinutesTurkish.startCooking((String)RemoteProcessSupport.getLocalHost(), (int)result2.port);
                    }
                    catch (Throwable e) {
                        LOG.warn("The cook failed to start due to " + ExceptionUtil.getRootCause((Throwable)e));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static String getLocalHost() {
        String string = (String)ObjectUtils.notNull((Object)System.getProperty("java.rmi.server.hostname"), (Object)"127.0.0.1");
        if (string == null) {
            RemoteProcessSupport.$$$reportNull$$$0(18);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key, @Nullable Throwable error, @Nullable ProcessHandler handler2) {
        Info info;
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            if (info != null && (handler2 == null || info.handler == handler2)) {
                this.myProcMap.remove(key);
                this.myProcMap.notifyAll();
            } else {
                info = null;
            }
        }
        if (info instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info;
            if (error != null || pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull()) {
                pendingInfo.ref.set((Object)new FailedInfo(error, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info != null;
    }

    static {
        RemoteServer.setupRMI();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "release";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcessesImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExistingInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "narrowImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FailedInfo
    extends RunningInfo {
        final Throwable cause;
        final String stderr;

        FailedInfo(Throwable cause, String stderr) {
            super(null, -1, null);
            this.cause = cause;
            this.stderr = stderr;
        }

        @Override
        public String toString() {
            return "FailedInfo{" + this.cause + '}';
        }
    }

    private static class RunningInfo
    extends Info {
        final int port;
        final String name;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler2, int port, String name) {
            super(handler2);
            this.port = port;
            this.name = name;
        }

        public String toString() {
            return this.port + "/" + this.name;
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler2) {
            super(handler2);
            this.ref = ref;
        }

        public String toString() {
            return "PendingInfo{" + this.ref.get() + '}';
        }
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler2) {
            this.handler = handler2;
        }
    }
}

