/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.openapi.util.ModificationTracker;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/utils/DelayModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "delay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "myDelay", "myStamp", "getModificationCount", "intellij.platform.ide.impl"})
final class DelayModificationTracker
implements ModificationTracker {
    private final long myStamp;
    private final long myDelay;

    public long getModificationCount() {
        long diff = System.currentTimeMillis() - (this.myStamp + this.myDelay);
        return diff > 0L ? diff : 0L;
    }

    public DelayModificationTracker(long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.myStamp = System.currentTimeMillis();
        this.myDelay = TimeUnit.MILLISECONDS.convert(delay, unit);
    }
}

