/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.wpad;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.wpad.dhcp.DHCPMessage;
import com.github.markusbernhardt.proxy.search.wpad.dhcp.DHCPSocket;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;

public class WpadProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        try {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Using WPAD to find a proxy", new Object[0]);
            String pacScriptUrl = this.detectScriptUrlPerDHCP();
            if (pacScriptUrl == null) {
                pacScriptUrl = this.detectScriptUrlPerDNS();
            }
            if (pacScriptUrl == null) {
                return null;
            }
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "PAC script url found: {0}", pacScriptUrl);
            return ProxyUtil.buildPacSelectorForUrl(pacScriptUrl);
        }
        catch (IOException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Error during WPAD search.", e);
            throw new ProxyException(e);
        }
    }

    @Override
    public String getName() {
        return "wpad";
    }

    public Properties readSettings() {
        try {
            String pacScriptUrl = this.detectScriptUrlPerDHCP();
            if (pacScriptUrl == null) {
                pacScriptUrl = this.detectScriptUrlPerDNS();
            }
            if (pacScriptUrl == null) {
                return null;
            }
            Properties result = new Properties();
            result.setProperty("url", pacScriptUrl);
            return result;
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    private String detectScriptUrlPerDNS() throws IOException {
        String fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        if (fqdn.equalsIgnoreCase("localhost") || fqdn.length() == 0 || Character.isDigit(fqdn.charAt(0))) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching per DNS guessing.", new Object[0]);
        String[] fqdnParts = fqdn.split("\\.");
        for (int i = 0; i < fqdnParts.length; ++i) {
            if (i == fqdnParts.length - 2) continue;
            StringBuilder stringBuilder = new StringBuilder("http://wpad");
            for (int j = i + 1; j < fqdnParts.length; ++j) {
                stringBuilder.append('.');
                stringBuilder.append(fqdnParts[j]);
            }
            stringBuilder.append("/wpad.dat");
            try {
                URL lookupURL = new URL(stringBuilder.toString());
                Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Trying url: {0}", lookupURL);
                HttpURLConnection con = (HttpURLConnection)lookupURL.openConnection(Proxy.NO_PROXY);
                con.setInstanceFollowRedirects(true);
                con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig");
                if (con.getResponseCode() == 200) {
                    return lookupURL.toString();
                }
                con.disconnect();
                continue;
            }
            catch (UnknownHostException e) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Not available!", new Object[0]);
            }
        }
        return null;
    }

    private String detectScriptUrlPerDHCP() throws IOException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Searching per DHCP.", new Object[0]);
        String url = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                if (network.getName().equals("lo")) continue;
                byte[] mac = network.getHardwareAddress();
                Enumeration<InetAddress> ips = network.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip.getAddress().length == 4) {
                        url = this.checkDhcpAckForPAC(ip, mac);
                    }
                    if (url == null) continue;
                    return url;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return url;
    }

    private String getMacString(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < 5 ? ":" : ""));
        }
        return sb.toString();
    }

    private String checkDhcpAckForPAC(InetAddress ip, byte[] mac) throws IOException {
        DHCPMessage messageOut = new DHCPMessage(67);
        DHCPMessage messageIn = new DHCPMessage(68);
        DHCPSocket bindSocket = new DHCPSocket(68, ip);
        messageOut.setOp((byte)1);
        messageOut.setCiaddr(ip.getAddress());
        byte[] addr = new byte[16];
        if (mac != null) {
            for (int i = 0; i < 6; ++i) {
                addr[i] = mac[i];
            }
        }
        messageOut.setHtype((byte)1);
        messageOut.setHlen((byte)6);
        messageOut.setChaddr(addr);
        messageOut.setFlags((short)0);
        messageOut.setHops((byte)0);
        messageOut.setXid(new Random().nextInt());
        messageOut.setSecs((short)0);
        messageOut.setYiaddr(InetAddress.getByName("0.0.0.0").getAddress());
        messageOut.setSiaddr(InetAddress.getByName("0.0.0.0").getAddress());
        messageOut.setGiaddr(InetAddress.getByName("0.0.0.0").getAddress());
        messageOut.setOption(53, new byte[]{8});
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Trying DHCPInform on " + ip.getHostAddress() + (mac != null ? " @ " + this.getMacString(mac) : ""), new Object[0]);
        bindSocket.send(messageOut);
        boolean sentinal = true;
        while (sentinal) {
            if (bindSocket.receive(messageIn)) {
                if (messageOut.getXid() == messageIn.getXid()) {
                    byte[] pacFileLocationRaw = messageIn.getOption(252);
                    String pacFileLocation = null;
                    if (pacFileLocationRaw != null) {
                        pacFileLocation = new String(pacFileLocationRaw);
                    }
                    bindSocket.close();
                    return pacFileLocation;
                }
                bindSocket.send(messageOut);
                continue;
            }
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Timed out.", new Object[0]);
            sentinal = false;
        }
        bindSocket.close();
        return null;
    }
}

