/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTooManyParametersInspection
extends PhpInspection {
    public static final String MESSAGE = PhpBundle.message("inspection.too.many.parameters", new Object[0]);
    private static final int DEFAULT_BRANCH_LIMIT = 5;
    public int limit = 5;
    public boolean ignoreConstructors = true;

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        SingleIntegerFieldOptionsPanel valueField = new SingleIntegerFieldOptionsPanel(PhpBundle.message("inspection.too.many.parameters.max.number.of.parameters", new Object[0]), (InspectionProfileEntry)this, "limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        panel.add((Component)valueField, constraints);
        CheckBox constructorsCheckBox = new CheckBox(PhpBundle.message("inspection.too.many.parameters.ignore.constructors", new Object[0]), (InspectionProfileEntry)this, "ignoreConstructors");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        panel.add((Component)constructorsCheckBox, constraints);
        return panel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTooManyParametersInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                if (function instanceof Method) {
                    return;
                }
                if (function.getParameters().length > PhpTooManyParametersInspection.this.limit) {
                    PsiElement firstChild;
                    PsiElement nameIdentifier = function.getNameIdentifier();
                    if (nameIdentifier != null) {
                        holder.registerProblem(nameIdentifier, MESSAGE, new LocalQuickFix[0]);
                    } else if (function.isClosure() && (firstChild = function.getFirstChild()) != null && firstChild.getContainingFile() == holder.getFile()) {
                        holder.registerProblem(firstChild, MESSAGE, new LocalQuickFix[0]);
                    }
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                Method[] methods;
                for (Method it : methods = clazz.getOwnMethods()) {
                    PhpTooManyParametersInspection.this.processMethod(it, holder);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpTooManyParametersInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void processMethod(Method method, ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (this.ignoreConstructors && PhpRefactoringUtil.isElementConstructor((PsiElement)method)) {
            return;
        }
        if (method.getParameters().length > this.limit && (nameIdentifier = method.getNameIdentifier()) != null) {
            holder.registerProblem(nameIdentifier, MESSAGE, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpTooManyParametersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpTooManyParametersInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

