/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedClassInspection
extends PhpInspection {
    public boolean DONT_REPORT_MULTI_RESOLVE = false;
    public boolean DONT_INSPECT_DOCS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                PsiElement identifier = clazz.getNameIdentifier();
                if (PhpUndefinedClassInspection.this.isDontReportMultiResolve() || identifier == null) {
                    return;
                }
                String fqn = clazz.getFQN();
                Collection classes = PhpIndex.getInstance((Project)clazz.getProject()).getAnyByFQN(fqn);
                HashMap<VirtualFile, String> paths = new HashMap<VirtualFile, String>();
                int count = 0;
                for (PhpClass aClass : classes) {
                    if (clazz.equals(aClass) || clazz.getContainingFile().equals(aClass.getContainingFile())) continue;
                    if (!isOnTheFly) {
                        holder.registerProblem(identifier, "Other declaration of class #ref exist", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                        break;
                    }
                    VirtualFile file = aClass.getContainingFile().getVirtualFile();
                    assert (file != null);
                    if (paths.get(file) != null) continue;
                    ++count;
                    if (paths.size() >= 5) continue;
                    String relativePath = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(clazz.getProject(), file);
                    paths.put(file, relativePath);
                }
                if (paths.size() > 0) {
                    holder.registerProblem(identifier, "Other declaration of class #ref exist at " + StringUtil.join(paths.values(), (String)", ") + (paths.size() < count ? " and " + (count - paths.size()) + " other" : ""), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            public void visitPhpDocType(PhpDocType type) {
                if (PhpUndefinedClassInspection.this.isInspectDocs()) {
                    return;
                }
                ASTNode nameNode = type.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = type.getName();
                assert (name != null);
                if (StringUtil.startsWithChar((CharSequence)(name = StringUtil.trimEnd((String)name, (String)"[]")), (char)'$') || PhpType.isPrimitiveType((String)name)) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                ResolveResult[] results = ((PsiPolyVariantReference)type.getReference()).multiResolve(false);
                if (results.length == 0) {
                    holder.registerProblem(anchor, "Undefined class #ref", PhpUndefinedClassInspection.getUndefinedClassFixes((PhpReference)type, isOnTheFly));
                } else if (!name.equalsIgnoreCase("self") && !PhpUndefinedClassInspection.this.isDontReportMultiResolve() && results.length > 1) {
                    holder.registerProblem(anchor, "Multiple definitions exist for class #ref", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            public void visitPhpClassReference(ClassReference reference) {
                ResolveResult[] results;
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                String name = reference.getName();
                assert (name != null);
                if (StringUtil.startsWithChar((CharSequence)name, (char)'$')) {
                    return;
                }
                PsiElement parent = reference.getParent();
                Project project = reference.getProject();
                if (parent instanceof Parameter && PhpLangUtil.isParameterTypeHint(name, project) || parent instanceof PhpReturnType && PhpLangUtil.isReturnTypeHint(name, project) || PhpType.isPrimitiveType((String)name) && PhpPsiUtil.getParentByCondition((PsiElement)reference, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null) {
                    return;
                }
                PsiElement anchor = nameNode.getPsi();
                if (parent instanceof PhpUse) {
                    String fqn = reference.getFQN();
                    if (PhpIndex.getInstance((Project)project).getChildNamespacesByParentName(fqn + "\\").size() > 0) {
                        return;
                    }
                    if (PhpIndex.getInstance((Project)project).getNamespacesByName(fqn).size() > 0) {
                        return;
                    }
                }
                if ((results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false)).length == 0) {
                    holder.registerProblem(anchor, "Undefined class #ref", PhpUndefinedClassInspection.getUndefinedClassFixes((PhpReference)reference, isOnTheFly));
                } else if (!name.equalsIgnoreCase("self") && !PhpUndefinedClassInspection.this.isDontReportMultiResolve() && results.length > 1) {
                    holder.registerProblem(anchor, "Multiple definitions exist for class #ref", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Undefined class inspection" == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(2);
        }
        return "Undefined class inspection";
    }

    public boolean isDontReportMultiResolve() {
        return this.DONT_REPORT_MULTI_RESOLVE;
    }

    public boolean isInspectDocs() {
        return this.DONT_INSPECT_DOCS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @NotNull
    private static LocalQuickFix[] getUndefinedClassFixes(@NotNull PhpReference reference, boolean isOnTheFly) {
        if (reference == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(3);
        }
        ArrayList<PhpQuickFixBase> fixes = new ArrayList<PhpQuickFixBase>();
        Collection<PhpClass> candidates = PhpImportClassQuickFix.INSTANCE.getCandidates(reference.getProject(), reference);
        if (candidates.size() > 0 && (isOnTheFly || candidates.size() == 1)) {
            fixes.add(PhpImportClassQuickFix.INSTANCE);
        }
        if (isOnTheFly && candidates.size() == 0 && (!PhpCreateClassQuickFix.isClassReferenceToTrait(reference) || PhpProjectConfigurationFacade.getInstance(reference.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.TRAITS))) {
            fixes.add(new PhpCreateClassQuickFix());
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedClassFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedClassFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myDontReportMultiResolve;
        private JCheckBox myDontInspectDocs;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDontReportMultiResolve.setSelected(PhpUndefinedClassInspection.this.DONT_REPORT_MULTI_RESOLVE);
            this.myDontInspectDocs.setSelected(PhpUndefinedClassInspection.this.DONT_INSPECT_DOCS);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedClassInspection.this.DONT_REPORT_MULTI_RESOLVE = OptionsPanel.this.myDontReportMultiResolve.isSelected();
                    PhpUndefinedClassInspection.this.DONT_INSPECT_DOCS = OptionsPanel.this.myDontInspectDocs.isSelected();
                }
            };
            this.myDontReportMultiResolve.getModel().addChangeListener(listener);
            this.myDontInspectDocs.getModel().addChangeListener(listener);
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myDontReportMultiResolve = jCheckBox2 = new JCheckBox();
            jCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.class.dont.report.multiresolve"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDontInspectDocs = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.class.ignore.phpdoc"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

