/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.Nullable;

public class PhpVcsSelectionProvider
implements VcsSelectionProvider {
    @Nullable
    public VcsSelection getSelection(VcsContext context) {
        String actionName;
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)2);
        if (psiElement == null) {
            return null;
        }
        if (!psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof PhpClass) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.class", (Object[])new Object[0]);
        } else if (psiElement instanceof Field) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.field", (Object[])new Object[0]);
        } else if (psiElement instanceof Method) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.method", (Object[])new Object[0]);
        } else if (psiElement instanceof Function) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.function", (Object[])new Object[0]);
        } else if (psiElement instanceof GroupStatement) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.code.block", (Object[])new Object[0]);
        } else if (psiElement instanceof Statement) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.statement", (Object[])new Object[0]);
        } else {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        return new VcsSelection(document, textRange, actionName);
    }
}

