/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssAnimationDelay;
import org.w3c.css.properties.css3.CssAnimationDirection;
import org.w3c.css.properties.css3.CssAnimationDuration;
import org.w3c.css.properties.css3.CssAnimationFillMode;
import org.w3c.css.properties.css3.CssAnimationIterationCount;
import org.w3c.css.properties.css3.CssAnimationName;
import org.w3c.css.properties.css3.CssAnimationTimingFunction;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssAnimation
extends org.w3c.css.properties.css.CssAnimation {
    CssAnimationName cssAnimationName = null;
    CssAnimationDuration cssAnimationDuration = null;
    CssAnimationTimingFunction cssAnimationTimingFunction = null;
    CssAnimationDelay cssAnimationDelay = null;
    CssAnimationDirection cssAnimationDirection = null;
    CssAnimationFillMode cssAnimationFillMode = null;
    CssAnimationIterationCount cssAnimationIterationCount = null;

    public CssAnimation() {
        this.value = initial;
        this.cssAnimationDelay = new CssAnimationDelay();
        this.cssAnimationDuration = new CssAnimationDuration();
        this.cssAnimationName = new CssAnimationName();
        this.cssAnimationTimingFunction = new CssAnimationTimingFunction();
        this.cssAnimationIterationCount = new CssAnimationIterationCount();
        this.cssAnimationFillMode = new CssAnimationFillMode();
        this.cssAnimationDirection = new CssAnimationDirection();
    }

    public CssAnimation(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssExpression single_layer = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (single_layer == null) {
                single_layer = new CssExpression();
            }
            single_layer.addValue(val);
            single_layer.setOperator(op);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                single_layer.setOperator(' ');
                values.add(this.checkLayer(ac, single_layer, this));
                single_layer = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (single_layer != null) {
            values.add(this.checkLayer(ac, single_layer, this));
        }
        if (values.size() == 1) {
            this.value = (CssValue)values.get(0);
            CssAnimationValue v = (CssAnimationValue)this.value;
            if (v.delay != null) {
                this.cssAnimationDelay = new CssAnimationDelay();
                this.cssAnimationDelay.value = v.delay;
            }
            if (v.duration != null) {
                this.cssAnimationDuration = new CssAnimationDuration();
                this.cssAnimationDuration.value = v.duration;
            }
            if (v.name != null) {
                this.cssAnimationName = new CssAnimationName();
                this.cssAnimationName.value = v.name;
            }
            if (v.itercount != null) {
                this.cssAnimationIterationCount = new CssAnimationIterationCount();
                this.cssAnimationIterationCount.value = v.itercount;
            }
            if (v.timingfunc != null) {
                this.cssAnimationTimingFunction = new CssAnimationTimingFunction();
                this.cssAnimationTimingFunction.value = v.timingfunc;
            }
            if (v.direction != null) {
                this.cssAnimationDirection = new CssAnimationDirection();
                this.cssAnimationDirection.value = v.direction;
            }
            if (v.fillmode != null) {
                this.cssAnimationFillMode = new CssAnimationFillMode();
                this.cssAnimationFillMode.value = v.fillmode;
            }
        } else {
            this.value = new CssLayerList(values);
        }
    }

    public CssAnimation(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        if (this.cssAnimationDelay != null) {
            this.cssAnimationDelay.addToStyle(ac, style);
        }
        if (this.cssAnimationDuration != null) {
            this.cssAnimationDuration.addToStyle(ac, style);
        }
        if (this.cssAnimationName != null) {
            this.cssAnimationName.addToStyle(ac, style);
        }
        if (this.cssAnimationTimingFunction != null) {
            this.cssAnimationTimingFunction.addToStyle(ac, style);
        }
        if (this.cssAnimationIterationCount != null) {
            this.cssAnimationIterationCount.addToStyle(ac, style);
        }
        if (this.cssAnimationDirection != null) {
            this.cssAnimationDirection.addToStyle(ac, style);
        }
        if (this.cssAnimationFillMode != null) {
            this.cssAnimationFillMode.addToStyle(ac, style);
        }
    }

    private CssAnimationValue checkLayer(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        CssAnimationValue v = new CssAnimationValue();
        if (expression.getCount() > 7) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 5: {
                    if (v.itercount == null) {
                        CssCheckableValue num = val.getCheckableValue();
                        num.checkPositiveness(ac, this);
                        v.itercount = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 8: {
                    if (v.duration == null) {
                        CssCheckableValue t = val.getCheckableValue();
                        t.warnPositiveness(ac, this);
                        v.duration = val;
                        break;
                    }
                    if (v.delay == null) {
                        v.delay = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 12: {
                    if (v.timingfunc == null) {
                        CssAnimationTimingFunction.parseFunctionValues(ac, val, this);
                        v.timingfunc = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 0: {
                    CssIdent match;
                    CssIdent ident = (CssIdent)val;
                    if (inherit.equals(ident)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        v.name = inherit;
                        break;
                    }
                    if (v.timingfunc == null && (match = CssAnimationTimingFunction.getAllowedIdent(ident)) != null) {
                        v.timingfunc = match;
                        break;
                    }
                    if (v.direction == null && (match = CssAnimationDirection.getAllowedIdent(ident)) != null) {
                        v.direction = match;
                        break;
                    }
                    if (v.fillmode == null && (match = CssAnimationFillMode.getAllowedIdent(ident)) != null) {
                        v.fillmode = match;
                        break;
                    }
                    if (v.itercount == null && (match = CssAnimationIterationCount.getAllowedIdent(ident)) != null) {
                        v.itercount = match;
                        break;
                    }
                    if (v.name == null) {
                        v.name = CssAnimationName.getAllowedIdent(ac, ident);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
        }
        return v;
    }

    private class CssAnimationValue
    extends CssValueList {
        CssValue delay = null;
        CssValue duration = null;
        CssValue name = null;
        CssValue timingfunc = null;
        CssValue itercount = null;
        CssValue direction = null;
        CssValue fillmode = null;

        private CssAnimationValue() {
        }

        @Override
        public String toString() {
            boolean doneFirst = false;
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name);
                doneFirst = true;
            }
            if (this.duration != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.duration);
                doneFirst = true;
                if (this.delay != null) {
                    sb.append(' ').append(this.delay);
                }
            }
            if (this.timingfunc != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.timingfunc);
            }
            if (this.itercount != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.itercount);
            }
            if (this.direction != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.direction);
            }
            if (this.fillmode != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.fillmode);
            }
            return sb.toString();
        }
    }
}

