/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssBorderBottomLeftRadius;
import org.w3c.css.properties.css3.CssBorderBottomRightRadius;
import org.w3c.css.properties.css3.CssBorderTopLeftRadius;
import org.w3c.css.properties.css3.CssBorderTopRightRadius;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorderRadius
extends org.w3c.css.properties.css.CssBorderRadius {
    public CssBorderRadius() {
        this.value = initial;
        this.topLeft = new CssBorderTopLeftRadius();
        this.topRight = new CssBorderTopRightRadius();
        this.bottomLeft = new CssBorderBottomLeftRadius();
        this.bottomRight = new CssBorderBottomRightRadius();
    }

    public CssBorderRadius(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 9) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean switched = false;
        ArrayList<CssValue> h_radius = new ArrayList<CssValue>();
        ArrayList v_radius = new ArrayList();
        ArrayList<CssValue> cur_radius = h_radius;
        while (!expression.end() && h_radius.size() < 4 && v_radius.size() < 4) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, this);
                    cur_radius.add(val);
                    break;
                }
                case 4: 
                case 6: {
                    CssCheckableValue length = val.getCheckableValue();
                    length.checkPositiveness(ac, this);
                    cur_radius.add(val);
                    break;
                }
                case 15: {
                    if (switched) {
                        throw new InvalidParamException("operator", val.toString(), ac);
                    }
                    switched = true;
                    cur_radius = v_radius;
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        cur_radius.add(inherit);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("unrecognize", ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (v_radius.size() == 0) {
            this.value = new CssValueList(h_radius);
        } else {
            CssValueList vlist = new CssValueList();
            for (CssValue h : h_radius) {
                vlist.add(h);
            }
            vlist.add(new CssSwitch());
            for (CssValue v : v_radius) {
                vlist.add(v);
            }
            this.value = vlist;
        }
        this.topLeft = new CssBorderTopLeftRadius();
        this.topRight = new CssBorderTopRightRadius();
        this.bottomLeft = new CssBorderBottomLeftRadius();
        this.bottomRight = new CssBorderBottomRightRadius();
        switch (h_radius.size()) {
            case 1: {
                this.bottomLeft.h_radius = this.bottomRight.h_radius = h_radius.get(0);
                this.topRight.h_radius = this.bottomRight.h_radius;
                this.topLeft.h_radius = this.bottomRight.h_radius;
                break;
            }
            case 2: {
                this.topLeft.h_radius = this.bottomRight.h_radius = h_radius.get(0);
                this.topRight.h_radius = this.bottomLeft.h_radius = h_radius.get(1);
                break;
            }
            case 3: {
                this.topLeft.h_radius = h_radius.get(0);
                this.topRight.h_radius = this.bottomLeft.h_radius = h_radius.get(1);
                this.bottomRight.h_radius = h_radius.get(2);
                break;
            }
            case 4: {
                this.topLeft.h_radius = h_radius.get(0);
                this.topRight.h_radius = h_radius.get(1);
                this.bottomRight.h_radius = h_radius.get(2);
                this.bottomLeft.h_radius = h_radius.get(3);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        switch (v_radius.size()) {
            case 0: {
                this.bottomLeft.v_radius = this.bottomRight.v_radius = h_radius.get(0);
                this.topRight.v_radius = this.bottomRight.v_radius;
                this.topLeft.v_radius = this.bottomRight.v_radius;
                break;
            }
            case 1: {
                this.bottomLeft.v_radius = this.bottomRight.v_radius = (CssValue)v_radius.get(0);
                this.topRight.v_radius = this.bottomRight.v_radius;
                this.topLeft.v_radius = this.bottomRight.v_radius;
                break;
            }
            case 2: {
                this.topLeft.v_radius = this.bottomRight.v_radius = (CssValue)v_radius.get(0);
                this.topRight.v_radius = this.bottomLeft.v_radius = (CssValue)v_radius.get(1);
                break;
            }
            case 3: {
                this.topLeft.v_radius = (CssValue)v_radius.get(0);
                this.topRight.v_radius = this.bottomLeft.v_radius = (CssValue)v_radius.get(1);
                this.bottomRight.v_radius = (CssValue)v_radius.get(2);
                break;
            }
            case 4: {
                this.topLeft.v_radius = (CssValue)v_radius.get(0);
                this.topRight.v_radius = (CssValue)v_radius.get(1);
                this.bottomRight.v_radius = (CssValue)v_radius.get(2);
                this.bottomLeft.v_radius = (CssValue)v_radius.get(3);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        this.shorthand = true;
    }

    public CssBorderRadius(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    protected static CssValue checkBorderCornerRadius(ApplContext ac, CssProperty caller, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValueList res = new CssValueList();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                    res.add(val);
                    break;
                }
                case 4: 
                case 6: {
                    CssCheckableValue length = val.getCheckableValue();
                    length.checkPositiveness(ac, caller);
                    res.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        if (res.size() > 0) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        res.add(inherit);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("unrecognize", ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        return res.size() == 1 ? res.get(0) : res;
    }
}

