/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkDescription;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FrameworkCommandLineHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FrameworkCommandHistoryList
implements PersistentStateComponent<PersistentHistoryState> {
    static final int BUFFER_SIZE = 25;
    private LinkedList<String> myList = new LinkedList();
    private String myInitialString = null;
    private ListIterator<String> myIterator = this.myList.listIterator();
    private final Set<String> myUsedFrameworkNames = new HashSet<String>();

    private FrameworkCommandHistoryList() {
    }

    public static FrameworkCommandHistoryList getInstance(Project project) {
        return (FrameworkCommandHistoryList)ServiceManager.getService((Project)project, FrameworkCommandHistoryList.class);
    }

    public void resetIterator() {
        this.myIterator = this.myList.listIterator(this.myList.size());
    }

    public boolean needsInitialString() {
        return !this.myIterator.hasNext();
    }

    public void setInitialString(@NonNls String initialString) {
        this.myInitialString = initialString;
    }

    public void add(String e, @Nullable FrameworkDescription framework) {
        if (!this.myList.isEmpty() && e != null && e.equals(this.myList.getLast())) {
            this.resetIterator();
            return;
        }
        if (this.myList.size() == 25) {
            this.myList.removeFirst();
        }
        this.myList.addLast(e);
        this.resetIterator();
        if (framework != null) {
            if (framework.getFrameworkId() != null) {
                this.myUsedFrameworkNames.add(FrameworkUtils.getFrameworkName(framework.getFrameworkId()));
            } else {
                this.myUsedFrameworkNames.add(framework.getName());
            }
        }
    }

    public String getNext() {
        String result;
        if (this.myIterator.hasNext()) {
            this.myIterator.next();
        }
        if (this.myIterator.hasNext()) {
            result = this.myIterator.next();
            this.myIterator.previous();
        } else {
            result = this.myInitialString;
        }
        return result;
    }

    public String getPrevious() {
        if (this.myIterator.hasPrevious()) {
            return this.myIterator.previous();
        }
        if (this.myIterator.hasNext()) {
            return this.myList.getFirst();
        }
        return this.myInitialString;
    }

    public Set<String> getUsedFrameworkNames() {
        return this.myUsedFrameworkNames;
    }

    @NotNull
    public PersistentHistoryState getState() {
        PersistentHistoryState state = new PersistentHistoryState();
        state.setCommands(this.myList);
        PersistentHistoryState persistentHistoryState = state;
        if (persistentHistoryState == null) {
            FrameworkCommandHistoryList.$$$reportNull$$$0(0);
        }
        return persistentHistoryState;
    }

    public void loadState(@NotNull PersistentHistoryState state) {
        if (state == null) {
            FrameworkCommandHistoryList.$$$reportNull$$$0(1);
        }
        this.myList = state.getCommands();
        this.resetIterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkCommandHistoryList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkCommandHistoryList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PersistentHistoryState {
        private LinkedList<String> myCommands = new LinkedList();

        @XCollection(elementName="command", valueAttributeName="text", propertyElementName="commandsHistory")
        public LinkedList<String> getCommands() {
            return this.myCommands;
        }

        public void setCommands(LinkedList<String> commands) {
            this.myCommands = commands;
        }
    }
}

