/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Date;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.ConflictAction;
import org.jetbrains.idea.svn.conflict.ConflictOperation;
import org.jetbrains.idea.svn.conflict.ConflictReason;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.xml.sax.SAXException;

public class SvnInfoStructure {
    @Nullable
    public File myFile;
    public String relativeUrl;
    public Url myUrl;
    public Url myRootURL;
    public long myRevision;
    public NodeKind myKind;
    public String myUuid;
    public long myCommittedRevision;
    public String myCommittedDate;
    public String myAuthor;
    public String mySchedule;
    public Url myCopyFromURL;
    public long myCopyFromRevision;
    public String myTextTime;
    public String myPropTime;
    public String myChecksum;
    public String myConflictOld;
    public String myConflictNew;
    public String myConflictWorking;
    public String myPropRejectFile;
    public Lock.Builder myLockBuilder;
    public Depth myDepth;
    public String myChangelistName;
    public long myWcSize;
    public Date myCorrectCommittedDate;
    public Date myCorrectTextDate;
    public TreeConflictDescription myTreeConflict;

    public Info convert() throws SAXException, SvnBindException {
        return new Info(this.myFile, this.myUrl, this.myRootURL, this.myRevision, this.myKind, this.myUuid, this.myCommittedRevision, this.myCommittedDate, this.myAuthor, this.mySchedule, this.myCopyFromURL, this.myCopyFromRevision, this.myConflictOld, this.myConflictNew, this.myConflictWorking, this.myPropRejectFile, this.getLock(), this.myDepth, this.createTreeConflict());
    }

    @Nullable
    private Lock getLock() {
        return this.myLockBuilder != null ? this.myLockBuilder.build() : null;
    }

    private org.jetbrains.idea.svn.conflict.TreeConflictDescription createTreeConflict() throws SAXException, SvnBindException {
        if (this.myTreeConflict == null) {
            return null;
        }
        assert (this.myFile != null);
        return new org.jetbrains.idea.svn.conflict.TreeConflictDescription(this.myFile, this.myKind, ConflictAction.from(this.myTreeConflict.myAction), ConflictReason.from(this.myTreeConflict.myReason), ConflictOperation.from(this.myTreeConflict.myOperation), this.createVersion(this.myTreeConflict.mySourceLeft), this.createVersion(this.myTreeConflict.mySourceRight));
    }

    private org.jetbrains.idea.svn.conflict.ConflictVersion createVersion(ConflictVersion version) throws SvnBindException, SAXException {
        return version == null ? null : new org.jetbrains.idea.svn.conflict.ConflictVersion(SvnUtil.createUrl(version.myRepoUrl), version.myPathInRepo, this.parseRevision(version.myRevision), NodeKind.from(StringUtil.notNullize((String)version.myKind)));
    }

    private long parseRevision(String revision) throws SAXException {
        try {
            return Long.parseLong(revision);
        }
        catch (NumberFormatException e) {
            throw new SAXException(e);
        }
    }

    public static class ConflictVersion {
        public String myKind;
        public String myPathInRepo;
        public String myRepoUrl;
        public String myRevision;
    }

    public static class TreeConflictDescription {
        public String myOperation;
        public String myKind;
        public String myReason;
        public String myVictim;
        public String myAction;
        public ConflictVersion mySourceLeft;
        public ConflictVersion mySourceRight;
    }
}

