/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.ActBarField;
import net.sf.mpxj.fasttrack.ActivityField;
import net.sf.mpxj.fasttrack.BlockHeader;
import net.sf.mpxj.fasttrack.FastTrackColumn;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.ResourceField;

abstract class AbstractColumn
implements FastTrackColumn {
    private BlockHeader m_header;
    private byte[] m_trailer;
    private FastTrackField m_type;
    protected Object[] m_data;

    AbstractColumn() {
    }

    @Override
    public void read(FastTrackTableType fastTrackTableType, byte[] byArray, int n, int n2) {
        this.m_header = new BlockHeader().read(byArray, n, this.postHeaderSkipBytes());
        this.setFieldType(fastTrackTableType);
        int n3 = this.readData(byArray, this.m_header.getOffset());
        if (n2 > n3) {
            this.m_trailer = new byte[n2 - n3];
            System.arraycopy(byArray, n + n3, this.m_trailer, 0, this.m_trailer.length);
        } else {
            this.m_trailer = new byte[0];
        }
    }

    protected abstract int postHeaderSkipBytes();

    protected abstract int readData(byte[] var1, int var2);

    protected abstract void dumpData(PrintWriter var1);

    @Override
    public String getName() {
        return this.m_header == null ? "<unknown>" : this.m_header.getName();
    }

    @Override
    public FastTrackField getType() {
        return this.m_type;
    }

    @Override
    public Object[] getData() {
        return this.m_data;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("[" + this.getClass().getSimpleName());
        printWriter.println(this.m_header.toString());
        this.dumpData(printWriter);
        printWriter.print("  Trailer: " + FastTrackUtility.hexdump(this.m_trailer, 0, this.m_trailer.length, false, 16, ""));
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    private void setFieldType(FastTrackTableType fastTrackTableType) {
        switch (fastTrackTableType) {
            case ACTBARS: {
                this.m_type = ActBarField.getInstance(this.m_header.getColumnType());
                break;
            }
            case ACTIVITIES: {
                this.m_type = ActivityField.getInstance(this.m_header.getColumnType());
                break;
            }
            case RESOURCES: {
                this.m_type = ResourceField.getInstance(this.m_header.getColumnType());
            }
        }
    }
}

