/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffActionExecutor {
    protected final DiffProvider myDiffProvider;
    protected final VirtualFile mySelectedFile;
    protected final Project myProject;
    private final Integer mySelectedLine;

    protected DiffActionExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
        if (diffProvider == null) {
            DiffActionExecutor.$$$reportNull$$$0(0);
        }
        if (selectedFile == null) {
            DiffActionExecutor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DiffActionExecutor.$$$reportNull$$$0(2);
        }
        this.myDiffProvider = diffProvider;
        this.mySelectedFile = selectedFile;
        this.myProject = project;
        this.mySelectedLine = this.getSelectedLine(project, this.mySelectedFile, editor);
    }

    @Nullable
    private Integer getSelectedLine(@NotNull Project project, @NotNull VirtualFile file2, @Nullable Editor contextEditor) {
        FileEditor fileEditor;
        VirtualFile contextFile;
        if (project == null) {
            DiffActionExecutor.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DiffActionExecutor.$$$reportNull$$$0(4);
        }
        Editor editor = null;
        if (contextEditor != null && Comparing.equal((Object)(contextFile = FileDocumentManager.getInstance().getFile(contextEditor.getDocument())), (Object)this.mySelectedFile)) {
            editor = contextEditor;
        }
        if (editor == null && (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(this.mySelectedFile)) instanceof TextEditor) {
            editor = ((TextEditor)fileEditor).getEditor();
        }
        if (editor == null) {
            return null;
        }
        return editor.getCaretModel().getLogicalPosition().line;
    }

    @Nullable
    protected DiffContent createRemote(VcsRevisionNumber revisionNumber) throws IOException, VcsException {
        DocumentContent diffContent;
        ContentRevision fileRevision = this.myDiffProvider.createFileContent(revisionNumber, this.mySelectedFile);
        if (fileRevision == null) {
            return null;
        }
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (fileRevision instanceof ByteBackedContentRevision) {
            byte[] content = ((ByteBackedContentRevision)fileRevision).getContentAsBytes();
            if (content == null) {
                throw new VcsException("Failed to load content");
            }
            diffContent = contentFactory.createFromBytes(this.myProject, content, fileRevision.getFile());
        } else {
            String content = fileRevision.getContent();
            if (content == null) {
                throw new VcsException("Failed to load content");
            }
            diffContent = contentFactory.create(this.myProject, content, fileRevision.getFile());
        }
        diffContent.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)Pair.create((Object)fileRevision.getFile(), (Object)fileRevision.getRevisionNumber()));
        return diffContent;
    }

    public void showDiff() {
        final Ref exceptionRef = new Ref();
        final Ref requestRef = new Ref();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.mySelectedFile);
        final BackgroundableActionLock lock = BackgroundableActionLock.getLock(this.myProject, new Object[]{VcsBackgroundableActions.COMPARE_WITH, filePath});
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, VcsBundle.message((String)"show.diff.progress.title.detailed", (Object[])new Object[]{this.mySelectedFile.getPresentableUrl()}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsRevisionNumber revisionNumber = DiffActionExecutor.this.getRevisionNumber();
                try {
                    SimpleDiffRequest request;
                    String title2;
                    String title1;
                    if (revisionNumber == null) {
                        return;
                    }
                    DiffContent content1 = DiffActionExecutor.this.createRemote(revisionNumber);
                    if (content1 == null) {
                        return;
                    }
                    DiffContent content2 = DiffContentFactory.getInstance().create(this.myProject, DiffActionExecutor.this.mySelectedFile);
                    String title = DiffRequestFactory.getInstance().getTitle(DiffActionExecutor.this.mySelectedFile);
                    boolean inverted = false;
                    FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(DiffActionExecutor.this.mySelectedFile);
                    if (FileStatus.NOT_CHANGED.equals(status) || FileStatus.UNKNOWN.equals(status) || FileStatus.IGNORED.equals(status)) {
                        VcsRevisionNumber currentRevision = DiffActionExecutor.this.myDiffProvider.getCurrentRevision(DiffActionExecutor.this.mySelectedFile);
                        inverted = revisionNumber.compareTo((Object)currentRevision) > 0;
                        title1 = revisionNumber.asString();
                        title2 = VcsBundle.message((String)"diff.title.local.with.number", (Object[])new Object[]{currentRevision.asString()});
                    } else {
                        title1 = revisionNumber.asString();
                        title2 = VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
                    }
                    if (inverted) {
                        request = new SimpleDiffRequest(title, content2, content1, title2, title1);
                        if (DiffActionExecutor.this.mySelectedLine != null) {
                            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)DiffActionExecutor.this.mySelectedLine));
                        }
                        request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
                        requestRef.set((Object)request);
                    } else {
                        request = new SimpleDiffRequest(title, content1, content2, title1, title2);
                        if (DiffActionExecutor.this.mySelectedLine != null) {
                            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)DiffActionExecutor.this.mySelectedLine));
                        }
                        request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
                        requestRef.set((Object)request);
                    }
                }
                catch (ProcessCanceledException content1) {
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (IOException e) {
                    exceptionRef.set((Object)new VcsException((Throwable)e));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)((Object)exceptionRef.get()), VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                    return;
                }
                if (!requestRef.isNull()) {
                    DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)requestRef.get());
                }
            }

            public void onFinished() {
                lock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/DiffActionExecutor$1", "run"));
            }
        };
        lock.lock();
        ProgressManager.getInstance().run((Task)task);
    }

    @Deprecated
    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
        DiffActionExecutor.showDiff(diffProvider, revisionNumber, selectedFile, project);
    }

    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project) {
        CompareToFixedExecutor executor = new CompareToFixedExecutor(diffProvider, selectedFile, project, null, revisionNumber);
        executor.showDiff();
    }

    @Nullable
    protected abstract VcsRevisionNumber getRevisionNumber();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DeletionAwareExecutor
    extends DiffActionExecutor {
        private boolean myFileStillExists;

        public DeletionAwareExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
            if (diffProvider == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(2);
            }
            super(diffProvider, selectedFile, project, editor);
        }

        @Override
        protected VcsRevisionNumber getRevisionNumber() {
            ItemLatestState itemState = this.myDiffProvider.getLastRevision(this.mySelectedFile);
            if (itemState == null) {
                return null;
            }
            this.myFileStillExists = itemState.isItemExists();
            return itemState.getNumber();
        }

        @Override
        protected DiffContent createRemote(VcsRevisionNumber revisionNumber) throws IOException, VcsException {
            if (this.myFileStillExists) {
                return super.createRemote(revisionNumber);
            }
            return DiffContentFactory.getInstance().createEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$DeletionAwareExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CompareToCurrentExecutor
    extends DiffActionExecutor {
        public CompareToCurrentExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor) {
            if (diffProvider == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(2);
            }
            super(diffProvider, selectedFile, project, editor);
        }

        @Override
        @Nullable
        protected VcsRevisionNumber getRevisionNumber() {
            return this.myDiffProvider.getCurrentRevision(this.mySelectedFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$CompareToCurrentExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CompareToFixedExecutor
    extends DiffActionExecutor {
        private final VcsRevisionNumber myNumber;

        public CompareToFixedExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor, @NotNull VcsRevisionNumber number) {
            if (diffProvider == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(2);
            }
            if (number == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(3);
            }
            super(diffProvider, selectedFile, project, editor);
            this.myNumber = number;
        }

        @Override
        protected VcsRevisionNumber getRevisionNumber() {
            return this.myNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$CompareToFixedExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

