/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.util;

import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.psi.PuppetQuotedString;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetElementFactory {
    @NotNull
    public static PsiElement createLeafElement(Project project, String expression, int position) {
        PsiFile file = PuppetElementFactory.createDummyFile(project, expression);
        PsiElement result = file.findElementAt(position);
        if (result == null) {
            throw new RuntimeException("Cannot instantiate var");
        }
        PsiElement psiElement = result.getParent();
        if (psiElement == null) {
            PuppetElementFactory.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Nullable
    public static PuppetQuotedString createQuotedStringElementWithContent(Project project, String content) {
        return PuppetElementFactory.createQuotedStringElement(project, "'" + PuppetElementFactory.smartEscapeChar(content, '\'') + "'");
    }

    public static String smartEscapeChar(@NotNull String source, char charToEscape) {
        if (source == null) {
            PuppetElementFactory.$$$reportNull$$$0(1);
        }
        return StringUtil.escapeChar((String)StringUtil.escapeChar((String)source, (char)'\\'), (char)charToEscape);
    }

    @NotNull
    public static PuppetQuotedString createQuotedStringElement(Project project, String newString) {
        PuppetQuotedString result = (PuppetQuotedString)PsiTreeUtil.findChildOfType((PsiElement)PuppetElementFactory.createDummyFile(project, newString), PuppetQuotedString.class);
        assert (result != null) : "Got incorrect result with: " + newString;
        PuppetQuotedString puppetQuotedString = result;
        if (puppetQuotedString == null) {
            PuppetElementFactory.$$$reportNull$$$0(2);
        }
        return puppetQuotedString;
    }

    public static PsiFile createDummyFile(Project myProject, String text) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)myProject);
        String name = "dummy." + PuppetFileType.INSTANCE.getDefaultExtension();
        return factory.createFileFromText(name, (FileType)PuppetFileType.INSTANCE, (CharSequence)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/util/PuppetElementFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/util/PuppetElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuotedStringElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "smartEscapeChar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

