/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby;

import com.intellij.diagram.ChangeTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class RubyChangeTracker
extends ChangeTracker<RFile, PsiNamedElement, PsiElement> {
    public static final PsiFilter[] NODE_FILTERS = new PsiFilter[]{new PsiFilter(RFile.class)};
    public static final PsiFilter[] CONTENT_FILTERS = new PsiFilter[]{new PsiFilter<RClass>(RClass.class){

        public boolean areEquivalent(RClass e1, RClass e2) {
            return StringUtil.equals((CharSequence)e1.getName(), (CharSequence)e2.getName());
        }
    }, new PsiFilter<RMethod>(RMethod.class){

        public boolean accept(RMethod element) {
            return element.getParent().getParent() instanceof RFile;
        }
    }};
    private Map<RFile, FileStatus> map = null;

    public RubyChangeTracker(Project project, @Nullable PsiFile before, @Nullable PsiFile after) {
        super(project, before, after);
    }

    public PsiFilter<RFile>[] getNodeFilters() {
        return NODE_FILTERS;
    }

    public PsiFilter<PsiNamedElement>[] getNodeContentFilters() {
        return CONTENT_FILTERS;
    }

    public Map<RFile, FileStatus> getNodeElements() {
        if (this.map == null) {
            this.map = new HashMap<RFile, FileStatus>();
            RFile after = (RFile)this.getAfter();
            RFile before = (RFile)this.getBefore();
            if (after == null) {
                this.map.put(before, FileStatus.DELETED);
            } else if (before == null) {
                this.map.put(after, FileStatus.ADDED);
            } else {
                this.map.put(after, FileStatus.MODIFIED);
            }
        }
        return this.map;
    }

    public ChangeTracker.RelationshipInfo[] getRelationships() {
        return ChangeTracker.RelationshipInfo.EMPTY;
    }

    public PsiNamedElement findElementByFQN(Project project, String fqn) {
        PsiFile psiFile;
        VirtualFile vf;
        File file = new File(fqn);
        if (file.exists() && (vf = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(vf)) instanceof RFile) {
            return psiFile;
        }
        return null;
    }
}

