/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.lang.javascript.linter.SharedConfigurationPaths;
import com.intellij.lang.javascript.linter.jscs.JscsInspection;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JscsConfiguration", storages={@Storage(value="jsLinters/jscs.xml")})
public class JscsConfiguration
extends JSLinterConfiguration<JscsState> {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"JSCS Messages");
    public static final NotificationGroup IMPORT_CONFIG_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSCS Config Import");
    public static final String LOG_CATEGORY = "#com.intellij.lang.javascript.linter.jscs.Jscs";
    private static final String JSCS_ELEMENT_NAME = "jscs";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String PRESET = "jscs-preset";
    private final PathHolder myPathHolder;
    private final JSLinterPackage myPackage;
    private JscsState DEFAULT_STATE;

    public JscsConfiguration(@NotNull Project project, @NotNull SharedConfigurationPaths paths) {
        if (project == null) {
            JscsConfiguration.$$$reportNull$$$0(0);
        }
        if (paths == null) {
            JscsConfiguration.$$$reportNull$$$0(1);
        }
        super(project);
        this.myPathHolder = paths.createPathHolder(new Runnable(){

            @Override
            public void run() {
                ExtendedLinterState state = JscsConfiguration.this.getExtendedState();
                ((JscsState)state.getState()).setCustomConfigFilePath(JscsConfiguration.this.myPathHolder.getPath());
                JscsConfiguration.this.setExtendedState(state);
            }
        });
        this.myPackage = new JSLinterPackage(project, JSCS_ELEMENT_NAME);
    }

    @Override
    protected void savePrivateSettings(@NotNull JscsState state) {
        if (state == null) {
            JscsConfiguration.$$$reportNull$$$0(2);
        }
        this.myPathHolder.setPath(state.getCustomConfigFilePath());
        this.storeLinterLocalPaths(state);
    }

    @Override
    @NotNull
    public JscsState loadPrivateSettings(@NotNull JscsState state) {
        if (state == null) {
            JscsConfiguration.$$$reportNull$$$0(3);
        }
        this.myPathHolder.setPath(state.getCustomConfigFilePath());
        JscsState.Builder builder = new JscsState.Builder(state);
        this.restoreLinterLocalPaths(builder);
        JscsState jscsState = builder.build();
        if (jscsState == null) {
            JscsConfiguration.$$$reportNull$$$0(4);
        }
        return jscsState;
    }

    @NotNull
    public static JscsConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            JscsConfiguration.$$$reportNull$$$0(5);
        }
        JscsConfiguration jscsConfiguration = JSLinterConfiguration.getInstance(project, JscsConfiguration.class);
        if (jscsConfiguration == null) {
            JscsConfiguration.$$$reportNull$$$0(6);
        }
        return jscsConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (JscsInspection.class == null) {
            JscsConfiguration.$$$reportNull$$$0(7);
        }
        return JscsInspection.class;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull JscsState state) {
        JscsPreset preset;
        String customConfigFilePath;
        if (state == null) {
            JscsConfiguration.$$$reportNull$$$0(8);
        }
        Element root = new Element(JSCS_ELEMENT_NAME);
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!StringUtil.isEmptyOrSpaces((String)(customConfigFilePath = state.getCustomConfigFilePath()))) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        if ((preset = state.getPreset()) != null) {
            root.setAttribute(PRESET, preset.name());
        }
        this.storeLinterLocalPaths(state);
        Element element = root;
        if (element == null) {
            JscsConfiguration.$$$reportNull$$$0(9);
        }
        return element;
    }

    @Override
    @NotNull
    protected JscsState fromXml(@NotNull Element element) {
        if (element == null) {
            JscsConfiguration.$$$reportNull$$$0(10);
        }
        JscsState.Builder builder = new JscsState.Builder();
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        String presetName = element.getAttributeValue(PRESET);
        if (!StringUtil.isEmptyOrSpaces((String)presetName)) {
            builder.setPreset(JscsPreset.safeValueOf(presetName));
        }
        this.restoreLinterLocalPaths(builder);
        JscsState jscsState = builder.build();
        if (jscsState == null) {
            JscsConfiguration.$$$reportNull$$$0(11);
        }
        return jscsState;
    }

    private void storeLinterLocalPaths(@NotNull JscsState state) {
        if (state == null) {
            JscsConfiguration.$$$reportNull$$$0(12);
        }
        this.myPackage.force(state.getInterpreterRef(), state.getPackagePath());
    }

    private void restoreLinterLocalPaths(JscsState.Builder builder) {
        this.myPackage.readOrDetect();
        builder.setNodePath(this.myPackage.getInterpreter());
        builder.setPackagePath(new NodePackage(this.myPackage.getPackagePath()));
    }

    @Override
    @NotNull
    protected JscsState getDefaultState() {
        JscsState state = this.DEFAULT_STATE;
        if (state != null) {
            JscsState jscsState = state;
            if (jscsState == null) {
                JscsConfiguration.$$$reportNull$$$0(13);
            }
            return jscsState;
        }
        JscsState.Builder builder = new JscsState.Builder();
        builder.setCustomConfigFileUsed(false);
        this.DEFAULT_STATE = state = builder.build();
        JscsState jscsState = state;
        if (jscsState == null) {
            JscsConfiguration.$$$reportNull$$$0(14);
        }
        return jscsState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/JscsConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toXml";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "storeLinterLocalPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

