/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.highlighting;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.plugins.ruby.erb.ERbLanguage;
import org.jetbrains.plugins.ruby.erb.highlighting.ERbHighlighter;
import org.jetbrains.plugins.ruby.erb.psi.ERbFile;
import org.jetbrains.plugins.ruby.erb.psi.ERbPsiUtil;
import org.jetbrains.plugins.ruby.erb.psi.ERbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public class ERbEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private final Project c;
    private final VirtualFile b;
    private Language a;

    public ERbEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile file) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ERbLanguage.RHTML, (Project)project, (VirtualFile)file), scheme);
        this.c = project;
        this.b = file;
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RubyLanguage.INSTANCE, (Project)project, (VirtualFile)file);
        LayerDescriptor layerDescriptor = new LayerDescriptor(syntaxHighlighter, "\n", ERbHighlighter.RHTML_SCRIPTING_BACKGROUND);
        this.registerLayer(ERbTokenTypes.RUBY_CODE_CHARACTERS, layerDescriptor);
    }

    protected boolean updateLayers() {
        Language language = this.a();
        if (!Comparing.equal((Object)this.a, (Object)language)) {
            this.unregisterLayer(ERbTokenTypes.TEMPLATE_CHARACTERS_IN_RHTML);
            this.a = language;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.a, (Project)this.c, (VirtualFile)this.b);
            this.registerLayer(ERbTokenTypes.TEMPLATE_CHARACTERS_IN_RHTML, new LayerDescriptor(syntaxHighlighter, "", null));
            return true;
        }
        return false;
    }

    private Language a() {
        PsiDocumentManager psiDocumentManager;
        PsiFile psiFile;
        if (this.c != null && this.getDocument() != null && ERbPsiUtil.isInERbFile((PsiElement)(psiFile = (psiDocumentManager = PsiDocumentManager.getInstance((Project)this.c)).getPsiFile(this.getDocument())))) {
            ERbFile eRbFile = ERbPsiUtil.getERbFileRoot((PsiElement)psiFile);
            assert (eRbFile != null);
            FileViewProvider fileViewProvider = eRbFile.getViewProvider();
            if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
                return ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
            }
        }
        return HTMLLanguage.INSTANCE;
    }
}

