/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import b.h.la;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySuspendContext;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebuggerEvaluator
extends XDebuggerEvaluator {
    private final Project b;
    protected RubyStackFrame myFrame;
    private final RubyDebuggerProxy a;
    private static final Logger c;
    private static final long d;

    public RubyDebuggerEvaluator(Project project, @NotNull RubyStackFrame frame, RubyDebuggerProxy debuggerProxy) {
        if (frame == null) {
            RubyDebuggerEvaluator.a(0);
        }
        this.b = project;
        this.myFrame = frame;
        this.a = debuggerProxy;
    }

    public static boolean evaluateCondition(RubySuspendContext rubySuspendContext, @Nullable XExpression condition) {
        XStackFrame xStackFrame;
        if (condition == null || StringUtil.isEmptyOrSpaces((String)condition.getExpression())) {
            return true;
        }
        XExecutionStack xExecutionStack = rubySuspendContext.getActiveExecutionStack();
        if (xExecutionStack != null && (xStackFrame = xExecutionStack.getTopFrame()) != null) {
            try {
                RubyVariable rubyVariable = ((RubyStackFrame)xStackFrame).getFrame().inspectExpression(condition.getExpression());
                if (rubyVariable == null) {
                    return false;
                }
                String string = rubyVariable.getValue().getValueString();
                return !RubyTokenTypes.kFALSE.toString().equals(string) && !RubyTokenTypes.kNIL.toString().equals(string);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                c.info((Throwable)rubyDebuggerException);
            }
        }
        return true;
    }

    @NotNull
    public static String evaluateExpression(@NotNull RubySuspendContext rubySuspendContext, @Nullable String expression) {
        XStackFrame xStackFrame;
        XExecutionStack xExecutionStack;
        if (rubySuspendContext == null) {
            RubyDebuggerEvaluator.a(1);
        }
        if ((xExecutionStack = rubySuspendContext.getActiveExecutionStack()) != null && (xStackFrame = xExecutionStack.getTopFrame()) != null) {
            String string = RubyDebuggerEvaluator.evaluateExpression(xStackFrame, expression);
            String string2 = string != null ? string : "";
            if (string2 == null) {
                RubyDebuggerEvaluator.a(2);
            }
            return string2;
        }
        if ("" == null) {
            RubyDebuggerEvaluator.a(3);
        }
        return "";
    }

    @Nullable
    public static String evaluateExpression(@NotNull XStackFrame frame, @Nullable String expression) {
        if (frame == null) {
            RubyDebuggerEvaluator.a(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            return null;
        }
        try {
            RubyVariable rubyVariable = ((RubyStackFrame)frame).getFrame().inspectExpression(expression);
            if (rubyVariable == null) {
                return null;
            }
            return rubyVariable.getValue().getValueString();
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            c.info((Throwable)rubyDebuggerException);
            return null;
        }
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            RubyDebuggerEvaluator.a(5);
        }
        if (callback == null) {
            RubyDebuggerEvaluator.a(6);
        }
        ApplicationManagerEx.getApplicationEx().executeOnPooledThread(() -> {
            long l2 = d ^ 0x354483F72C34L;
            if (callback == null) {
                RubyDebuggerEvaluator.a(8);
            }
            if (expression == null) {
                RubyDebuggerEvaluator.a(9);
            }
            if (!this.a.waitForDebuggerProxyReady()) {
                callback.errorOccurred(RBundle.message((String)"ruby.debugger.is.not.ready"));
                return;
            }
            try {
                RubyVariable rubyVariable = this.a.inspectExpression(this.myFrame.getFrame(), expression);
                if (rubyVariable == null) {
                    callback.errorOccurred(RBundle.message((String)"ruby.debugger.couldnt.evaluate", (Object[])new Object[]{expression}));
                    return;
                }
                callback.evaluated(RubyDebugValueFactory.create(this.b, expressionPosition, this.myFrame, expression, rubyVariable, false));
                RubyDebuggerSupportUtils.invalidateSessionFrames(XDebuggerManager.getInstance((Project)this.b).getCurrentSession());
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                c.info((Throwable)rubyDebuggerException);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(RBundle.message((String)"ruby.debugger.couldnt.evaluate", (Object[])new Object[]{expression})).append("\n");
                stringBuilder.append(rubyDebuggerException.getMessage());
                callback.errorOccurred(stringBuilder.toString());
            }
        });
    }

    @Nullable
    public ExpressionInfo getExpressionInfo(@NotNull String expression) {
        if (expression == null) {
            RubyDebuggerEvaluator.a(7);
        }
        if (!this.a.waitForDebuggerProxyReady()) {
            return null;
        }
        try {
            return this.a.getExpressionInfo(this.myFrame.getFrame(), expression);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            c.info((Throwable)rubyDebuggerException);
            return null;
        }
    }

    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return RubyDebuggerSupportUtils.getExpressionAtOffset(project, document, offset);
    }

    static {
        d = la.a(-7895832127427445614L, 2582084649794412486L, MethodHandles.lookup().lookupClass()).a(179212474044929L);
        c = Logger.getInstance(RubyDebuggerEvaluator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x5D6DEF01B900L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySuspendContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerEvaluator";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerEvaluator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

